/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.databinding.conformance;

import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.IStaleListener;
import org.eclipse.core.databinding.observable.StaleEvent;
import org.eclipse.jface.databinding.conformance.ObservableDelegateTest;
import org.eclipse.jface.databinding.conformance.delegate.IObservableContractDelegate;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ObservableStaleContractTest
extends ObservableDelegateTest {
    private final IObservableContractDelegate delegate;
    private IObservable observable;

    public ObservableStaleContractTest(IObservableContractDelegate delegate) {
        super(delegate);
        this.delegate = delegate;
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.observable = this.getObservable();
    }

    @Test
    public void testIsStale_TrueWhenStale() throws Exception {
        this.delegate.setStale(this.observable, true);
        Assert.assertTrue((String)this.formatFail("When stale isStale() should return true."), (boolean)this.observable.isStale());
    }

    @Test
    public void testIsStale_FalseWhenNotStale() throws Exception {
        this.delegate.setStale(this.observable, false);
        Assert.assertFalse((String)this.formatFail("When not stale isStale() should return false."), (boolean)this.observable.isStale());
    }

    @Test
    public void testBecomingStaleFiresStaleEvent() throws Exception {
        StaleListener listener = new StaleListener();
        this.ensureStale(this.observable, false);
        this.observable.addStaleListener((IStaleListener)listener);
        this.delegate.setStale(this.observable, true);
        Assert.assertEquals((String)this.formatFail("When becoming stale listeners should be notified."), (long)1L, (long)listener.count);
    }

    @Test
    public void testStaleEventObservable() throws Exception {
        StaleListener listener = new StaleListener();
        this.ensureStale(this.observable, false);
        this.observable.addStaleListener((IStaleListener)listener);
        this.delegate.setStale(this.observable, true);
        StaleEvent event = listener.event;
        Assert.assertNotNull((String)this.formatFail("stale event was null"), (Object)event);
        Assert.assertEquals((String)this.formatFail("When notifying listeners of becoming stale the observable should be the source of the event."), (Object)this.observable, (Object)event.getObservable());
    }

    @Test
    public void testRemoveStaleListener_RemovesListener() throws Exception {
        StaleListener listener = new StaleListener();
        this.observable.addStaleListener((IStaleListener)listener);
        this.ensureStale(this.observable, false);
        this.delegate.setStale(this.observable, true);
        Assert.assertEquals((String)this.formatFail("set stale did not notify listeners"), (long)1L, (long)listener.count);
        this.observable.removeStaleListener((IStaleListener)listener);
        this.ensureStale(this.observable, false);
        this.delegate.setStale(this.observable, true);
        Assert.assertEquals((String)this.formatFail("Once removed stale listeners should not be notified of becoming stale."), (long)1L, (long)listener.count);
    }

    @Test
    public void testStaleListenersAreNotNotifiedWhenObservableIsNoLongerStale() throws Exception {
        this.ensureStale(this.observable, true);
        StaleListener listener = new StaleListener();
        this.observable.addStaleListener((IStaleListener)listener);
        this.delegate.setStale(this.observable, false);
        Assert.assertEquals((String)this.formatFail("Stale listeners should not be notified when the stale state changes from true to false."), (long)0L, (long)listener.count);
    }

    @Test
    public void testObservableRealmIsCurrentOnStale() throws Exception {
        this.ensureStale(this.observable, false);
        StaleListener listener = new StaleListener();
        this.observable.addStaleListener((IStaleListener)listener);
        this.delegate.setStale(this.observable, true);
        Assert.assertTrue((String)this.formatFail("When notifying listeners of becoming stale the observable's realm should be the current realm."), (boolean)listener.isCurrentRealm);
    }

    private void ensureStale(IObservable observable, boolean stale) {
        if (observable.isStale() != stale) {
            this.delegate.setStale(observable, stale);
        }
        Assert.assertEquals((Object)stale, (Object)observable.isStale());
    }

    static class StaleListener
    implements IStaleListener {
        int count;
        StaleEvent event;
        boolean isCurrentRealm;

        StaleListener() {
        }

        public void handleStale(StaleEvent staleEvent) {
            ++this.count;
            this.event = staleEvent;
            this.isCurrentRealm = staleEvent.getObservable().getRealm().isCurrent();
        }
    }
}

