/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.databinding.conformance;

import java.util.ArrayList;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.jface.databinding.conformance.ObservableContractTest;
import org.eclipse.jface.databinding.conformance.delegate.IObservableValueContractDelegate;
import org.eclipse.jface.databinding.conformance.util.CurrentRealm;
import org.eclipse.jface.databinding.conformance.util.RealmTester;
import org.eclipse.jface.databinding.conformance.util.ValueChangeEventTracker;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ObservableValueContractTest
extends ObservableContractTest {
    private final IObservableValueContractDelegate delegate;
    private IObservableValue observable;

    public ObservableValueContractTest(IObservableValueContractDelegate delegate) {
        super(delegate);
        this.delegate = delegate;
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.observable = (IObservableValue)this.getObservable();
    }

    @Test
    public void testChange_ValueChangeEvent() throws Exception {
        ValueChangeEventTracker listener = ValueChangeEventTracker.observe(this.observable);
        this.delegate.change((IObservable)this.observable);
        Assert.assertEquals((String)this.formatFail("On change value change listeners should be notified."), (long)1L, (long)listener.count);
    }

    @Test
    public void testGetValueType_ExpectedType() throws Exception {
        Assert.assertEquals((String)this.formatFail("Type of the value should be returned from getType()."), (Object)this.delegate.getValueType(this.observable), (Object)this.observable.getValueType());
    }

    @Test
    public void testChange_OrderOfNotifications() throws Exception {
        final ArrayList listeners = new ArrayList();
        IChangeListener changeListener = new IChangeListener(){

            public void handleChange(ChangeEvent event) {
                listeners.add(this);
            }
        };
        IValueChangeListener valueChangeListener = new IValueChangeListener(){

            public void handleValueChange(ValueChangeEvent event) {
                listeners.add(this);
            }
        };
        this.observable.addChangeListener(changeListener);
        this.observable.addValueChangeListener(valueChangeListener);
        this.delegate.change((IObservable)this.observable);
        Assert.assertTrue((String)this.formatFail("Change Listeners were not notified on change."), (listeners.size() > 0 ? 1 : 0) != 0);
        Assert.assertEquals((String)this.formatFail("Change listeners should be notified before value change listeners."), (Object)changeListener, listeners.get(0));
        Assert.assertEquals((String)this.formatFail("Value change listeners should be notified after change listeners."), (Object)valueChangeListener, listeners.get(1));
    }

    @Test
    public void testChange_ValueChangeEventDiff() throws Exception {
        ValueChangeEventTracker listener = ValueChangeEventTracker.observe(this.observable);
        Object oldValue = this.observable.getValue();
        this.delegate.change((IObservable)this.observable);
        ValueChangeEvent event = listener.event;
        Assert.assertTrue((String)this.formatFail("Change Listeners were not notified on change."), (listener.count > 0 ? 1 : 0) != 0);
        Assert.assertEquals((String)this.formatFail("When a value change event is fired the old value should be the previous value of the observable value."), (Object)oldValue, (Object)event.diff.getOldValue());
        Assert.assertEquals((String)this.formatFail("When a value change event is fired the new value should be the same as the current value of the observable value."), (Object)this.observable.getValue(), (Object)event.diff.getNewValue());
    }

    @Test
    public void testChange_ValueChangeEventFiredAfterValueIsSet() throws Exception {
        class ValueChangeListener
        implements IValueChangeListener {
            Object value;

            ValueChangeListener() {
            }

            public void handleValueChange(ValueChangeEvent event) {
                this.value = event.getObservableValue().getValue();
            }
        }
        ValueChangeListener listener = new ValueChangeListener();
        this.observable.addValueChangeListener((IValueChangeListener)listener);
        this.delegate.change((IObservable)this.observable);
        Assert.assertEquals((String)this.formatFail("When a value change event is fired the new value should be applied before firing the change event."), (Object)listener.value, (Object)this.observable.getValue());
    }

    @Test
    public void testRemoveValueChangeListener_RemovesListener() throws Exception {
        ValueChangeEventTracker listener = ValueChangeEventTracker.observe(this.observable);
        this.delegate.change((IObservable)this.observable);
        Assert.assertEquals((String)this.formatFail("Value change listeners should be notified on change."), (long)1L, (long)listener.count);
        this.observable.removeValueChangeListener(listener);
        this.delegate.change((IObservable)this.observable);
        Assert.assertEquals((String)this.formatFail("Value change listeners should not be notified after they've been removed from the observable."), (long)1L, (long)listener.count);
    }

    @Test
    public void testGetValue_GetterCalled() throws Exception {
        this.assertGetterCalled(() -> {
            Object object = this.observable.getValue();
        }, this.formatFail("IObservableValue.getValue()"), (IObservable)this.observable);
    }

    @Test
    public void testGetValue_RealmCheck() throws Exception {
        RealmTester.exerciseCurrent(() -> {
            Object object = this.observable.getValue();
        }, (CurrentRealm)this.observable.getRealm());
    }
}

