/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.examples.xml;

import java.util.ArrayList;
import java.util.Vector;
import org.eclipse.compare.examples.xml.XMLNode;
import org.eclipse.compare.rangedifferencer.IRangeComparator;
import org.eclipse.compare.rangedifferencer.RangeDifference;
import org.eclipse.compare.rangedifferencer.RangeDifferencer;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class AbstractMatching {
    protected static final int NO_ENTRY = -1;
    protected static final String SIGN_ELEMENT = "$element$";
    int[][] fDT;
    ArrayList[][] fDT_Matchings;
    Vector fNLeft;
    Vector fNRight;
    Vector fMatches;

    protected void findLeaves(XMLNode root, ArrayList<XMLNode> leaves) {
        if (this.isLeaf(root)) {
            leaves.add(root);
        } else {
            Object[] children;
            Object[] objectArray = children = root.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Object child = objectArray[n2];
                this.findLeaves((XMLNode)((Object)child), leaves);
                ++n2;
            }
        }
    }

    protected boolean isLeaf(XMLNode x) {
        if (x == null) {
            return true;
        }
        return x.getChildren() == null || x.getChildren().length <= 0;
    }

    protected void numberNodes(XMLNode root, Vector<XMLNode> numbering) {
        if (root != null) {
            numbering.add(root);
            Object[] children = root.getChildren();
            if (children != null) {
                Object[] objectArray = children;
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    Object child = objectArray[n2];
                    this.numberNodes((XMLNode)((Object)child), numbering);
                    ++n2;
                }
            }
        }
    }

    protected int countNodes(XMLNode root) {
        Object[] children;
        if (root == null) {
            return 0;
        }
        int count = 1;
        if (this.isLeaf(root)) {
            return count;
        }
        Object[] objectArray = children = root.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Object child = objectArray[n2];
            count += this.countNodes((XMLNode)((Object)child));
            ++n2;
        }
        return count;
    }

    protected int indexOfLN(XMLNode x) {
        int i = 0;
        while (i < this.fNLeft.size() && this.fNLeft.elementAt(i) != x) {
            ++i;
        }
        return i;
    }

    protected int indexOfRN(XMLNode y) {
        int j = 0;
        while (j < this.fNRight.size() && this.fNRight.elementAt(j) != y) {
            ++j;
        }
        return j;
    }

    public Vector getMatches() {
        return this.fMatches;
    }

    protected int handleRangeDifferencer(Object[] xc_elements, Object[] yc_elements, ArrayList<Match> DTMatching, int distance) {
        RangeDifference[] differences = RangeDifferencer.findDifferences((IRangeComparator)new XMLComparator(xc_elements), (IRangeComparator)new XMLComparator(yc_elements));
        int cur_pos_left = 0;
        int cur_pos_right = 0;
        RangeDifference[] rangeDifferenceArray = differences;
        int n = differences.length;
        int n2 = 0;
        while (n2 < n) {
            int greater_length;
            int smaller_length;
            boolean leftGreater;
            RangeDifference rd = rangeDifferenceArray[n2];
            int equal_length = rd.leftStart();
            while (cur_pos_left < equal_length) {
                DTMatching.add(new Match((XMLNode)((Object)xc_elements[cur_pos_left]), (XMLNode)((Object)yc_elements[cur_pos_right])));
                ++cur_pos_left;
                ++cur_pos_right;
            }
            boolean bl = leftGreater = rd.leftLength() > rd.rightLength();
            if (leftGreater) {
                smaller_length = rd.rightLength();
                greater_length = rd.leftLength();
            } else {
                smaller_length = rd.leftLength();
                greater_length = rd.rightLength();
            }
            int j = 0;
            while (j < smaller_length) {
                distance += this.dist((XMLNode)((Object)xc_elements[cur_pos_left]), (XMLNode)((Object)yc_elements[cur_pos_right]));
                DTMatching.add(new Match((XMLNode)((Object)xc_elements[cur_pos_left]), (XMLNode)((Object)yc_elements[cur_pos_right])));
                ++cur_pos_left;
                ++cur_pos_right;
                ++j;
            }
            if (leftGreater) {
                j = smaller_length;
                while (j < greater_length) {
                    distance += this.countNodes((XMLNode)((Object)xc_elements[cur_pos_left]));
                    DTMatching.add(new Match((XMLNode)((Object)xc_elements[cur_pos_left]), null));
                    ++cur_pos_left;
                    ++j;
                }
            } else {
                j = smaller_length;
                while (j < greater_length) {
                    distance += this.countNodes((XMLNode)((Object)yc_elements[cur_pos_right]));
                    DTMatching.add(new Match(null, (XMLNode)((Object)yc_elements[cur_pos_right])));
                    ++cur_pos_right;
                    ++j;
                }
            }
            ++n2;
        }
        int i = cur_pos_left;
        while (i < xc_elements.length) {
            DTMatching.add(new Match((XMLNode)((Object)xc_elements[cur_pos_left]), (XMLNode)((Object)yc_elements[cur_pos_right])));
            ++cur_pos_left;
            ++cur_pos_right;
            ++i;
        }
        return distance;
    }

    public abstract void match(XMLNode var1, XMLNode var2, boolean var3, IProgressMonitor var4);

    protected int dist(XMLNode x, XMLNode y) {
        int index_y;
        int ret = -1;
        int index_x = this.indexOfLN(x);
        if (this.fDT[index_x][index_y = this.indexOfRN(y)] != -1) {
            return this.fDT[index_x][index_y];
        }
        if (this.isLeaf(x) && this.isLeaf(y)) {
            if (x.getXMLType() == "element") {
                this.fDT[index_x][index_y] = x.getSignature().equals(y.getSignature()) ? (ret = 0) : (ret = 2);
                return ret;
            }
            if (x.getXMLType() == "attribute" || x.getXMLType() == "text") {
                this.fDT[index_x][index_y] = x.getSignature().equals(y.getSignature()) ? (x.getValue().equals(y.getValue()) ? (ret = 0) : (ret = 1)) : (ret = 2);
                return ret;
            }
        } else {
            if (!x.getSignature().equals(y.getSignature())) {
                this.fDT[index_x][index_y] = ret = this.countNodes(x) + this.countNodes(y);
                return ret;
            }
            if (this.isLeaf(x)) {
                this.fDT[index_x][index_y] = ret = this.countNodes(y) - 1;
                return ret;
            }
            if (this.isLeaf(y)) {
                this.fDT[index_x][index_y] = ret = this.countNodes(x) - 1;
                return ret;
            }
            return this.handleXandYnotLeaves(x, y);
        }
        return ret;
    }

    abstract int handleXandYnotLeaves(XMLNode var1, XMLNode var2);

    static class Match {
        public XMLNode fx;
        public XMLNode fy;

        Match(XMLNode x, XMLNode y) {
            this.fx = x;
            this.fy = y;
        }

        public boolean equals(Object obj) {
            Match m;
            if (obj instanceof Match && (m = (Match)obj) != null) {
                return this.fx == m.fx && this.fy == m.fy;
            }
            return false;
        }
    }

    protected class XMLComparator
    implements IRangeComparator {
        private final Object[] fXML_elements;

        public XMLComparator(Object[] xml_elements) {
            this.fXML_elements = xml_elements;
        }

        public int getRangeCount() {
            return this.fXML_elements.length;
        }

        public boolean rangesEqual(int thisIndex, IRangeComparator other_irc, int otherIndex) {
            if (other_irc instanceof XMLComparator) {
                XMLComparator other = (XMLComparator)other_irc;
                boolean sameId = false;
                XMLNode thisNode = (XMLNode)((Object)this.fXML_elements[thisIndex]);
                XMLNode otherNode = (XMLNode)((Object)other.getXML_elements()[otherIndex]);
                if (thisNode.usesIDMAP() && otherNode.usesIDMAP() && otherNode.getOrigId().equals(thisNode.getOrigId())) {
                    sameId = true;
                }
                int distance = AbstractMatching.this.dist(thisNode, otherNode);
                return sameId || distance == 0;
            }
            return false;
        }

        public boolean skipRangeComparison(int length, int maxLength, IRangeComparator other) {
            return false;
        }

        public Object[] getXML_elements() {
            return this.fXML_elements;
        }
    }
}

