/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.examples.xml;

import java.util.HashMap;
import org.eclipse.compare.examples.xml.Mapping;
import org.eclipse.compare.examples.xml.XMLCompareMessages;
import org.eclipse.compare.examples.xml.XMLComparePreferencePage;
import org.eclipse.compare.examples.xml.ui.StatusDialog;
import org.eclipse.compare.examples.xml.ui.StatusInfo;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class XMLCompareEditMappingDialog
extends StatusDialog {
    private final Mapping fMapping;
    private final HashMap fIdmapHM;
    private final boolean fEdit;
    private Text fElementText;
    private Text fSignatureText;
    private Text fIdAttributeText;
    private Button fIdTypeAttributeButton;
    private Button fIdTypeChildBodyButton;

    public XMLCompareEditMappingDialog(Shell parent, Mapping mapping, HashMap idmapHM, boolean edit) {
        super(parent);
        int shellStyle = this.getShellStyle();
        this.setShellStyle(shellStyle | 0x400 | 0x10);
        this.fEdit = edit;
        if (this.fEdit) {
            this.setTitle(XMLCompareMessages.XMLCompareEditMappingDialog_editTitle);
        } else {
            this.setTitle(XMLCompareMessages.XMLCompareEditMappingDialog_newTitle);
        }
        this.fMapping = mapping;
        this.fIdmapHM = idmapHM;
    }

    protected Control createDialogArea(Composite ancestor) {
        Composite composite = (Composite)super.createDialogArea(ancestor);
        Composite inner = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        inner.setLayout((Layout)layout);
        inner.setLayoutData((Object)new GridData(1808));
        Label label = new Label(inner, 0);
        label.setText(XMLCompareMessages.XMLCompareEditMappingDialog_element);
        label.setLayoutData((Object)new GridData());
        this.fElementText = new Text(inner, 2048);
        this.fElementText.setText(this.fMapping.getElement());
        this.fElementText.setLayoutData((Object)new GridData(768));
        this.fElementText.addModifyListener(e -> this.doValidation());
        label = new Label(inner, 0);
        label.setText(XMLCompareMessages.XMLCompareEditMappingDialog_signature);
        label.setLayoutData((Object)new GridData());
        this.fSignatureText = new Text(inner, 2048);
        this.fSignatureText.setText(this.fMapping.getSignature());
        GridData data = new GridData(768);
        data.widthHint = this.convertWidthInCharsToPixels(50);
        this.fSignatureText.setLayoutData((Object)data);
        this.fSignatureText.addModifyListener(e -> this.doValidation());
        label = new Label(inner, 0);
        label.setText(XMLCompareMessages.XMLCompareEditMappingDialog_idattribute);
        label.setLayoutData((Object)new GridData());
        this.fIdAttributeText = new Text(inner, 2048);
        this.fIdAttributeText.setLayoutData((Object)new GridData(768));
        this.fIdAttributeText.addModifyListener(e -> this.doValidation());
        this.createIdSourceGroup(inner);
        this.fElementText.setFocus();
        return composite;
    }

    private void doValidation() {
        StatusInfo status = new StatusInfo();
        String text = this.fElementText.getText();
        String mappingKey = Mapping.getKey(this.fSignatureText.getText(), text);
        String errormsg = "";
        boolean isError = false;
        if (text.length() == 0) {
            errormsg = XMLCompareMessages.XMLCompareEditMappingDialog_error_noname;
            isError = true;
        } else if (XMLComparePreferencePage.containsInvalidCharacters(text)) {
            if (errormsg == "") {
                errormsg = XMLCompareMessages.XMLCompareEditMappingDialog_error_invalidname;
            }
            isError = true;
        } else if (!this.fEdit && this.fIdmapHM != null && this.fIdmapHM.containsKey(mappingKey)) {
            if (errormsg == "") {
                errormsg = XMLCompareMessages.XMLCompareEditMappingDialog_error_mappingExists;
            }
            isError = true;
        }
        text = this.fSignatureText.getText();
        if (XMLComparePreferencePage.containsInvalidCharacters(text)) {
            if (errormsg == "") {
                errormsg = XMLCompareMessages.XMLCompareEditMappingDialog_error_invalidsignature;
            }
            isError = true;
        }
        if ((text = this.fIdAttributeText.getText()).length() == 0) {
            isError = true;
        } else if (XMLComparePreferencePage.containsInvalidCharacters(text)) {
            if (errormsg == "") {
                errormsg = XMLCompareMessages.XMLCompareEditMappingDialog_error_invalididattribute;
            }
            isError = true;
        }
        if (isError) {
            status.setError(errormsg);
        }
        this.updateStatus(status);
    }

    protected void okPressed() {
        this.fMapping.setElement(this.fElementText.getText());
        this.fMapping.setSignature(this.fSignatureText.getText());
        Object idtext = this.fIdAttributeText.getText();
        if (this.fIdTypeChildBodyButton.getSelection()) {
            idtext = String.valueOf(Character.valueOf('<')) + (String)idtext;
        }
        this.fMapping.setIdAttribute((String)idtext);
        super.okPressed();
    }

    private void createIdSourceGroup(Composite composite) {
        Label titleLabel = new Label(composite, 0);
        titleLabel.setText(XMLCompareMessages.XMLCompareEditMappingDialog_idtype);
        titleLabel.setToolTipText(XMLCompareMessages.XMLCompareEditMappingDialog_idtype_tooltip);
        Composite buttonComposite = new Composite(composite, 16384);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        buttonComposite.setLayout((Layout)layout);
        composite.setData((Object)new GridData());
        this.fIdTypeAttributeButton = this.createRadioButton(buttonComposite, XMLCompareMessages.XMLComparePreference_idtype_attribute);
        this.fIdTypeAttributeButton.setToolTipText(XMLCompareMessages.XMLCompareEditMappingDialog_idtype_attribute_tooltip);
        this.fIdTypeChildBodyButton = this.createRadioButton(buttonComposite, XMLCompareMessages.XMLComparePreference_idtype_child_body);
        this.fIdTypeChildBodyButton.setToolTipText(XMLCompareMessages.XMLCompareEditMappingDialog_idtype_childbody_tooltip);
        String idtext = this.fMapping.getIdAttribute();
        if (this.fEdit && idtext.charAt(0) == '<') {
            idtext = idtext.substring(1, idtext.length());
            this.fIdTypeChildBodyButton.setSelection(true);
        } else {
            this.fIdTypeAttributeButton.setSelection(true);
        }
        this.fIdAttributeText.setText(idtext);
    }

    private Button createRadioButton(Composite parent, String label) {
        Button button = new Button(parent, 16400);
        button.setText(label);
        GridData data = new GridData();
        button.setLayoutData((Object)data);
        return button;
    }
}

