/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.examples.xml;

import java.util.ArrayList;
import org.eclipse.compare.examples.xml.Mapping;
import org.eclipse.compare.examples.xml.XMLCompareMessages;
import org.eclipse.compare.examples.xml.XMLComparePreferencePage;
import org.eclipse.compare.examples.xml.ui.StatusDialog;
import org.eclipse.compare.examples.xml.ui.StatusInfo;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class XMLCompareEditOrderedDialog
extends StatusDialog {
    private final Mapping fMapping;
    private final ArrayList fIdmapAL;
    private final boolean fEdit;
    private Text fElementText;
    private Text fSignatureText;

    public XMLCompareEditOrderedDialog(Shell parent, Mapping mapping, ArrayList idmapAL, boolean edit) {
        super(parent);
        int shellStyle = this.getShellStyle();
        this.setShellStyle(shellStyle | 0x400 | 0x10);
        this.fEdit = edit;
        if (this.fEdit) {
            this.setTitle(XMLCompareMessages.XMLCompareEditOrderedDialog_editTitle);
        } else {
            this.setTitle(XMLCompareMessages.XMLCompareEditOrderedDialog_newTitle);
        }
        this.fMapping = mapping;
        this.fIdmapAL = idmapAL;
    }

    protected Control createDialogArea(Composite ancestor) {
        Composite composite = (Composite)super.createDialogArea(ancestor);
        Composite inner = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        inner.setLayout((Layout)layout);
        inner.setLayoutData((Object)new GridData(1808));
        Label label = new Label(inner, 0);
        label.setText(XMLCompareMessages.XMLCompareEditMappingDialog_element);
        label.setLayoutData((Object)new GridData());
        this.fElementText = new Text(inner, 2048);
        this.fElementText.setText(this.fMapping.getElement());
        this.fElementText.setLayoutData((Object)new GridData(768));
        this.fElementText.addModifyListener(e -> this.doValidation());
        label = new Label(inner, 0);
        label.setText(XMLCompareMessages.XMLCompareEditMappingDialog_signature);
        label.setLayoutData((Object)new GridData());
        this.fSignatureText = new Text(inner, 2048);
        this.fSignatureText.setText(this.fMapping.getSignature());
        GridData data = new GridData(768);
        data.widthHint = this.convertWidthInCharsToPixels(50);
        this.fSignatureText.setLayoutData((Object)data);
        this.fSignatureText.addModifyListener(e -> this.doValidation());
        this.fElementText.setFocus();
        return composite;
    }

    private void doValidation() {
        StatusInfo status = new StatusInfo();
        String text = this.fElementText.getText();
        String mappingKey = Mapping.getKey(this.fSignatureText.getText(), text);
        String errormsg = "";
        boolean isError = false;
        if (text.length() == 0) {
            errormsg = XMLCompareMessages.XMLCompareEditMappingDialog_error_noname;
            isError = true;
        } else if (XMLComparePreferencePage.containsInvalidCharacters(text)) {
            if (errormsg == "") {
                errormsg = XMLCompareMessages.XMLCompareEditMappingDialog_error_invalidname;
            }
            isError = true;
        } else if (!this.fEdit && this.fIdmapAL.contains(mappingKey)) {
            if (errormsg == "") {
                errormsg = XMLCompareMessages.XMLCompareEditOrderedDialog_error_orderedExists;
            }
            isError = true;
        }
        text = this.fSignatureText.getText();
        if (XMLComparePreferencePage.containsInvalidCharacters(text)) {
            if (errormsg == "") {
                errormsg = XMLCompareMessages.XMLCompareEditMappingDialog_error_invalidsignature;
            }
            isError = true;
        }
        if (isError) {
            status.setError(errormsg);
        }
        this.updateStatus(status);
    }

    protected void okPressed() {
        this.fMapping.setElement(this.fElementText.getText());
        this.fMapping.setSignature(this.fSignatureText.getText());
        super.okPressed();
    }
}

