/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.examples.xml;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import org.eclipse.compare.examples.xml.IdMap;
import org.eclipse.compare.examples.xml.Mapping;
import org.eclipse.compare.examples.xml.SWTUtil;
import org.eclipse.compare.examples.xml.XMLCompareAddIdMapDialog;
import org.eclipse.compare.examples.xml.XMLCompareEditCopyIdMapDialog;
import org.eclipse.compare.examples.xml.XMLCompareEditMappingDialog;
import org.eclipse.compare.examples.xml.XMLCompareEditOrderedDialog;
import org.eclipse.compare.examples.xml.XMLCompareMessages;
import org.eclipse.compare.examples.xml.XMLPlugin;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class XMLComparePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
Listener {
    private Table fIdMapsTable;
    private Button fAddIdMapButton;
    private Button fRenameIdMapButton;
    private Button fRemoveIdMapButton;
    private Button fEditIdMapButton;
    private Table fMappingsTable;
    private Button fNewMappingsButton;
    private Button fEditMappingsButton;
    private Button fRemoveMappingsButton;
    private Table fOrderedTable;
    private Button fNewOrderedButton;
    private Button fEditOrderedButton;
    private Button fRemoveOrderedButton;
    private final HashMap fIdMapsInternal;
    private HashMap fIdMaps = new HashMap();
    private final HashMap fIdExtensionToName;
    private final HashMap fOrderedElements;
    private final HashMap fOrderedElementsInternal;
    protected static char[] invalidCharacters;
    protected static final char SIGN_SEPARATOR = '>';
    public static String IDTYPE_ATTRIBUTE;
    public static String IDTYPE_CHILDBODY;

    static {
        IDTYPE_ATTRIBUTE = XMLCompareMessages.XMLComparePreference_idtype_attribute;
        IDTYPE_CHILDBODY = XMLCompareMessages.XMLComparePreference_idtype_child_body;
        invalidCharacters = new char[]{'*', '!', '$'};
    }

    public XMLComparePreferencePage() {
        XMLPlugin plugin = XMLPlugin.getDefault();
        HashMap PluginIdMaps = plugin.getIdMaps();
        Set keySet = PluginIdMaps.keySet();
        for (String key : keySet) {
            this.fIdMaps.put(key, ((HashMap)PluginIdMaps.get(key)).clone());
        }
        this.fIdMapsInternal = plugin.getIdMapsInternal();
        this.fIdExtensionToName = new HashMap();
        HashMap PluginIdExtensionToName = plugin.getIdExtensionToName();
        keySet = PluginIdExtensionToName.keySet();
        for (String key : keySet) {
            this.fIdExtensionToName.put(key, PluginIdExtensionToName.get(key));
        }
        this.fOrderedElements = new HashMap();
        HashMap PluginOrderedElements = plugin.getOrderedElements();
        keySet = PluginOrderedElements.keySet();
        for (String key : keySet) {
            this.fOrderedElements.put(key, ((ArrayList)PluginOrderedElements.get(key)).clone());
        }
        this.fOrderedElementsInternal = plugin.getOrderedElementsInternal();
    }

    protected Control createContents(Composite ancestor) {
        Composite parent = new Composite(ancestor, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        parent.setLayout((Layout)layout);
        Label label = new Label(parent, 16384);
        label.setText(XMLCompareMessages.XMLComparePreference_topTableLabel);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        this.fIdMapsTable = new Table(parent, 67588);
        this.fIdMapsTable.setHeaderVisible(true);
        data = new GridData(1808);
        data.heightHint = this.fIdMapsTable.getItemHeight() * 4;
        this.fIdMapsTable.setLayoutData((Object)data);
        this.fIdMapsTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XMLComparePreferencePage.this.selectionChanged();
            }
        });
        String column2Text = XMLCompareMessages.XMLComparePreference_topTableColumn2;
        String column3Text = XMLCompareMessages.XMLComparePreference_topTableColumn3;
        ColumnLayoutData[] columnLayouts = new ColumnLayoutData[]{new ColumnWeightData(1), new ColumnPixelData(this.convertWidthInCharsToPixels(column2Text.length() + 2), true), new ColumnPixelData(this.convertWidthInCharsToPixels(column3Text.length() + 5), true)};
        TableLayout tablelayout = new TableLayout();
        this.fIdMapsTable.setLayout((Layout)tablelayout);
        int i = 0;
        while (i < 3) {
            tablelayout.addColumnData(columnLayouts[i]);
            ++i;
        }
        TableColumn column = new TableColumn(this.fIdMapsTable, 0);
        column.setText(XMLCompareMessages.XMLComparePreference_topTableColumn1);
        column = new TableColumn(this.fIdMapsTable, 0);
        column.setText(column2Text);
        column = new TableColumn(this.fIdMapsTable, 0);
        column.setText(column3Text);
        this.fillIdMapsTable();
        Composite buttons = new Composite(parent, 0);
        buttons.setLayout((Layout)new GridLayout());
        data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        buttons.setLayoutData((Object)data);
        this.fAddIdMapButton = new Button(buttons, 8);
        this.fAddIdMapButton.setText(XMLCompareMessages.XMLComparePreference_topAdd);
        this.fAddIdMapButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XMLComparePreferencePage.this.addIdMap(XMLComparePreferencePage.this.fAddIdMapButton.getShell());
            }
        });
        data = new GridData();
        data.horizontalAlignment = 4;
        int widthHint = this.convertHorizontalDLUsToPixels(61);
        data.widthHint = Math.max(widthHint, this.fAddIdMapButton.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.fAddIdMapButton.setLayoutData((Object)data);
        this.fRenameIdMapButton = new Button(buttons, 8);
        this.fRenameIdMapButton.setText(XMLCompareMessages.XMLComparePreference_topRename);
        this.fRenameIdMapButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XMLComparePreferencePage.this.renameIdMap(XMLComparePreferencePage.this.fRenameIdMapButton.getShell());
            }
        });
        data = new GridData();
        data.horizontalAlignment = 4;
        widthHint = this.convertHorizontalDLUsToPixels(61);
        data.widthHint = Math.max(widthHint, this.fAddIdMapButton.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.fRenameIdMapButton.setLayoutData((Object)data);
        this.fRemoveIdMapButton = new Button(buttons, 8);
        this.fRemoveIdMapButton.setText(XMLCompareMessages.XMLComparePreference_topRemove);
        this.fRemoveIdMapButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XMLComparePreferencePage.this.removeIdMap(XMLComparePreferencePage.this.fRemoveIdMapButton.getShell());
            }
        });
        data = new GridData();
        data.horizontalAlignment = 4;
        widthHint = this.convertHorizontalDLUsToPixels(61);
        data.widthHint = Math.max(widthHint, this.fRemoveIdMapButton.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.fRemoveIdMapButton.setLayoutData((Object)data);
        this.createSpacer(buttons);
        this.fEditIdMapButton = new Button(buttons, 8);
        this.fEditIdMapButton.setText(XMLCompareMessages.XMLComparePreference_topEdit);
        this.fEditIdMapButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XMLComparePreferencePage.this.editIdMap(XMLComparePreferencePage.this.fEditIdMapButton.getShell());
            }
        });
        data = new GridData();
        data.horizontalAlignment = 4;
        widthHint = this.convertHorizontalDLUsToPixels(61);
        data.widthHint = Math.max(widthHint, this.fEditIdMapButton.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.fEditIdMapButton.setLayoutData((Object)data);
        label = new Label(parent, 16384);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        label = new Label(parent, 16384);
        label.setText(XMLCompareMessages.XMLComparePreference_middleTableLabel);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        this.fMappingsTable = new Table(parent, 67588);
        this.fMappingsTable.setHeaderVisible(true);
        data = new GridData(1808);
        data.heightHint = this.fMappingsTable.getItemHeight() * 4;
        data.widthHint = this.convertWidthInCharsToPixels(70);
        this.fMappingsTable.setLayoutData((Object)data);
        column3Text = XMLCompareMessages.XMLComparePreference_middleTableColumn3;
        String column4Text = XMLCompareMessages.XMLComparePreference_middleTableColumn4;
        columnLayouts = new ColumnLayoutData[]{new ColumnWeightData(10), new ColumnWeightData(18), new ColumnPixelData(this.convertWidthInCharsToPixels(column3Text.length() + 1), true), new ColumnPixelData(this.convertWidthInCharsToPixels(column4Text.length() + 3), true)};
        tablelayout = new TableLayout();
        this.fMappingsTable.setLayout((Layout)tablelayout);
        int i2 = 0;
        while (i2 < 4) {
            tablelayout.addColumnData(columnLayouts[i2]);
            ++i2;
        }
        column = new TableColumn(this.fMappingsTable, 0);
        column.setText(XMLCompareMessages.XMLComparePreference_middleTableColumn1);
        column = new TableColumn(this.fMappingsTable, 0);
        column.setText(XMLCompareMessages.XMLComparePreference_middleTableColumn2);
        column = new TableColumn(this.fMappingsTable, 0);
        column.setText(column3Text);
        column = new TableColumn(this.fMappingsTable, 0);
        column.setText(column4Text);
        buttons = new Composite(parent, 0);
        buttons.setLayoutData((Object)new GridData(2));
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttons.setLayout((Layout)layout);
        this.fNewMappingsButton = new Button(buttons, 8);
        this.fNewMappingsButton.setLayoutData((Object)XMLComparePreferencePage.getButtonGridData(this.fNewMappingsButton));
        this.fNewMappingsButton.setText(XMLCompareMessages.XMLComparePreference_middleNew);
        this.fNewMappingsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XMLComparePreferencePage.this.addMapping(XMLComparePreferencePage.this.fAddIdMapButton.getShell());
            }
        });
        this.fEditMappingsButton = new Button(buttons, 8);
        this.fEditMappingsButton.setLayoutData((Object)XMLComparePreferencePage.getButtonGridData(this.fEditMappingsButton));
        this.fEditMappingsButton.setText(XMLCompareMessages.XMLComparePreference_middleEdit);
        this.fEditMappingsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XMLComparePreferencePage.this.editMapping(XMLComparePreferencePage.this.fEditMappingsButton.getShell());
            }
        });
        this.fRemoveMappingsButton = new Button(buttons, 8);
        this.fRemoveMappingsButton.setLayoutData((Object)XMLComparePreferencePage.getButtonGridData(this.fRemoveMappingsButton));
        this.fRemoveMappingsButton.setText(XMLCompareMessages.XMLComparePreference_middleRemove);
        this.fRemoveMappingsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XMLComparePreferencePage.this.removeMapping(XMLComparePreferencePage.this.fRemoveMappingsButton.getShell());
            }
        });
        this.createSpacer(buttons);
        label = new Label(parent, 16384);
        label.setText(XMLCompareMessages.XMLComparePreference_bottomTableLabel);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        this.fOrderedTable = new Table(parent, 67588);
        this.fOrderedTable.setHeaderVisible(true);
        data = new GridData(1808);
        data.heightHint = this.fOrderedTable.getItemHeight() * 2;
        data.widthHint = this.convertWidthInCharsToPixels(70);
        this.fOrderedTable.setLayoutData((Object)data);
        columnLayouts = new ColumnLayoutData[]{new ColumnWeightData(1), new ColumnWeightData(1)};
        tablelayout = new TableLayout();
        this.fOrderedTable.setLayout((Layout)tablelayout);
        i2 = 0;
        while (i2 < 2) {
            tablelayout.addColumnData(columnLayouts[i2]);
            ++i2;
        }
        column = new TableColumn(this.fOrderedTable, 0);
        column.setText(XMLCompareMessages.XMLComparePreference_bottomTableColumn1);
        column = new TableColumn(this.fOrderedTable, 0);
        column.setText(XMLCompareMessages.XMLComparePreference_bottomTableColumn2);
        buttons = new Composite(parent, 0);
        buttons.setLayoutData((Object)new GridData(2));
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttons.setLayout((Layout)layout);
        this.fNewOrderedButton = new Button(buttons, 8);
        this.fNewOrderedButton.setLayoutData((Object)XMLComparePreferencePage.getButtonGridData(this.fNewOrderedButton));
        this.fNewOrderedButton.setText(XMLCompareMessages.XMLComparePreference_bottomNew);
        this.fNewOrderedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XMLComparePreferencePage.this.addOrdered(XMLComparePreferencePage.this.fNewOrderedButton.getShell());
            }
        });
        this.fEditOrderedButton = new Button(buttons, 8);
        this.fEditOrderedButton.setLayoutData((Object)XMLComparePreferencePage.getButtonGridData(this.fEditOrderedButton));
        this.fEditOrderedButton.setText(XMLCompareMessages.XMLComparePreference_bottomEdit);
        this.fEditOrderedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XMLComparePreferencePage.this.editOrdered(XMLComparePreferencePage.this.fEditOrderedButton.getShell());
            }
        });
        this.fRemoveOrderedButton = new Button(buttons, 8);
        this.fRemoveOrderedButton.setLayoutData((Object)XMLComparePreferencePage.getButtonGridData(this.fRemoveOrderedButton));
        this.fRemoveOrderedButton.setText(XMLCompareMessages.XMLComparePreference_bottomRemove);
        this.fRemoveOrderedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XMLComparePreferencePage.this.removeOrdered(XMLComparePreferencePage.this.fRemoveOrderedButton.getShell());
            }
        });
        this.createSpacer(buttons);
        this.fIdMapsTable.setSelection(0);
        this.fIdMapsTable.setFocus();
        this.selectionChanged();
        return parent;
    }

    protected void createSpacer(Composite parent) {
        Label spacer = new Label(parent, 0);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.verticalAlignment = 1;
        data.heightHint = 4;
        spacer.setLayoutData((Object)data);
    }

    private static GridData getButtonGridData(Button button) {
        GridData data = new GridData(768);
        data.widthHint = SWTUtil.getButtonWidthHint(button);
        return data;
    }

    public void init(IWorkbench workbench) {
        this.noDefaultAndApplyButton();
    }

    public void handleEvent(Event event) {
    }

    private void addIdMap(Shell shell) {
        IdMap idmap = new IdMap(false);
        XMLCompareAddIdMapDialog dialog = new XMLCompareAddIdMapDialog(shell, idmap, this.fIdMaps, this.fIdMapsInternal, this.fIdExtensionToName, false);
        if (dialog.open() == 0 && !this.fIdMaps.containsKey(idmap.getName())) {
            this.fIdMaps.put(idmap.getName(), new HashMap());
            if (!idmap.getExtension().isEmpty()) {
                this.fIdExtensionToName.put(idmap.getExtension(), idmap.getName());
            }
            this.newIdMapsTableItem(idmap, true);
        }
    }

    private void renameIdMap(Shell shell) {
        TableItem[] itemsIdMaps = this.fIdMapsTable.getSelection();
        if (itemsIdMaps.length > 0) {
            IdMap idmap = (IdMap)itemsIdMaps[0].getData();
            String old_name = idmap.getName();
            String old_extension = idmap.getExtension();
            HashMap idmapHS = (HashMap)this.fIdMaps.get(old_name);
            XMLCompareAddIdMapDialog dialog = new XMLCompareAddIdMapDialog(shell, idmap, this.fIdMaps, this.fIdMapsInternal, this.fIdExtensionToName, true);
            if (dialog.open() == 0) {
                this.fIdMaps.remove(old_name);
                this.fIdExtensionToName.remove(old_extension);
                this.fIdMaps.put(idmap.getName(), idmapHS);
                if (!idmap.getExtension().isEmpty()) {
                    this.fIdExtensionToName.put(idmap.getExtension(), idmap.getName());
                }
                this.fIdMapsTable.remove(this.fIdMapsTable.indexOf(itemsIdMaps[0]));
                this.newIdMapsTableItem(idmap, true);
            }
        }
    }

    private void removeIdMap(Shell shell) {
        TableItem[] itemsIdMap = this.fIdMapsTable.getSelection();
        if (itemsIdMap.length > 0) {
            TableItem[] itemsOrdered;
            TableItem[] itemsMappings;
            String IdMapName = ((IdMap)itemsIdMap[0].getData()).getName();
            this.fIdMaps.remove(IdMapName);
            this.fOrderedElements.remove(IdMapName);
            TableItem[] tableItemArray = itemsMappings = this.fMappingsTable.getItems();
            int n = itemsMappings.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem itemsMapping = tableItemArray[n2];
                itemsMapping.dispose();
                ++n2;
            }
            TableItem[] tableItemArray2 = itemsOrdered = this.fOrderedTable.getItems();
            int n3 = itemsOrdered.length;
            n = 0;
            while (n < n3) {
                TableItem itemsOrd = tableItemArray2[n];
                itemsOrd.dispose();
                ++n;
            }
            if (!itemsIdMap[0].getText(2).equals("")) {
                this.fIdExtensionToName.remove(itemsIdMap[0].getText(2));
            }
            itemsIdMap[0].dispose();
        }
    }

    private void editIdMap(Shell shell) {
        String new_idmapName;
        IdMap idmap;
        XMLCompareEditCopyIdMapDialog dialog;
        TableItem[] items = this.fIdMapsTable.getSelection();
        if (items.length > 0 && (dialog = new XMLCompareEditCopyIdMapDialog(shell, idmap = (IdMap)items[0].getData(), this.fIdMaps, this.fIdMapsInternal)).open() == 0 && !this.fIdMaps.containsKey(new_idmapName = dialog.getResult())) {
            Vector<Mapping> newMappings = new Vector<Mapping>();
            IdMap newIdMap = new IdMap(new_idmapName, false, newMappings);
            HashMap<String, String> newIdmapHM = new HashMap<String, String>();
            this.fIdMaps.put(newIdMap.getName(), newIdmapHM);
            Vector Mappings = idmap.getMappings();
            Enumeration enumeration = Mappings.elements();
            while (enumeration.hasMoreElements()) {
                Mapping mapping = (Mapping)enumeration.nextElement();
                Mapping newMapping = new Mapping(mapping.getElement(), mapping.getSignature(), mapping.getIdAttribute());
                newMappings.add(newMapping);
                newIdmapHM.put(newMapping.getKey(), newMapping.getIdAttribute());
            }
            ArrayList orderedAL = idmap.getOrdered();
            if (orderedAL != null && orderedAL.size() > 0) {
                ArrayList<Mapping> newOrderedAL = new ArrayList<Mapping>();
                newIdMap.setOrdered(newOrderedAL);
                ArrayList<String> idmapOrdered = new ArrayList<String>();
                this.fOrderedElements.put(newIdMap.getName(), idmapOrdered);
                for (Mapping ordered : orderedAL) {
                    Mapping newOrdered = new Mapping(ordered.getElement(), ordered.getSignature());
                    newOrderedAL.add(newOrdered);
                    idmapOrdered.add(newOrdered.getKey());
                }
            }
            this.newIdMapsTableItem(newIdMap, true);
            this.selectionChanged();
        }
    }

    private void addMapping(Shell shell) {
        IdMap idmap;
        HashMap<String, String> idmapHM;
        Mapping mapping;
        XMLCompareEditMappingDialog dialog;
        TableItem[] items = this.fIdMapsTable.getSelection();
        if (items.length > 0 && (dialog = new XMLCompareEditMappingDialog(shell, mapping = new Mapping(), idmapHM = (HashMap<String, String>)this.fIdMaps.get((idmap = (IdMap)items[0].getData()).getName()), false)).open() == 0) {
            String idmapHMKey = mapping.getKey();
            if (idmapHM == null) {
                idmapHM = new HashMap<String, String>();
            }
            if (!idmapHM.containsKey(idmapHMKey)) {
                idmapHM.put(idmapHMKey, mapping.getIdAttribute());
                this.newMappingsTableItem(mapping, true);
                Vector mappings = idmap.getMappings();
                mappings.add(mapping);
            }
        }
    }

    private void editMapping(Shell shell) {
        TableItem[] itemsIdMaps = this.fIdMapsTable.getSelection();
        TableItem[] itemsMappings = this.fMappingsTable.getSelection();
        if (itemsMappings.length > 0) {
            IdMap idmap = (IdMap)itemsIdMaps[0].getData();
            HashMap idmapHM = (HashMap)this.fIdMaps.get(idmap.getName());
            Mapping mapping = (Mapping)itemsMappings[0].getData();
            String idmapHMKey = mapping.getKey();
            idmapHM.remove(idmapHMKey);
            XMLCompareEditMappingDialog dialog = new XMLCompareEditMappingDialog(shell, mapping, null, true);
            if (dialog.open() == 0) {
                idmapHMKey = mapping.getKey();
                idmapHM.put(idmapHMKey, mapping.getIdAttribute());
                this.fMappingsTable.remove(this.fMappingsTable.indexOf(itemsMappings[0]));
                this.newMappingsTableItem(mapping, true);
            }
        }
    }

    private void removeMapping(Shell shell) {
        TableItem[] itemsIdMaps = this.fIdMapsTable.getSelection();
        TableItem[] itemsMappings = this.fMappingsTable.getSelection();
        if (itemsMappings.length > 0 && itemsIdMaps.length > 0) {
            Mapping mapping = (Mapping)itemsMappings[0].getData();
            IdMap idmap = (IdMap)itemsIdMaps[0].getData();
            HashMap idmapHS = (HashMap)this.fIdMaps.get(idmap.getName());
            idmapHS.remove(mapping.getKey());
            Vector mappings = idmap.getMappings();
            mappings.remove(mapping);
            itemsMappings[0].dispose();
        }
    }

    private void addOrdered(Shell shell) {
        TableItem[] items = this.fIdMapsTable.getSelection();
        if (items.length > 0) {
            String idmapALKey;
            XMLCompareEditOrderedDialog dialog;
            IdMap idmap = (IdMap)items[0].getData();
            Mapping mapping = new Mapping();
            ArrayList<String> idmapAL = (ArrayList<String>)this.fOrderedElements.get(idmap.getName());
            if (idmapAL == null) {
                idmapAL = new ArrayList<String>();
            }
            if ((dialog = new XMLCompareEditOrderedDialog(shell, mapping, idmapAL, false)).open() == 0 && !idmapAL.contains(idmapALKey = mapping.getKey())) {
                idmapAL.add(idmapALKey);
                this.newOrderedTableItem(mapping, true);
                ArrayList<Mapping> ordered = idmap.getOrdered();
                if (ordered == null) {
                    ordered = new ArrayList<Mapping>();
                    ordered.add(mapping);
                    idmap.setOrdered(ordered);
                } else {
                    ordered.add(mapping);
                }
                if (!this.fOrderedElements.containsKey(idmap.getName())) {
                    this.fOrderedElements.put(idmap.getName(), idmapAL);
                }
            }
        }
    }

    private void editOrdered(Shell shell) {
        TableItem[] itemsIdMaps = this.fIdMapsTable.getSelection();
        TableItem[] itemsOrdered = this.fOrderedTable.getSelection();
        if (itemsOrdered.length > 0) {
            IdMap idmap = (IdMap)itemsIdMaps[0].getData();
            ArrayList idmapAL = (ArrayList)this.fOrderedElements.get(idmap.getName());
            Mapping mapping = (Mapping)itemsOrdered[0].getData();
            String idmapALKey = mapping.getKey();
            idmapAL.remove(idmapALKey);
            XMLCompareEditOrderedDialog dialog = new XMLCompareEditOrderedDialog(shell, mapping, null, true);
            if (dialog.open() == 0) {
                idmapALKey = mapping.getKey();
                idmapAL.add(idmapALKey);
                this.fOrderedTable.remove(this.fOrderedTable.indexOf(itemsOrdered[0]));
                this.newOrderedTableItem(mapping, true);
            }
        }
    }

    private void removeOrdered(Shell shell) {
        TableItem[] itemsIdMaps = this.fIdMapsTable.getSelection();
        TableItem[] itemsOrdered = this.fOrderedTable.getSelection();
        if (itemsOrdered.length > 0 && itemsIdMaps.length > 0) {
            Mapping mapping = (Mapping)itemsOrdered[0].getData();
            IdMap idmap = (IdMap)itemsIdMaps[0].getData();
            ArrayList idmapAL = (ArrayList)this.fOrderedElements.get(idmap.getName());
            idmapAL.remove(mapping.getKey());
            if (idmapAL.size() <= 0) {
                this.fOrderedElements.remove(idmap.getName());
            }
            ArrayList ordered = idmap.getOrdered();
            ordered.remove(mapping);
            if (ordered.size() <= 0) {
                idmap.setOrdered(null);
            }
            itemsOrdered[0].dispose();
        }
    }

    protected TableItem newIdMapsTableItem(IdMap idmap, boolean selected) {
        TableItem[] items = this.fIdMapsTable.getItems();
        int i = 0;
        while (i < items.length && idmap.getName().compareToIgnoreCase(items[i].getText(0)) > 0) {
            ++i;
        }
        TableItem item = new TableItem(this.fIdMapsTable, 0, i);
        String[] values = new String[]{idmap.getName(), idmap.isInternal() ? XMLCompareMessages.XMLComparePreference_topTableColumn2internal : XMLCompareMessages.XMLComparePreference_topTableColumn2user, idmap.getExtension()};
        item.setText(values);
        item.setData((Object)idmap);
        if (selected) {
            this.fIdMapsTable.setSelection(i);
            this.fIdMapsTable.setFocus();
            this.selectionChanged();
        }
        return item;
    }

    protected TableItem newMappingsTableItem(Mapping mapping, boolean selected) {
        String idtype;
        TableItem[] items = this.fMappingsTable.getItems();
        int i = 0;
        while (i < items.length && mapping.getElement().compareToIgnoreCase(items[i].getText(0)) > 0) {
            ++i;
        }
        TableItem item = new TableItem(this.fMappingsTable, 0, i);
        String idtext = mapping.getIdAttribute();
        if (idtext.charAt(0) == '<') {
            idtext = idtext.substring(1, idtext.length());
            idtype = IDTYPE_CHILDBODY;
        } else {
            idtype = IDTYPE_ATTRIBUTE;
        }
        String[] values = new String[]{mapping.getElement(), mapping.getSignature(), idtext, idtype};
        item.setText(values);
        item.setData((Object)mapping);
        if (selected) {
            this.fMappingsTable.setSelection(i);
        }
        return item;
    }

    protected TableItem newOrderedTableItem(Mapping mapping, boolean selected) {
        TableItem[] items = this.fOrderedTable.getItems();
        int i = 0;
        while (i < items.length && mapping.getElement().compareToIgnoreCase(items[i].getText(0)) > 0) {
            ++i;
        }
        TableItem item = new TableItem(this.fOrderedTable, 0, i);
        String[] values = new String[]{mapping.getElement(), mapping.getSignature()};
        item.setText(values);
        item.setData((Object)mapping);
        if (selected) {
            this.fOrderedTable.setSelection(i);
        }
        return item;
    }

    protected void fillIdMapsTable() {
        this.fillIdMaps(true);
        this.fillIdMaps(false);
        Set OrderedKeys = this.fOrderedElements.keySet();
        Set IdMapKeys = this.fIdMaps.keySet();
        for (String IdMapName : OrderedKeys) {
            if (IdMapKeys.contains(IdMapName)) continue;
            IdMap idmap = new IdMap(IdMapName, false);
            ArrayList idmapOrdered = (ArrayList)this.fOrderedElements.get(IdMapName);
            XMLComparePreferencePage.setOrdered(idmap, idmapOrdered);
            this.newIdMapsTableItem(idmap, false);
        }
    }

    private void fillIdMaps(boolean internal) {
        HashMap IdMaps = internal ? this.fIdMapsInternal : this.fIdMaps;
        HashMap OrderedElements = internal ? this.fOrderedElementsInternal : this.fOrderedElements;
        Set IdMapKeys = IdMaps.keySet();
        for (String IdMapName : IdMapKeys) {
            Vector<Mapping> Mappings = new Vector<Mapping>();
            IdMap idmap = new IdMap(IdMapName, internal, Mappings);
            HashMap idmapHM = (HashMap)IdMaps.get(IdMapName);
            Set idmapKeys = idmapHM.keySet();
            Iterator iter_idmap = idmapKeys.iterator();
            while (iter_idmap.hasNext()) {
                Mapping mapping = new Mapping();
                String signature = (String)iter_idmap.next();
                int end_of_signature = signature.lastIndexOf(62, signature.length() - 2);
                if (end_of_signature < "root".length() + 1) {
                    mapping.setSignature("");
                } else {
                    mapping.setSignature(signature.substring("root".length() + 1, end_of_signature));
                }
                mapping.setElement(signature.substring(end_of_signature + 1, signature.length() - 1));
                mapping.setIdAttribute((String)idmapHM.get(signature));
                Mappings.add(mapping);
            }
            ArrayList idmapOrdered = (ArrayList)OrderedElements.get(IdMapName);
            if (idmapOrdered != null) {
                XMLComparePreferencePage.setOrdered(idmap, idmapOrdered);
            }
            if (this.fIdExtensionToName.containsValue(IdMapName)) {
                Set keySet = this.fIdExtensionToName.keySet();
                String extension2 = new String();
                for (String extension2 : keySet) {
                    if (((String)this.fIdExtensionToName.get(extension2)).equals(IdMapName)) break;
                }
                idmap.setExtension(extension2);
            }
            this.newIdMapsTableItem(idmap, false);
        }
    }

    protected static void setOrdered(IdMap idmap, ArrayList idmapOrdered) {
        ArrayList<Mapping> Ordered = new ArrayList<Mapping>();
        Iterator iter_ordered = idmapOrdered.iterator();
        while (iter_ordered.hasNext()) {
            Mapping mapping = new Mapping();
            String signature = (String)iter_ordered.next();
            int end_of_signature = signature.lastIndexOf(62, signature.length() - 2);
            if (end_of_signature < "root".length() + 1) {
                mapping.setSignature("");
            } else {
                mapping.setSignature(signature.substring("root".length() + 1, end_of_signature));
            }
            mapping.setElement(signature.substring(end_of_signature + 1, signature.length() - 1));
            Ordered.add(mapping);
        }
        idmap.setOrdered(Ordered);
    }

    public boolean performOk() {
        XMLPlugin plugin = XMLPlugin.getDefault();
        if (!(plugin.getIdMaps().equals(this.fIdMaps) && plugin.getIdExtensionToName().equals(this.fIdExtensionToName) && plugin.getOrderedElements().equals(this.fOrderedElements))) {
            plugin.setIdMaps(this.fIdMaps, this.fIdExtensionToName, this.fOrderedElements, true);
        }
        return super.performOk();
    }

    public boolean performCancel() {
        this.fIdMaps = (HashMap)XMLPlugin.getDefault().getIdMaps().clone();
        return super.performCancel();
    }

    protected void selectionChanged() {
        TableItem[] items = this.fIdMapsTable.getSelection();
        if (items.length > 0) {
            this.fMappingsTable.removeAll();
            Vector Mappings = ((IdMap)items[0].getData()).getMappings();
            Enumeration enumeration = Mappings.elements();
            while (enumeration.hasMoreElements()) {
                this.newMappingsTableItem((Mapping)enumeration.nextElement(), false);
            }
            this.fOrderedTable.removeAll();
            ArrayList Ordered = ((IdMap)items[0].getData()).getOrdered();
            if (Ordered != null) {
                Iterator iter_ordered = Ordered.iterator();
                while (iter_ordered.hasNext()) {
                    this.newOrderedTableItem((Mapping)iter_ordered.next(), false);
                }
            }
        }
        this.updateEnabledState();
    }

    private void updateEnabledState() {
        TableItem[] itemsIdMaps = this.fIdMapsTable.getSelection();
        if (itemsIdMaps.length > 0) {
            IdMap idmap = (IdMap)itemsIdMaps[0].getData();
            if (idmap.isInternal()) {
                this.fRenameIdMapButton.setEnabled(false);
                this.fRemoveIdMapButton.setEnabled(false);
                this.fEditIdMapButton.setEnabled(true);
                this.fNewMappingsButton.setEnabled(false);
                this.fEditMappingsButton.setEnabled(false);
                this.fRemoveMappingsButton.setEnabled(false);
                this.fNewOrderedButton.setEnabled(false);
                this.fEditOrderedButton.setEnabled(false);
                this.fRemoveOrderedButton.setEnabled(false);
            } else {
                this.fRenameIdMapButton.setEnabled(true);
                this.fRemoveIdMapButton.setEnabled(true);
                this.fEditIdMapButton.setEnabled(false);
                this.fNewMappingsButton.setEnabled(true);
                this.fEditMappingsButton.setEnabled(true);
                this.fRemoveMappingsButton.setEnabled(true);
                this.fNewOrderedButton.setEnabled(true);
                this.fEditOrderedButton.setEnabled(true);
                this.fRemoveOrderedButton.setEnabled(true);
            }
        }
    }

    protected static boolean containsInvalidCharacters(String text) {
        int i = 0;
        while (i < invalidCharacters.length) {
            if (text.indexOf(invalidCharacters[i]) > -1) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

