/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.examples.xml;

import java.lang.invoke.CallSite;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.examples.xml.XMLStructureCreator;
import org.eclipse.compare.examples.xml.XMLStructureViewer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public final class XMLPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.compare.examples.xml";
    private static final String ID_MAPPING_EXTENSION_POINT = "idMapping";
    private static final String MAPPING_ELEMENT_NAME = "mapping";
    private static final String IDMAP_NAME_ATTRIBUTE = "name";
    private static final String EXTENSION_NAME_ATTRIBUTE = "extension";
    private static final String MAPPING_SIGNATURE_ATTRIBUTE = "signature";
    private static final String MAPPING_ID_ATTRIBUTE = "id";
    private static final String MAPPING_ID_SOURCE = "id-source";
    private static final String MAPPING_ID_SOURCE_BODY = "body";
    private static final String ORDERED_ELEMENT_NAME = "ordered";
    private static final String ORDERED_SIGNATURE_ATTRIBUTE = "signature";
    public static final String DEFAULT_PREFIX = "XML";
    public static final String IMAGE_TYPE_PREFIX = "xml_";
    public static final String IMAGE_TYPE_ORDERED_SUFFIX = "_ordered";
    public static final String IDMAP_PREFERENCE_NAME = "idmap";
    public static final String IDMAP_PREFIX = "idmap";
    public static final char IDMAP_SEPARATOR = '*';
    public static final char IDMAP_FIELDS_SEPARATOR = '!';
    public static final String ORDERED_PREFERENCE_NAME = "ordered";
    public static final char ORDERED_FIELDS_SEPARATOR = '!';
    private static XMLPlugin fgXMLPlugin;
    private IPreferenceStore fPrefStore;
    private HashMap fIdMapsInternal;
    private HashMap fIdMaps;
    private HashMap fIdExtensionToName;
    private HashMap fOrderedElementsInternal;
    private HashMap fOrderedElements;
    private final ListenerList fViewers = new ListenerList();

    public XMLPlugin() {
        Assert.isTrue((fgXMLPlugin == null ? 1 : 0) != 0);
        fgXMLPlugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        CompareUI.removeAllStructureViewerAliases((String)DEFAULT_PREFIX);
        this.initPrefStore();
        CompareUI.registerImageDescriptor((String)"xml_element", (ImageDescriptor)this.getImageDescriptor("obj16/element_obj.gif"));
        CompareUI.registerImageDescriptor((String)"xml_attribute", (ImageDescriptor)this.getImageDescriptor("obj16/attribute_obj.gif"));
        CompareUI.registerImageDescriptor((String)"xml_text", (ImageDescriptor)this.getImageDescriptor("obj16/text_obj.gif"));
        CompareUI.registerImageDescriptor((String)"xml_element_ordered", (ImageDescriptor)this.getImageDescriptor("obj16/element_ordered_obj.gif"));
        this.registerExtensions();
    }

    protected ImageDescriptor getImageDescriptor(String relativePath) {
        URL installURL = fgXMLPlugin.getBundle().getEntry("/");
        if (installURL != null) {
            try {
                URL url = new URL(installURL, "icons/full/" + relativePath);
                return ImageDescriptor.createFromURL((URL)url);
            }
            catch (MalformedURLException e) {
                Assert.isTrue((boolean)false);
            }
        }
        return null;
    }

    public static XMLPlugin getDefault() {
        return fgXMLPlugin;
    }

    public void initPrefStore() {
        String IdMapName;
        this.fIdMaps = new HashMap();
        this.fIdExtensionToName = new HashMap();
        this.fPrefStore = this.getPreferenceStore();
        String IdMapPrefValue = this.fPrefStore.getString("idmap");
        int start = 0;
        int end = IdMapPrefValue.indexOf(42);
        while (end >= 0) {
            String IdMapAttribute;
            String CurrentIdMap = IdMapPrefValue.substring(start, end);
            int end_of_IdMapName = CurrentIdMap.indexOf(33);
            IdMapName = CurrentIdMap.substring(0, end_of_IdMapName);
            int end_of_signature = CurrentIdMap.indexOf(33, end_of_IdMapName + 1);
            String IdMapSignature = CurrentIdMap.substring(end_of_IdMapName + 1, end_of_signature);
            int end_of_attribute = CurrentIdMap.indexOf(33, end_of_signature + 1);
            if (end_of_attribute < 0) {
                IdMapAttribute = CurrentIdMap.substring(end_of_signature + 1, CurrentIdMap.length());
            } else {
                IdMapAttribute = CurrentIdMap.substring(end_of_signature + 1, end_of_attribute);
                String IdMapExtension = CurrentIdMap.substring(end_of_attribute + 1, CurrentIdMap.length());
                if (!IdMapExtension.isEmpty() && !this.fIdExtensionToName.containsKey(IdMapExtension)) {
                    this.fIdExtensionToName.put(IdMapExtension, IdMapName);
                    CompareUI.addStructureViewerAlias((String)DEFAULT_PREFIX, (String)IdMapExtension);
                }
            }
            if (this.fIdMaps.containsKey(IdMapName)) {
                Mappings = (HashMap)this.fIdMaps.get(IdMapName);
                Mappings.put(IdMapSignature, IdMapAttribute);
            } else {
                Mappings = new HashMap();
                Mappings.put(IdMapSignature, IdMapAttribute);
                this.fIdMaps.put(IdMapName, Mappings);
            }
            start = end + 1;
            end = IdMapPrefValue.indexOf(42, end + 1);
        }
        this.fOrderedElements = new HashMap();
        String OrderedPrefValue = this.fPrefStore.getString("ordered");
        StringTokenizer orderedTokens = new StringTokenizer(OrderedPrefValue, Character.valueOf('!').toString());
        while (orderedTokens.hasMoreTokens()) {
            ArrayList idmapAL;
            IdMapName = orderedTokens.nextToken();
            String signature = orderedTokens.nextToken();
            if (this.fOrderedElements.containsKey(IdMapName)) {
                idmapAL = (ArrayList)this.fOrderedElements.get(IdMapName);
                idmapAL.add(signature);
                continue;
            }
            idmapAL = new ArrayList();
            idmapAL.add(signature);
            this.fOrderedElements.put(IdMapName, idmapAL);
        }
    }

    public void setIdMaps(HashMap IdMap2, HashMap IdExtensionToName, HashMap OrderedElements, boolean refresh) {
        this.fIdMaps = IdMap2;
        if (IdExtensionToName != null && !IdExtensionToName.equals(this.fIdExtensionToName)) {
            CompareUI.removeAllStructureViewerAliases((String)DEFAULT_PREFIX);
            this.fIdExtensionToName = IdExtensionToName;
            Set newkeySet = this.fIdExtensionToName.keySet();
            for (String extension : newkeySet) {
                CompareUI.addStructureViewerAlias((String)DEFAULT_PREFIX, (String)extension);
            }
        }
        StringBuilder IdMapPrefValue = new StringBuilder();
        Set idmapKeys = this.fIdMaps.keySet();
        for (String IdMapName : idmapKeys) {
            HashMap idmapHM = (HashMap)this.fIdMaps.get(IdMapName);
            Set mappingKeys = idmapHM.keySet();
            String extension2 = "";
            if (this.fIdExtensionToName.containsValue(IdMapName)) {
                Set keySet = this.fIdExtensionToName.keySet();
                for (String extension2 : keySet) {
                    if (((String)this.fIdExtensionToName.get(extension2)).equals(IdMapName)) break;
                }
            }
            for (String signature : mappingKeys) {
                IdMapPrefValue.append(IdMapName + "!" + signature + "!" + String.valueOf(idmapHM.get(signature)) + "!" + extension2 + "*");
            }
        }
        this.fPrefStore.setValue("idmap", IdMapPrefValue.toString());
        if (OrderedElements != null) {
            this.fOrderedElements = OrderedElements;
            StringBuilder OrderedPrefValue = new StringBuilder();
            Set orderedKeys = this.fOrderedElements.keySet();
            for (String IdMapName : orderedKeys) {
                ArrayList idmapAL = (ArrayList)this.fOrderedElements.get(IdMapName);
                for (String signature : idmapAL) {
                    OrderedPrefValue.append(IdMapName + "!" + signature + "!");
                }
            }
            this.fPrefStore.setValue("ordered", OrderedPrefValue.toString());
        }
        if (refresh) {
            Object[] viewers = this.fViewers.getListeners();
            int i = 0;
            while (i < viewers.length) {
                XMLStructureViewer viewer = (XMLStructureViewer)((Object)viewers[i]);
                viewer.updateIdMaps();
                viewer.contentChanged();
                ++i;
            }
        }
    }

    public HashMap getIdMaps() {
        return this.fIdMaps;
    }

    public HashMap getIdMapsInternal() {
        return this.fIdMapsInternal;
    }

    public HashMap getIdExtensionToName() {
        return this.fIdExtensionToName;
    }

    public HashMap getOrderedElements() {
        return this.fOrderedElements;
    }

    public HashMap getOrderedElementsInternal() {
        return this.fOrderedElementsInternal;
    }

    private void registerExtensions() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] idmaps = registry.getConfigurationElementsFor(PLUGIN_ID, ID_MAPPING_EXTENSION_POINT);
        this.fIdMapsInternal = new HashMap();
        this.fOrderedElementsInternal = new HashMap();
        IConfigurationElement[] iConfigurationElementArray = idmaps;
        int n = idmaps.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement idmap = iConfigurationElementArray[n2];
            String idmap_name = idmap.getAttribute(IDMAP_NAME_ATTRIBUTE);
            if (!idmap_name.equals(XMLStructureCreator.USE_UNORDERED) && !idmap_name.equals(XMLStructureCreator.USE_ORDERED)) {
                String ext_name;
                IConfigurationElement[] mappings;
                HashMap<CallSite, CallSite> idmapHM = new HashMap<CallSite, CallSite>();
                this.fIdMapsInternal.put(idmap_name, idmapHM);
                IConfigurationElement[] iConfigurationElementArray2 = mappings = idmap.getChildren(MAPPING_ELEMENT_NAME);
                int n3 = mappings.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement mapping = iConfigurationElementArray2[n4];
                    String signature = mapping.getAttribute("signature");
                    String attribute = mapping.getAttribute(MAPPING_ID_ATTRIBUTE);
                    String idsource = mapping.getAttribute(MAPPING_ID_SOURCE);
                    String bodyid = "";
                    if (signature != null && !signature.isEmpty() && attribute != null && !attribute.isEmpty()) {
                        if (idsource != null && idsource.equals(MAPPING_ID_SOURCE_BODY)) {
                            bodyid = Character.valueOf('<').toString();
                        }
                        idmapHM.put((CallSite)((Object)("root>" + signature + ">")), (CallSite)((Object)(bodyid + attribute)));
                    }
                    ++n4;
                }
                IConfigurationElement[] orderedEntries = idmap.getChildren("ordered");
                if (orderedEntries.length > 0) {
                    ArrayList<CallSite> orderedAL = new ArrayList<CallSite>();
                    IConfigurationElement[] iConfigurationElementArray3 = orderedEntries;
                    int n5 = orderedEntries.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        IConfigurationElement ordered = iConfigurationElementArray3[n6];
                        String signature = ordered.getAttribute("signature");
                        if (signature != null && !signature.isEmpty()) {
                            orderedAL.add((CallSite)((Object)("root>" + signature + ">")));
                        }
                        ++n6;
                    }
                    if (orderedAL.size() > 0) {
                        this.fOrderedElementsInternal.put(idmap_name, orderedAL);
                    }
                }
                if ((ext_name = idmap.getAttribute(EXTENSION_NAME_ATTRIBUTE)) != null && !this.fIdExtensionToName.containsKey(ext_name)) {
                    ext_name = ext_name.toLowerCase();
                    this.fIdExtensionToName.put(ext_name, idmap_name);
                    CompareUI.addStructureViewerAlias((String)DEFAULT_PREFIX, (String)ext_name);
                }
            }
            ++n2;
        }
    }

    public ListenerList getViewers() {
        return this.fViewers;
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow window = XMLPlugin.getActiveWorkbenchWindow();
        if (window != null) {
            return window.getShell();
        }
        return null;
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            WindowRef windowRef = new WindowRef();
            Display.getDefault().syncExec(() -> XMLPlugin.setActiveWorkbenchWindow(windowRef));
            return windowRef.window;
        }
        return window;
    }

    private static void setActiveWorkbenchWindow(WindowRef windowRef) {
        Shell[] shells;
        windowRef.window = null;
        Display display = Display.getCurrent();
        if (display == null) {
            return;
        }
        Shell shell = display.getActiveShell();
        while (shell != null) {
            Object data = shell.getData();
            if (data instanceof IWorkbenchWindow) {
                windowRef.window = (IWorkbenchWindow)data;
                return;
            }
            shell = shell.getParent();
        }
        Shell[] shellArray = shells = display.getShells();
        int n = shells.length;
        int n2 = 0;
        while (n2 < n) {
            Shell s = shellArray[n2];
            Object data = s.getData();
            if (data instanceof IWorkbenchWindow) {
                windowRef.window = (IWorkbenchWindow)data;
                return;
            }
            ++n2;
        }
    }

    public static void log(Throwable e) {
        XMLPlugin.log((IStatus)new Status(4, XMLPlugin.getPluginId(), 4, "Internal Error", e));
    }

    public static void log(IStatus status) {
        XMLPlugin.getDefault().getLog().log(status);
    }

    public static String getPluginId() {
        return XMLPlugin.getDefault().getBundle().getSymbolicName();
    }

    private static class WindowRef {
        public IWorkbenchWindow window;

        private WindowRef() {
        }
    }
}

