/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.examples.xml.ui;

import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;

public class MessageLine
extends CLabel {
    public static final RGB RED;
    private static RGB fgDefaultErrorRGB;
    private String fMessageText;
    private String fErrorText;
    private final Color fDefaultColor = this.getForeground();
    private final RGB fErrorRGB;
    private Color fErrorColor;

    static {
        fgDefaultErrorRGB = RED = new RGB(200, 0, 0);
    }

    public MessageLine(Composite parent) {
        this(parent, 16384);
    }

    public MessageLine(Composite parent, int style) {
        super(parent, style);
        this.fErrorRGB = fgDefaultErrorRGB;
    }

    public MessageLine(Composite parent, int style, RGB errorRGB) {
        super(parent, style);
        this.fErrorRGB = errorRGB;
    }

    public void clearErrorMessage() {
        this.setErrorMessage(null);
    }

    public void clearMessage() {
        this.setMessage(null);
    }

    public String getErrorMessage() {
        return this.fErrorText;
    }

    public String getMessage() {
        return this.fMessageText;
    }

    public static void setDefaultErrorColor(RGB color) {
        fgDefaultErrorRGB = color;
    }

    public void setErrorMessage(String message) {
        this.fErrorText = message;
        if (message == null) {
            this.setMessage(this.fMessageText);
        } else {
            if (this.fErrorColor == null) {
                this.fErrorColor = new Color((Device)this.getDisplay(), this.fErrorRGB);
            }
            this.setForeground(this.fErrorColor);
            this.setText(message);
        }
    }

    public void setMessage(String message) {
        this.fMessageText = message;
        if (message == null) {
            message = "";
        }
        if (this.fErrorText == null) {
            this.setForeground(this.fDefaultColor);
            this.setText(message);
        }
    }
}

