/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.examples.xml.ui;

import org.eclipse.compare.examples.xml.ui.MessageLine;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.DialogPage;

public class StatusUtil {
    public static IStatus getMoreSevere(IStatus s1, IStatus s2) {
        if (s1.getSeverity() > s2.getSeverity()) {
            return s1;
        }
        return s2;
    }

    public static IStatus getMostSevere(IStatus[] status) {
        IStatus max = null;
        IStatus[] iStatusArray = status;
        int n = status.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus curr = iStatusArray[n2];
            if (curr.matches(4)) {
                return curr;
            }
            if (max == null || curr.getSeverity() > max.getSeverity()) {
                max = curr;
            }
            ++n2;
        }
        return max;
    }

    private static String[] getErrorMessages(IStatus status) {
        String message = status.getMessage();
        if (status.matches(4) && !"".equals(message)) {
            String[] stringArray = new String[2];
            stringArray[0] = message;
            return stringArray;
        }
        if (status.matches(3)) {
            String[] stringArray = new String[2];
            stringArray[1] = message;
            return stringArray;
        }
        return new String[2];
    }

    public static void applyToStatusLine(DialogPage page, IStatus status) {
        String[] messages = StatusUtil.getErrorMessages(status);
        page.setErrorMessage(messages[0]);
        page.setMessage(messages[1]);
    }

    public static void applyToStatusLine(MessageLine messageLine, IStatus status) {
        String[] messages = StatusUtil.getErrorMessages(status);
        messageLine.setErrorMessage(messages[0]);
        messageLine.setMessage(messages[1]);
    }
}

