/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.commands.tests;

import java.util.HashMap;
import org.eclipse.core.commands.Category;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.IParameter;
import org.eclipse.core.commands.IParameterValues;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.e4.core.commands.CommandServiceAddon;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public class DefineCommandsTest {
    private static final String TEST_ID2 = "test.id2";
    private static final String TEST_ID1 = "test.id1";
    private static final String TEST_ID1_WITH_PARAMETERS = "test.id1.with.parameters";
    private static final String TEST_CAT1 = "test.cat1";
    private IEclipseContext workbenchContext;

    @BeforeEach
    public void setUp() {
        IEclipseContext serviceContext = EclipseContextFactory.getServiceContext((BundleContext)FrameworkUtil.getBundle(this.getClass()).getBundleContext());
        IEclipseContext globalContext = serviceContext.createChild();
        this.workbenchContext = globalContext.createChild("workbenchContext");
        ContextInjectionFactory.make(CommandServiceAddon.class, (IEclipseContext)this.workbenchContext);
    }

    @AfterEach
    public void tearDown() {
        this.workbenchContext.dispose();
    }

    @Test
    public void testCreateCommands() throws NotDefinedException {
        ECommandService cs = (ECommandService)this.workbenchContext.get(ECommandService.class);
        Assertions.assertNotNull((Object)cs);
        Assertions.assertNotNull((Object)cs.defineCategory(TEST_CAT1, "CAT1", null));
        Category category = cs.getCategory(TEST_CAT1);
        Assertions.assertNotNull((Object)category, (String)"need category");
        Assertions.assertNotNull((Object)cs.defineCommand(TEST_ID1, "ID1", null, category, null), (String)"command1");
        Assertions.assertNotNull((Object)cs.defineCommand(TEST_ID2, "ID2", null, category, null), (String)"command2");
        Command cmd1 = cs.getCommand(TEST_ID1);
        Assertions.assertNotNull((Object)cmd1, (String)"get command1");
        Assertions.assertEquals((Object)"ID1", (Object)cmd1.getName());
        Assertions.assertNotNull((Object)cs.getCommand(TEST_ID2), (String)"get command2");
        Assertions.assertNotNull((Object)cs.createCommand(TEST_ID1, null), (String)"parameterized command");
    }

    @Test
    public void testParamizedCommandsSimple() {
        ECommandService cs = (ECommandService)this.workbenchContext.get(ECommandService.class);
        IParameter[] parms = new IParameter[]{new IParameter(){

            public String getId() {
                return "viewId";
            }

            public String getName() {
                return "View Id";
            }

            public IParameterValues getValues() {
                return null;
            }

            public boolean isOptional() {
                return false;
            }
        }};
        Category defineCategory = cs.defineCategory(TEST_CAT1, "CAT1", null);
        Command command = cs.defineCommand(TEST_ID1_WITH_PARAMETERS, "TEST_ID1_WITH_PARAMETERS", null, defineCategory, parms);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("viewId", "Testing");
        ParameterizedCommand createdParamizedCommand = cs.createCommand(TEST_ID1_WITH_PARAMETERS, parameters);
        Assertions.assertNotNull((Object)command);
        Assertions.assertNotNull((Object)createdParamizedCommand);
        Command cmd1 = cs.getCommand(TEST_ID1_WITH_PARAMETERS);
        Assertions.assertNotNull((Object)cmd1, (String)"get command1");
    }

    @Test
    public void testCreateWithSecondContexts() throws NotDefinedException {
        IEclipseContext localContext = this.workbenchContext.createChild();
        ECommandService cs = (ECommandService)localContext.get(ECommandService.class);
        Assertions.assertNotNull((Object)cs);
        Assertions.assertNotNull((Object)cs.defineCategory(TEST_CAT1, "CAT1", null));
        Category category = cs.getCategory(TEST_CAT1);
        Assertions.assertNotNull((Object)category, (String)"need category");
        Assertions.assertNotNull((Object)cs.defineCommand(TEST_ID1, "ID1", null, category, null), (String)"command1");
        Assertions.assertNotNull((Object)cs.defineCommand(TEST_ID2, "ID2", null, category, null), (String)"command2");
        Command cmd1 = cs.getCommand(TEST_ID1);
        Assertions.assertNotNull((Object)cmd1, (String)"get command1");
        Assertions.assertEquals((Object)"ID1", (Object)cmd1.getName());
        Assertions.assertNotNull((Object)cs.getCommand(TEST_ID2), (String)"get command2");
    }

    @Test
    public void testCreateWithTwoContexts() throws NotDefinedException {
        IEclipseContext localContext = this.workbenchContext.createChild("Level1");
        ECommandService cs = (ECommandService)localContext.get(ECommandService.class);
        Assertions.assertNotNull((Object)cs);
        Assertions.assertNotNull((Object)cs.defineCategory(TEST_CAT1, "CAT1", null));
        Category category = cs.getCategory(TEST_CAT1);
        Assertions.assertNotNull((Object)category, (String)"need category");
        Assertions.assertNotNull((Object)cs.defineCommand(TEST_ID1, "ID1", null, category, null), (String)"command1");
        Assertions.assertNotNull((Object)cs.defineCommand(TEST_ID2, "ID2", null, category, null), (String)"command2");
        cs = (ECommandService)this.workbenchContext.get(ECommandService.class);
        Command cmd1 = cs.getCommand(TEST_ID1);
        Assertions.assertNotNull((Object)cmd1, (String)"get command1");
        Assertions.assertEquals((Object)"ID1", (Object)cmd1.getName());
        Assertions.assertNotNull((Object)cs.getCommand(TEST_ID2), (String)"get command2");
    }
}

