/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.tests.about;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.Optional;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.about.AboutSections;
import org.eclipse.e4.core.services.about.ISystemInformation;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class AboutTest {
    @Test
    public void testCreateSectionFilter() throws Exception {
        String section = "section.system.environment";
        BundleContext context = FrameworkUtil.getBundle(AboutTest.class).getBundleContext();
        ServiceReference<ISystemInformation> reference = this.reference(context, section);
        Assertions.assertEquals((Object)section, (Object)reference.getProperty("section"), (String)"Invalid service metadata");
    }

    @Test
    public void testSystemEnvironmentVariables() throws Exception {
        String printed = this.printSection("section.system.environment");
        System.getenv().keySet().forEach(key -> Assertions.assertTrue((boolean)printed.contains((CharSequence)key)));
    }

    @Test
    public void testSystemProperties() throws Exception {
        String printed = this.printSection("section.system.properties");
        System.getProperties().keySet().forEach(key -> Assertions.assertTrue((boolean)printed.contains(String.valueOf(key))));
    }

    @Test
    public void testAppendInstalledFeatures() throws Exception {
        String printed = this.printSection("section.installed.features");
        Assertions.assertNotNull((Object)printed);
    }

    @Test
    public void testAppendInstalledBundles() throws Exception {
        Bundle bundle = FrameworkUtil.getBundle(AboutTest.class);
        IEclipseContext context = EclipseContextFactory.getServiceContext((BundleContext)bundle.getBundleContext());
        context.set("org.eclipse.e4.core.locale", (Object)Locale.getDefault());
        String version = bundle.getVersion().toString();
        String aboutMe = String.format("org.eclipse.e4.core.tests (%s) \"E4 Core Tests\" [Active]", version);
        String printed = this.printSection("section.installed.bundles");
        Assertions.assertTrue((boolean)printed.contains(aboutMe));
    }

    @Test
    public void testAppendUserPreferences() throws Exception {
        Bundle bundle = FrameworkUtil.getBundle(AboutTest.class);
        IEclipseContext context = EclipseContextFactory.getServiceContext((BundleContext)bundle.getBundleContext());
        context.set("org.eclipse.e4.core.locale", (Object)Locale.getDefault());
        String printed = this.printSection("section.user.preferences");
        Assertions.assertFalse((boolean)printed.isEmpty());
    }

    @Test
    public void testMaskPassword() throws Exception {
        String key = "A_PASSWORD_PROPERTY";
        String dec = "A_PASSWORD_VALUE";
        String enc = "****************";
        System.setProperty(key, dec);
        String printed = this.printSection("section.system.properties");
        Assertions.assertTrue((boolean)printed.contains(key + "=" + enc));
    }

    @Test
    public void testMultilineValue() throws Exception {
        String lf = System.lineSeparator();
        String key = "A_MULTILINE_PROPERTY";
        String value = "a\nb\nc";
        String expected = "a" + lf + "b" + lf + "c";
        System.setProperty(key, value);
        String printed = this.printSection("section.system.properties");
        Assertions.assertTrue((boolean)printed.contains(key + "=" + expected));
    }

    /*
     * Loose catch block
     */
    private String printSection(String section) throws Exception {
        BundleContext context = FrameworkUtil.getBundle(AboutTest.class).getBundleContext();
        ServiceReference<ISystemInformation> reference = this.reference(context, section);
        ISystemInformation service = (ISystemInformation)context.getService(reference);
        try {
            String string;
            PrintWriter pw;
            ByteArrayOutputStream baos;
            Throwable throwable;
            block21: {
                throwable = null;
                Object var6_7 = null;
                baos = new ByteArrayOutputStream();
                pw = new PrintWriter(baos);
                service.append(pw);
                pw.flush();
                string = new String(baos.toByteArray(), Charset.defaultCharset());
                if (pw != null) {
                    pw.close();
                }
                if (baos == null) break block21;
                baos.close();
            }
            return string;
            {
                catch (Throwable throwable2) {
                    try {
                        try {
                            if (pw != null) {
                                pw.close();
                            }
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            if (baos != null) {
                                baos.close();
                            }
                            throw throwable;
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable == null) {
                            throwable = throwable4;
                        } else if (throwable != throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                        throw throwable;
                    }
                }
            }
        }
        finally {
            context.ungetService(reference);
        }
    }

    private ServiceReference<ISystemInformation> reference(BundleContext context, String section) throws InvalidSyntaxException {
        String filter = AboutSections.createSectionFilter((String)section);
        Optional first = context.getServiceReferences(ISystemInformation.class, filter).stream().findFirst();
        Assumptions.assumeTrue((boolean)first.isPresent(), (String)"No reference found");
        return (ServiceReference)first.get();
    }
}

