/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.tests.about;

import java.util.Collection;
import org.eclipse.core.runtime.IBundleGroup;
import org.eclipse.core.runtime.IBundleGroupProvider;
import org.osgi.framework.Bundle;

final class BundleGroupFactory {
    private final String identifier;
    private final String version;
    private String name;
    private String description;
    private String providerName;

    private BundleGroupFactory(String identifier, String version) {
        this.identifier = identifier;
        this.version = version;
    }

    static BundleGroupFactory identify(String identifier, String version) {
        return new BundleGroupFactory(identifier, version);
    }

    static IBundleGroupProvider provider(final String name, final Collection<BundleGroupFactory> groups) {
        return new IBundleGroupProvider(){

            public String getName() {
                return name;
            }

            public IBundleGroup[] getBundleGroups() {
                return (IBundleGroup[])groups.stream().map(BundleGroupFactory::create).toArray(IBundleGroup[]::new);
            }
        };
    }

    BundleGroupFactory describe(String name, String description, String providerName) {
        this.name = name;
        this.description = description;
        this.providerName = providerName;
        return this;
    }

    IBundleGroup create() {
        return new IBundleGroup(){

            public String getVersion() {
                return BundleGroupFactory.this.version;
            }

            public String getProviderName() {
                return BundleGroupFactory.this.providerName;
            }

            public String getProperty(String key) {
                return null;
            }

            public String getName() {
                return BundleGroupFactory.this.name;
            }

            public String getIdentifier() {
                return BundleGroupFactory.this.identifier;
            }

            public String getDescription() {
                return BundleGroupFactory.this.description;
            }

            public Bundle[] getBundles() {
                return new Bundle[0];
            }
        };
    }
}

