/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.tests.about;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.eclipse.core.runtime.IBundleGroupProvider;
import org.eclipse.e4.core.internal.services.about.InstalledFeatures;
import org.eclipse.e4.core.internal.tests.about.BundleGroupFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class InstalledFeaturesTest {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test
    public void testInstalledFeatures() throws IOException {
        InstalledFeatures service = new InstalledFeatures();
        int amount = 3;
        IBundleGroupProvider provider = BundleGroupFactory.provider("bgp", IntStream.range(0, amount).mapToObj(i -> BundleGroupFactory.identify("id" + i, "1." + i + ".0").describe("name" + i, "description" + i, "providerName" + i)).collect(Collectors.toList()));
        service.bindBundleProvider(provider);
        Throwable throwable = null;
        Object var5_6 = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                try (PrintWriter pw = new PrintWriter(baos);){
                    service.append(pw);
                    pw.flush();
                    String printed = new String(baos.toByteArray(), Charset.defaultCharset());
                    IntStream.range(0, amount).mapToObj(i -> "id" + i + " (1." + i + ".0) \"name" + i + "\"").forEach(s -> Assertions.assertTrue((boolean)printed.contains((CharSequence)s)));
                }
                if (baos == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (baos == null) throw throwable;
                baos.close();
                throw throwable;
            }
            baos.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }
}

