/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.tests.contexts;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import org.eclipse.e4.core.contexts.ContextFunction;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.contexts.RunAndTrack;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ActivationTest {
    @Test
    public void testContextActivation() {
        IEclipseContext rootContext = EclipseContextFactory.create((String)"root");
        rootContext.set("testRAT", (Object)new TestRAT());
        IEclipseContext child1 = rootContext.createChild("child1");
        IEclipseContext child11 = child1.createChild("child11");
        IEclipseContext child12 = child1.createChild("child12");
        IEclipseContext child2 = rootContext.createChild("child2");
        IEclipseContext child21 = child2.createChild("child21");
        IEclipseContext child22 = child2.createChild("child22");
        Assertions.assertEquals((Object)rootContext, (Object)rootContext.getActiveLeaf());
        Assertions.assertNull((Object)rootContext.getActiveChild());
        Assertions.assertEquals((Object)"root", (Object)rootContext.get("testRAT"));
        child12.activateBranch();
        Assertions.assertEquals((Object)child12, (Object)rootContext.getActiveLeaf());
        Assertions.assertEquals((Object)child1, (Object)rootContext.getActiveChild());
        Assertions.assertEquals((Object)"child12", (Object)rootContext.get("testRAT"));
        Assertions.assertEquals((Object)child2, (Object)child2.getActiveLeaf());
        Assertions.assertNull((Object)child2.getActiveChild());
        Assertions.assertEquals((Object)"child2", (Object)child2.get("testRAT"));
        child21.activateBranch();
        Assertions.assertEquals((Object)child21, (Object)rootContext.getActiveLeaf());
        Assertions.assertEquals((Object)child2, (Object)rootContext.getActiveChild());
        Assertions.assertEquals((Object)"child21", (Object)rootContext.get("testRAT"));
        Assertions.assertEquals((Object)child12, (Object)child1.getActiveLeaf());
        Assertions.assertEquals((Object)child12, (Object)child1.getActiveChild());
        Assertions.assertEquals((Object)"child12", (Object)child1.get("testRAT"));
        Assertions.assertEquals((Object)child21, (Object)child2.getActiveLeaf());
        Assertions.assertEquals((Object)child21, (Object)child2.getActiveChild());
        Assertions.assertEquals((Object)"child21", (Object)child2.get("testRAT"));
        child21.deactivate();
        Assertions.assertEquals((Object)child2, (Object)rootContext.getActiveLeaf());
        Assertions.assertEquals((Object)"child2", (Object)rootContext.get("testRAT"));
        Assertions.assertEquals((Object)child12, (Object)child1.getActiveLeaf());
        Assertions.assertEquals((Object)"child12", (Object)child1.get("testRAT"));
        Assertions.assertEquals((Object)child2, (Object)child2.getActiveLeaf());
        Assertions.assertNull((Object)child2.getActiveChild());
        Assertions.assertEquals((Object)"child2", (Object)child2.get("testRAT"));
        child22.activateBranch();
        Assertions.assertEquals((Object)child22, (Object)rootContext.getActiveLeaf());
        Assertions.assertEquals((Object)"child22", (Object)rootContext.get("testRAT"));
        Assertions.assertEquals((Object)child12, (Object)child1.getActiveLeaf());
        Assertions.assertEquals((Object)"child12", (Object)child1.get("testRAT"));
        Assertions.assertEquals((Object)child22, (Object)child2.getActiveLeaf());
        Assertions.assertEquals((Object)"child22", (Object)child2.get("testRAT"));
        child11.activateBranch();
        Assertions.assertEquals((Object)child11, (Object)rootContext.getActiveLeaf());
        Assertions.assertEquals((Object)"child11", (Object)rootContext.get("testRAT"));
        Assertions.assertEquals((Object)child11, (Object)child1.getActiveLeaf());
        Assertions.assertEquals((Object)"child11", (Object)child1.get("testRAT"));
        Assertions.assertEquals((Object)child22, (Object)child2.getActiveLeaf());
        Assertions.assertEquals((Object)"child22", (Object)child2.get("testRAT"));
        child11.deactivate();
        Assertions.assertEquals((Object)child1, (Object)rootContext.getActiveLeaf());
        Assertions.assertEquals((Object)"child1", (Object)rootContext.get("testRAT"));
        Assertions.assertEquals((Object)child1, (Object)child1.getActiveLeaf());
        Assertions.assertEquals((Object)"child1", (Object)child1.get("testRAT"));
        Assertions.assertEquals((Object)child22, (Object)child2.getActiveLeaf());
        Assertions.assertEquals((Object)"child22", (Object)child2.get("testRAT"));
        child1.dispose();
        Assertions.assertNull((Object)rootContext.getActiveChild());
        child2.activateBranch();
        Assertions.assertEquals((Object)child22, (Object)rootContext.getActiveLeaf());
        Assertions.assertEquals((Object)"child22", (Object)rootContext.get("testRAT"));
        Assertions.assertEquals((Object)child22, (Object)child2.getActiveLeaf());
        Assertions.assertEquals((Object)"child22", (Object)child2.get("testRAT"));
    }

    @Test
    public void testGetActive() {
        IEclipseContext root = EclipseContextFactory.create((String)"root");
        IEclipseContext child1 = root.createChild("child1");
        IEclipseContext child11 = child1.createChild("child11");
        IEclipseContext child12 = child1.createChild("child12");
        IEclipseContext child2 = root.createChild("child2");
        IEclipseContext child21 = child2.createChild("child21");
        IEclipseContext child22 = child2.createChild("child22");
        child11.set("var", (Object)"1");
        child12.set("var", (Object)"2");
        child1.set("var", (Object)"3");
        child21.set("var", (Object)"4");
        child22.set("var", (Object)"5");
        child2.set("var", (Object)"6");
        root.set("var", (Object)"7");
        Assertions.assertEquals((Object)"3", (Object)child1.getActive("var"));
        child11.activateBranch();
        Assertions.assertEquals((Object)"1", (Object)child1.getActive("var"));
        child12.activateBranch();
        Assertions.assertEquals((Object)"2", (Object)child1.getActive("var"));
        child22.activateBranch();
        Assertions.assertEquals((Object)"5", (Object)child2.getActive("var"));
    }

    @Test
    public void testGetActiveBug384425() {
        IEclipseContext root = EclipseContextFactory.create((String)"root");
        IEclipseContext child1 = root.createChild("child1");
        IEclipseContext child11 = child1.createChild("child11");
        IEclipseContext child2 = root.createChild("child2");
        Assertions.assertNull((Object)root.getActive("var"));
        Assertions.assertNull((Object)child1.getActive("var"));
        Assertions.assertNull((Object)child2.getActive("var"));
        child11.activateBranch();
        child11.set("var", (Object)"1");
        Assertions.assertEquals((Object)"1", (Object)root.getActive("var"));
        Assertions.assertEquals((Object)"1", (Object)child1.getActive("var"));
        Assertions.assertNull((Object)child2.getActive("var"));
    }

    @Test
    public void testGetActiveRAT() {
        IEclipseContext root = EclipseContextFactory.create((String)"root");
        IEclipseContext child1 = root.createChild("child1");
        IEclipseContext child11 = child1.createChild("child11");
        IEclipseContext child12 = child1.createChild("child12");
        IEclipseContext child2 = root.createChild("child2");
        IEclipseContext child21 = child2.createChild("child21");
        IEclipseContext child22 = child2.createChild("child22");
        child11.set("var", (Object)"1");
        child12.set("var", (Object)"2");
        child1.set("var", (Object)"3");
        child21.set("var", (Object)"4");
        child22.set("var", (Object)"5");
        child2.set("var", (Object)"6");
        root.set("var", (Object)"7");
        final String[] result = new String[1];
        child1.runAndTrack(new RunAndTrack(){

            public boolean changed(IEclipseContext context) {
                result[0] = (String)context.getActive("var");
                return true;
            }
        });
        Assertions.assertEquals((Object)"3", (Object)result[0]);
        child11.activateBranch();
        Assertions.assertEquals((Object)"1", (Object)result[0]);
        child12.activateBranch();
        Assertions.assertEquals((Object)"2", (Object)result[0]);
        child22.activateBranch();
        Assertions.assertEquals((Object)"2", (Object)result[0]);
    }

    @Test
    public void testGetActiveRATNumberOfCalls() {
        IEclipseContext root = EclipseContextFactory.create((String)"root");
        IEclipseContext child1 = root.createChild("child1");
        IEclipseContext child11 = child1.createChild("child11");
        IEclipseContext child12 = child1.createChild("child12");
        IEclipseContext child2 = root.createChild("child2");
        IEclipseContext child21 = child2.createChild("child21");
        IEclipseContext child22 = child2.createChild("child22");
        child11.set("var", (Object)"1");
        child12.set("var", (Object)"1");
        child1.set("var", (Object)"3");
        child21.set("var", (Object)"4");
        child22.set("var", (Object)"4");
        child2.set("var", (Object)"6");
        root.set("var", (Object)"7");
        final String[] result = new String[1];
        final int[] called = new int[]{0};
        child1.runAndTrack(new RunAndTrack(){

            public boolean changed(IEclipseContext context) {
                result[0] = (String)context.getActive("var");
                called[0] = called[0] + 1;
                return true;
            }
        });
        Assertions.assertEquals((Object)"3", (Object)result[0]);
        Assertions.assertEquals((int)1, (int)called[0]);
        child11.activateBranch();
        Assertions.assertEquals((Object)"1", (Object)result[0]);
        Assertions.assertEquals((int)2, (int)called[0]);
        child12.activateBranch();
        Assertions.assertEquals((Object)"1", (Object)result[0]);
        Assertions.assertEquals((int)3, (int)called[0]);
        child22.activateBranch();
        Assertions.assertEquals((Object)"1", (Object)result[0]);
        Assertions.assertEquals((int)3, (int)called[0]);
        child21.activateBranch();
        Assertions.assertEquals((Object)"1", (Object)result[0]);
        Assertions.assertEquals((int)3, (int)called[0]);
    }

    @Test
    public void testGetActiveRATNumberOfCalls2() {
        IEclipseContext root = EclipseContextFactory.create((String)"root");
        IEclipseContext child1 = root.createChild("child1");
        IEclipseContext child11 = child1.createChild("child11");
        IEclipseContext child12 = child1.createChild("child12");
        IEclipseContext child2 = root.createChild("child2");
        IEclipseContext child21 = child2.createChild("child21");
        IEclipseContext child22 = child2.createChild("child22");
        child11.set("var", (Object)"11");
        child12.set("var", (Object)"12");
        child1.set("var", (Object)"3");
        child21.set("var", (Object)"21");
        child22.set("var", (Object)"22");
        child2.set("var", (Object)"6");
        root.set("var", (Object)"7");
        final String[] result = new String[1];
        final int[] called = new int[]{0};
        child1.runAndTrack(new RunAndTrack(){

            public boolean changed(IEclipseContext context) {
                result[0] = (String)context.getActive("var");
                called[0] = called[0] + 1;
                return true;
            }
        });
        Assertions.assertEquals((Object)"3", (Object)result[0]);
        Assertions.assertEquals((int)1, (int)called[0]);
        child11.activateBranch();
        Assertions.assertEquals((Object)"11", (Object)result[0]);
        Assertions.assertEquals((int)2, (int)called[0]);
        child12.activateBranch();
        Assertions.assertEquals((Object)"12", (Object)result[0]);
        Assertions.assertEquals((int)3, (int)called[0]);
        child22.activateBranch();
        Assertions.assertEquals((Object)"12", (Object)result[0]);
        Assertions.assertEquals((int)3, (int)called[0]);
        child21.activateBranch();
        Assertions.assertEquals((Object)"12", (Object)result[0]);
        Assertions.assertEquals((int)3, (int)called[0]);
    }

    public static class ActiveInject {
        public String value;

        @Inject
        public void setValue(@Named(value="var") String value) {
            this.value = value;
        }
    }

    public static class TestRAT
    extends ContextFunction {
        public Object compute(IEclipseContext context, String contextKey) {
            IEclipseContext activeContext = context.getActiveLeaf();
            return activeContext.get("debugString");
        }
    }
}

