/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.tests.contexts;

import org.eclipse.e4.core.contexts.ContextFunction;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.internal.tests.contexts.inject.ObjectBasic;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ContextDynamicTest {
    @Test
    public void testReplaceFunctionWithStaticValue() {
        IEclipseContext parent = EclipseContextFactory.create();
        IEclipseContext context = parent.createChild();
        Assertions.assertNull((Object)context.getLocal("bar"));
        context.set("bar", (Object)"baz1");
        context.set("bar", (Object)new ContextFunction(){

            public Object compute(IEclipseContext context, String contextKey) {
                return "baz1";
            }
        });
        parent.set("bar", (Object)"baz2");
        Assertions.assertEquals((Object)"baz1", (Object)context.get("bar"));
        context.set("bar", (Object)"baz3");
        Assertions.assertEquals((Object)"baz3", (Object)context.get("bar"));
    }

    @Test
    public synchronized void testAddRemove() {
        Integer testInt = 123;
        String testString = "abc";
        Double testDouble = 1.23;
        Float testFloat = Float.valueOf(12.3f);
        Character testChar = Character.valueOf('v');
        IEclipseContext context = EclipseContextFactory.create();
        context.set(Integer.class.getName(), (Object)testInt);
        context.set(String.class.getName(), (Object)testString);
        context.set(Double.class.getName(), (Object)testDouble);
        context.set(Float.class.getName(), (Object)testFloat);
        context.set(Character.class.getName(), (Object)testChar);
        ObjectBasic userObject = new ObjectBasic();
        ContextInjectionFactory.inject((Object)userObject, (IEclipseContext)context);
        Assertions.assertEquals((Object)testString, (Object)userObject.injectedString);
        Assertions.assertEquals((Integer)testInt, (Integer)userObject.getInt());
        Assertions.assertEquals((Object)context, (Object)userObject.context);
        Assertions.assertEquals((int)1, (int)userObject.setMethodCalled);
        Assertions.assertEquals((int)1, (int)userObject.setMethodCalled2);
        Assertions.assertEquals((Double)testDouble, (Double)userObject.d);
        Assertions.assertEquals((Float)testFloat, (Float)userObject.f);
        Assertions.assertEquals((Character)testChar, (Character)userObject.c);
        Double testDouble2 = 3.45;
        Integer testInt2 = 123;
        context.set(Double.class.getName(), (Object)testDouble2);
        context.set(Integer.class.getName(), (Object)testInt2);
        Assertions.assertEquals((Object)testString, (Object)userObject.injectedString);
        Assertions.assertEquals((Integer)testInt2, (Integer)userObject.getInt());
        Assertions.assertEquals((Object)context, (Object)userObject.context);
        Assertions.assertEquals((int)2, (int)userObject.setMethodCalled);
        Assertions.assertEquals((int)1, (int)userObject.setMethodCalled2);
        Assertions.assertEquals((Double)testDouble2, (Double)userObject.d);
        Assertions.assertEquals((Float)testFloat, (Float)userObject.f);
        Assertions.assertEquals((Character)testChar, (Character)userObject.c);
        context.remove(String.class.getName());
        context.remove(Character.class.getName());
        Assertions.assertNull((Object)userObject.injectedString);
        Assertions.assertEquals((Integer)testInt2, (Integer)userObject.getInt());
        Assertions.assertEquals((Object)context, (Object)userObject.context);
        Assertions.assertEquals((int)2, (int)userObject.setMethodCalled);
        Assertions.assertEquals((int)2, (int)userObject.setMethodCalled2);
        Assertions.assertEquals((Double)testDouble2, (Double)userObject.d);
        Assertions.assertEquals((Float)testFloat, (Float)userObject.f);
        Assertions.assertNull((Object)userObject.c);
    }

    @Test
    public synchronized void testParentAddRemove() {
        Integer testInt = 123;
        String testString = "abc";
        Double testDouble = 1.23;
        Float testFloat = Float.valueOf(12.3f);
        Character testChar = Character.valueOf('v');
        IEclipseContext parentContext = EclipseContextFactory.create();
        parentContext.set(Integer.class.getName(), (Object)testInt);
        parentContext.set(String.class.getName(), (Object)testString);
        parentContext.set(Double.class.getName(), (Object)testDouble);
        parentContext.set(Float.class.getName(), (Object)testFloat);
        parentContext.set(Character.class.getName(), (Object)testChar);
        IEclipseContext context = parentContext.createChild();
        ObjectBasic userObject = new ObjectBasic();
        ContextInjectionFactory.inject((Object)userObject, (IEclipseContext)context);
        Assertions.assertEquals((Object)testString, (Object)userObject.injectedString);
        Assertions.assertEquals((Integer)testInt, (Integer)userObject.getInt());
        Assertions.assertEquals((Object)context, (Object)userObject.context);
        Assertions.assertEquals((int)1, (int)userObject.setMethodCalled);
        Assertions.assertEquals((int)1, (int)userObject.setMethodCalled2);
        Assertions.assertEquals((Double)testDouble, (Double)userObject.d);
        Assertions.assertEquals((Float)testFloat, (Float)userObject.f);
        Assertions.assertEquals((Character)testChar, (Character)userObject.c);
        Double testDouble2 = 3.45;
        Integer testInt2 = 123;
        context.set(Double.class.getName(), (Object)testDouble2);
        context.set(Integer.class.getName(), (Object)testInt2);
        Assertions.assertEquals((Object)testString, (Object)userObject.injectedString);
        Assertions.assertEquals((Integer)testInt2, (Integer)userObject.getInt());
        Assertions.assertEquals((Object)context, (Object)userObject.context);
        Assertions.assertEquals((int)2, (int)userObject.setMethodCalled);
        Assertions.assertEquals((int)1, (int)userObject.setMethodCalled2);
        Assertions.assertEquals((Double)testDouble2, (Double)userObject.d);
        Assertions.assertEquals((Float)testFloat, (Float)userObject.f);
        Assertions.assertEquals((Character)testChar, (Character)userObject.c);
        parentContext.remove(String.class.getName());
        parentContext.remove(Character.class.getName());
        Assertions.assertNull((Object)userObject.injectedString);
        Assertions.assertEquals((Integer)testInt2, (Integer)userObject.getInt());
        Assertions.assertEquals((Object)context, (Object)userObject.context);
        Assertions.assertEquals((int)2, (int)userObject.setMethodCalled);
        Assertions.assertEquals((int)2, (int)userObject.setMethodCalled2);
        Assertions.assertEquals((Double)testDouble2, (Double)userObject.d);
        Assertions.assertEquals((Float)testFloat, (Float)userObject.f);
        Assertions.assertNull((Object)userObject.c);
    }
}

