/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.tests.contexts;

import org.eclipse.e4.core.contexts.ContextFunction;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.contexts.RunAndTrack;
import org.eclipse.e4.core.di.IInjector;
import org.eclipse.e4.core.internal.contexts.EclipseContext;
import org.eclipse.e4.core.internal.tests.contexts.AddContextFunction;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public class EclipseContextTest {
    private IEclipseContext context;
    private IEclipseContext parentContext;
    private int runCounter;

    @BeforeEach
    public void setUp() throws Exception {
        this.parentContext = EclipseContextFactory.create((String)"EclipseContextTest-parent");
        this.context = this.parentContext.createChild("EclipseContextTest");
        this.runCounter = 0;
    }

    @Test
    public void testContainsKey() {
        Assertions.assertFalse((boolean)this.context.containsKey("function"));
        Assertions.assertFalse((boolean)this.context.containsKey("separator"));
        this.context.set("separator", (Object)",");
        Assertions.assertTrue((boolean)this.context.containsKey("separator"));
        this.context.set("separator", null);
        Assertions.assertTrue((boolean)this.context.containsKey("separator"));
        this.context.remove("separator");
        Assertions.assertFalse((boolean)this.context.containsKey("separator"));
    }

    @Test
    public void testGet() {
        Assertions.assertNull((Object)this.context.get("foo"));
        this.context.set("foo", (Object)"bar");
        Assertions.assertEquals((Object)"bar", (Object)this.context.get("foo"));
        Assertions.assertNull((Object)this.parentContext.get("foo"));
        this.context.remove("foo");
        Assertions.assertNull((Object)this.context.get("foo"));
        this.parentContext.set("foo", (Object)"bar");
        Assertions.assertEquals((Object)"bar", (Object)this.context.get("foo"));
        this.context.set("foo", (Object)new ComputedValueBar());
        Assertions.assertNull((Object)this.context.get("foo"));
        this.context.set("bar", (Object)"baz");
        Assertions.assertEquals((Object)"baz", (Object)this.context.get("foo"));
    }

    @Test
    public void testGetLocal() {
        Assertions.assertNull((Object)this.context.getLocal("foo"));
        this.context.set("foo", (Object)"bar");
        Assertions.assertEquals((Object)"bar", (Object)this.context.getLocal("foo"));
        Assertions.assertNull((Object)this.parentContext.getLocal("foo"));
        this.context.remove("foo");
        Assertions.assertNull((Object)this.context.getLocal("foo"));
        this.parentContext.set("foo", (Object)"bar");
        Assertions.assertNull((Object)this.context.getLocal("foo"));
        this.context.set("foo", (Object)new ComputedValueBar());
        Assertions.assertNull((Object)this.context.getLocal("foo"));
        this.context.set("bar", (Object)"baz");
        Assertions.assertEquals((Object)"baz", (Object)this.context.getLocal("foo"));
    }

    @Test
    public void testDisposeRemovesParentReference() {
        Assertions.assertNull((Object)this.context.get("foo"));
        this.parentContext.set("foo", (Object)"bar");
        Assertions.assertEquals((Object)"bar", (Object)this.context.get("foo"));
        this.context.dispose();
        Assertions.assertNull((Object)this.context.get("foo"));
        Assertions.assertFalse((boolean)((EclipseContext)this.parentContext).getChildren().iterator().hasNext());
    }

    @Test
    public void testDisposeClearsNotifyOnDisposalSet() {
        ((EclipseContext)this.context).notifyOnDisposal(context -> {
            int n = this.runCounter;
            int n2 = n;
            this.runCounter = n + 1;
        });
        this.context.dispose();
        Assertions.assertEquals((int)1, (int)this.runCounter);
        this.context.dispose();
        Assertions.assertEquals((int)1, (int)this.runCounter);
    }

    @Test
    public void testContextFunctionInParent() {
        IEclipseContext parent = EclipseContextFactory.create();
        IEclipseContext child = parent.createChild();
        parent.set("sum", (Object)new AddContextFunction());
        parent.set("x", (Object)3);
        parent.set("y", (Object)3);
        child.set("x", (Object)1);
        child.set("y", (Object)1);
        Assertions.assertEquals((int)6, (int)((Integer)parent.get("sum")));
        Assertions.assertEquals((int)2, (int)((Integer)child.get("sum")));
        child.set("x", (Object)5);
        Assertions.assertEquals((int)6, (int)((Integer)parent.get("sum")));
        Assertions.assertEquals((int)6, (int)((Integer)child.get("sum")));
        child.remove("x");
        Assertions.assertEquals((int)6, (int)((Integer)parent.get("sum")));
        Assertions.assertEquals((int)4, (int)((Integer)child.get("sum")));
        parent.set("x", (Object)10);
        Assertions.assertEquals((int)13, (int)((Integer)parent.get("sum")));
        Assertions.assertEquals((int)11, (int)((Integer)child.get("sum")));
    }

    @Test
    public void testRunAndTrack() {
        final Object[] value = new Object[1];
        this.context.runAndTrack(new RunAndTrack(){

            public boolean changed(IEclipseContext context) {
                ++EclipseContextTest.this.runCounter;
                value[0] = context.get("foo");
                return true;
            }
        });
        Assertions.assertEquals((int)1, (int)this.runCounter);
        Assertions.assertEquals(null, (Object)value[0]);
        this.context.set("foo", (Object)"bar");
        Assertions.assertEquals((int)2, (int)this.runCounter);
        Assertions.assertEquals((Object)"bar", (Object)value[0]);
        this.context.remove("foo");
        Assertions.assertEquals((int)3, (int)this.runCounter);
        Assertions.assertEquals(null, (Object)value[0]);
        this.context.set("foo", (Object)new ContextFunction(){

            public Object compute(IEclipseContext context, String contextKey) {
                return context.get("bar");
            }
        });
        Assertions.assertEquals((int)4, (int)this.runCounter);
        Assertions.assertEquals(null, (Object)value[0]);
        this.context.set("bar", (Object)"baz");
        Assertions.assertEquals((int)5, (int)this.runCounter);
        Assertions.assertEquals((Object)"baz", (Object)value[0]);
        this.context.set("bar", (Object)"baf");
        Assertions.assertEquals((int)6, (int)this.runCounter);
        Assertions.assertEquals((Object)"baf", (Object)value[0]);
        this.context.remove("bar");
        Assertions.assertEquals((int)7, (int)this.runCounter);
        Assertions.assertEquals(null, (Object)value[0]);
        this.parentContext.set("bar", (Object)"bam");
        Assertions.assertEquals((int)8, (int)this.runCounter);
        Assertions.assertEquals((Object)"bam", (Object)value[0]);
    }

    @Test
    public void testRegisterRunAndTrackTwice() {
        final Object[] value = new Object[1];
        RunAndTrack runnable = new RunAndTrack(){

            public boolean changed(IEclipseContext context) {
                ++EclipseContextTest.this.runCounter;
                value[0] = context.get("foo");
                return true;
            }
        };
        this.context.runAndTrack(runnable);
        Assertions.assertEquals((int)1, (int)this.runCounter);
        this.context.runAndTrack(runnable);
        Assertions.assertEquals((int)2, (int)this.runCounter);
        Assertions.assertEquals(null, (Object)value[0]);
        this.context.set("foo", (Object)"bar");
        Assertions.assertEquals((int)3, (int)this.runCounter);
        Assertions.assertEquals((Object)"bar", (Object)value[0]);
        this.context.remove("foo");
        Assertions.assertEquals((int)4, (int)this.runCounter);
    }

    @Test
    public void testRunAndTrackMultipleValues() {
        IEclipseContext parent = EclipseContextFactory.create((String)"ParentContext");
        final IEclipseContext child = parent.createChild("ChildContext");
        parent.set("parentValue", (Object)"x");
        child.set("childValue", (Object)"x");
        RunAndTrack runnable = new RunAndTrack(){

            public boolean changed(IEclipseContext context) {
                ++EclipseContextTest.this.runCounter;
                if (EclipseContextTest.this.runCounter < 2) {
                    child.get("childValue");
                    return true;
                }
                if (EclipseContextTest.this.runCounter < 3) {
                    child.get("parentValue");
                    return true;
                }
                return false;
            }
        };
        child.runAndTrack(runnable);
        Assertions.assertEquals((int)1, (int)this.runCounter);
        child.set("childValue", (Object)"z");
        Assertions.assertEquals((int)2, (int)this.runCounter);
        parent.set("parentValue", (Object)"z");
        Assertions.assertEquals((int)3, (int)this.runCounter);
    }

    @Test
    public void testModify() {
        IEclipseContext grandParent = EclipseContextFactory.create();
        IEclipseContext parent = grandParent.createChild();
        IEclipseContext child = parent.createChild();
        child.set("a", (Object)"a1");
        parent.set("b", (Object)"b2");
        grandParent.set("c", (Object)"c3");
        child.declareModifiable("a");
        parent.declareModifiable("b");
        grandParent.declareModifiable("c");
        Assertions.assertNull((Object)grandParent.get("b"));
        Assertions.assertEquals((Object)"b2", (Object)parent.get("b"));
        Assertions.assertEquals((Object)"b2", (Object)child.get("b"));
        Assertions.assertNull((Object)child.getLocal("b"));
        child.modify("b", (Object)"abc");
        Assertions.assertFalse((boolean)grandParent.containsKey("b"));
        Assertions.assertEquals((Object)"abc", (Object)parent.get("b"));
        Assertions.assertEquals((Object)"abc", (Object)child.get("b"));
        Assertions.assertNull((Object)child.getLocal("b"));
        child.modify("d", (Object)"123");
        Assertions.assertFalse((boolean)grandParent.containsKey("d"));
        Assertions.assertFalse((boolean)parent.containsKey("d"));
        Assertions.assertNull((Object)parent.get("d"));
        Assertions.assertEquals((Object)"123", (Object)child.get("d"));
        grandParent.modify("c", (Object)"cNew");
        Assertions.assertTrue((boolean)grandParent.containsKey("c"));
        Assertions.assertEquals((Object)"cNew", (Object)grandParent.get("c"));
        Assertions.assertNull((Object)parent.getLocal("c"));
        Assertions.assertNull((Object)child.getLocal("c"));
        Assertions.assertTrue((boolean)child.containsKey("c"));
        child.modify("a", (Object)"aNew");
        Assertions.assertTrue((boolean)child.containsKey("a"));
        Assertions.assertFalse((boolean)parent.containsKey("a"));
        Assertions.assertFalse((boolean)grandParent.containsKey("a"));
        Assertions.assertEquals((Object)"aNew", (Object)child.get("a"));
        Assertions.assertNull((Object)parent.get("a"));
        child.set("aNo", (Object)"a1");
        parent.set("bNo", (Object)"b2");
        grandParent.set("cNo", (Object)"c3");
        boolean exception = false;
        try {
            child.modify("bNo", (Object)"new");
        }
        catch (IllegalArgumentException e) {
            exception = true;
        }
        Assertions.assertTrue((boolean)exception);
        exception = false;
        try {
            grandParent.modify("cNo", (Object)"new");
        }
        catch (IllegalArgumentException e) {
            exception = true;
        }
        Assertions.assertTrue((boolean)exception);
        exception = false;
        try {
            child.modify("aNo", (Object)"new");
        }
        catch (IllegalArgumentException e) {
            exception = true;
        }
        Assertions.assertTrue((boolean)exception);
    }

    @Test
    public void testRemoveValueComputationOnDispose() {
        IEclipseContext parent = EclipseContextFactory.create((String)"ParentContext");
        IEclipseContext child = parent.createChild("ChildContext");
        parent.set("x", (Object)1);
        parent.set("y", (Object)1);
        parent.set("sum", (Object)new AddContextFunction());
        child.get("sum");
        Assertions.assertEquals((int)1, (int)this.listenersCount(child));
        child.dispose();
        Assertions.assertEquals((int)0, (int)this.listenersCount(parent));
    }

    @Test
    public void testNullInheritance() {
        IEclipseContext parent = EclipseContextFactory.create((String)"ParentContext");
        IEclipseContext child = parent.createChild("ChildContext");
        parent.set("x", (Object)1);
        child.set("x", null);
        Assertions.assertNull((Object)child.get("x"));
    }

    @Test
    public void testGetCFNotAValue() {
        IEclipseContext context = EclipseContextFactory.create((String)"ParentContext");
        context.set("x", (Object)new ContextFunction(){

            public Object compute(IEclipseContext context, String contextKey) {
                return IInjector.NOT_A_VALUE;
            }
        });
        Assertions.assertNull((Object)context.get("x"));
        Assertions.assertNull((Object)context.get("x"));
        Assertions.assertNull((Object)context.get("x"));
        context.dispose();
    }

    @Test
    public void testGetCFNotAValueToParent() {
        IEclipseContext parent = EclipseContextFactory.create((String)"ParentContext");
        IEclipseContext child = parent.createChild();
        parent.set("x", (Object)1);
        child.set("x", (Object)new ContextFunction(){

            public Object compute(IEclipseContext context, String contextKey) {
                return IInjector.NOT_A_VALUE;
            }
        });
        Assertions.assertEquals((Object)1, (Object)child.get("x"));
        parent.dispose();
    }

    @Test
    public void testContextFunctionOrdering() {
        IEclipseContext osgiContext = EclipseContextFactory.getServiceContext((BundleContext)FrameworkUtil.getBundle(this.getClass()).getBundleContext());
        Assertions.assertEquals((Object)"High", (Object)osgiContext.get("test.contextfunction.ranking"));
    }

    private int listenersCount(IEclipseContext context) {
        return ((EclipseContext)context).getListeners().size();
    }

    private static class ComputedValueBar
    extends ContextFunction {
        private ComputedValueBar() {
        }

        public Object compute(IEclipseContext context, String contextKey) {
            return context.get("bar");
        }
    }
}

