/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.tests.contexts;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.e4.core.internal.contexts.ConcurrentNeutralValueMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class NeutralValueTest {
    @Test
    public void testConcurrentNeutralValueMap() {
        ConcurrentNeutralValueMap map = new ConcurrentNeutralValueMap((Object)Double.NaN);
        map.put((Object)"nix", null);
        map.put((Object)"2", (Object)2.0);
        map.put((Object)"3", (Object)3.0);
        map.put((Object)"4", (Object)4.0);
        map.put((Object)"garnix", null);
        Assertions.assertTrue((boolean)map.containsKey((Object)"garnix"));
        map.remove((Object)"garnix");
        Assertions.assertTrue((boolean)map.containsKey((Object)"nix"));
        Assertions.assertTrue((boolean)map.containsKey((Object)"2"));
        Assertions.assertFalse((boolean)map.containsKey((Object)"1"));
        Assertions.assertFalse((boolean)map.containsKey((Object)"garnix"));
        Assertions.assertEquals((int)4, (int)map.size());
        Assertions.assertFalse((boolean)map.isEmpty());
        Assertions.assertEquals(null, (Double)((Double)map.get((Object)"nix")));
        Assertions.assertEquals(null, (Double)((Double)map.get((Object)"1")));
        Assertions.assertEquals((Double)2.0, (Double)((Double)map.get((Object)"2")));
        Assertions.assertEquals((Double)3.0, (Double)((Double)map.get((Object)"3")));
        Assertions.assertEquals((Double)4.0, (Double)((Double)map.get((Object)"4")));
        HashSet keys = new HashSet();
        HashSet values = new HashSet();
        map.forEach((k, v) -> {
            boolean bl = keys.add(k);
        });
        map.forEach((k, v) -> {
            boolean bl = values.add(v);
        });
        Assertions.assertEquals(Set.of("nix", "2", "3", "4"), keys);
        Assertions.assertTrue((boolean)values.contains(null));
        Assertions.assertTrue((boolean)values.contains(2.0));
        Assertions.assertTrue((boolean)map.getValue((Object)"nix").isPresent());
        Assertions.assertFalse((boolean)map.getValue((Object)"1").isPresent());
        Assertions.assertTrue((boolean)map.getValue((Object)"2").isPresent());
        Assertions.assertTrue((boolean)map.getValue((Object)"3").isPresent());
        Assertions.assertTrue((boolean)map.getValue((Object)"4").isPresent());
        ConcurrentNeutralValueMap.Value v2 = map.getValue((Object)"nix");
        Assertions.assertTrue((boolean)v2.isPresent());
        Assertions.assertEquals(null, (Double)((Double)v2.unwrapped()));
        v2 = map.getValue((Object)"1");
        Assertions.assertFalse((boolean)v2.isPresent());
        Assertions.assertEquals(null, (Double)((Double)v2.unwrapped()));
        v2 = map.getValue((Object)"2");
        Assertions.assertTrue((boolean)v2.isPresent());
        Assertions.assertEquals((Double)2.0, (Double)((Double)v2.unwrapped()));
        v2 = map.putAndGetOld((Object)"5", (Object)5555.0);
        Assertions.assertFalse((boolean)v2.isPresent());
        Assertions.assertEquals(null, (Double)((Double)v2.unwrapped()));
        Assertions.assertEquals((Double)5555.0, (Double)((Double)map.get((Object)"5")));
        v2 = map.putAndGetOld((Object)"5", (Object)5.0);
        Assertions.assertTrue((boolean)v2.isPresent());
        Assertions.assertEquals((Double)5555.0, (Double)((Double)v2.unwrapped()));
        Assertions.assertEquals((Double)5.0, (Double)((Double)map.get((Object)"5")));
        map.putIfAbsent((Object)"5", (Object)5555.0);
        Assertions.assertEquals((Double)5.0, (Double)((Double)map.get((Object)"5")));
        map.remove((Object)"5");
        Assertions.assertFalse((boolean)map.containsKey((Object)"5"));
        v2 = map.putAndGetOld((Object)"five", null);
        Assertions.assertFalse((boolean)v2.isPresent());
        Assertions.assertEquals(null, (Double)((Double)v2.unwrapped()));
        Assertions.assertEquals(null, (Double)((Double)map.get((Object)"five")));
        v2 = map.putAndGetOld((Object)"five", (Object)5.0);
        Assertions.assertTrue((boolean)v2.isPresent());
        Assertions.assertEquals(null, (Double)((Double)v2.unwrapped()));
        Assertions.assertEquals((Double)5.0, (Double)((Double)map.get((Object)"five")));
        map.putIfAbsent((Object)"five", null);
        v2 = map.getValue((Object)"five");
        Assertions.assertTrue((boolean)v2.isPresent());
        Assertions.assertEquals((Double)5.0, (Double)((Double)v2.unwrapped()));
        map.remove((Object)"five");
        map.putIfAbsent((Object)"five", null);
        v2 = map.getValue((Object)"five");
        Assertions.assertTrue((boolean)v2.isPresent());
        Assertions.assertEquals(null, (Double)((Double)v2.unwrapped()));
        map.remove((Object)"five");
        Assertions.assertFalse((boolean)map.containsKey((Object)"five"));
        map.clear();
        Assertions.assertEquals((int)0, (int)map.size());
        Assertions.assertTrue((boolean)map.isEmpty());
    }

    @Test
    public void testToString() {
        ConcurrentNeutralValueMap map1 = new ConcurrentNeutralValueMap();
        map1.put((Object)"0", (Object)Float.valueOf(0.0f));
        map1.put((Object)"NULL", null);
        map1.put((Object)"nothing", null);
        map1.put((Object)"1", (Object)Float.valueOf(1.0f));
        map1.put((Object)"~2", (Object)Float.valueOf(2.1f));
        Assertions.assertTrue((boolean)map1.toString().contains("0=0.0"));
        Assertions.assertTrue((boolean)map1.toString().contains("1=1.0"));
        Assertions.assertTrue((boolean)map1.toString().contains("~2=2.1"));
        Assertions.assertTrue((boolean)map1.toString().contains("NULL=null"));
        Assertions.assertTrue((boolean)map1.toString().contains("nothing=null"));
    }

    @Test
    public void testCustomToString() {
        ConcurrentNeutralValueMap map1 = new ConcurrentNeutralValueMap((Object)Float.valueOf(Float.NaN));
        map1.put((Object)"0", (Object)Float.valueOf(0.0f));
        map1.put((Object)"NULL", null);
        Assertions.assertTrue((boolean)map1.toString().contains("0=0.0"));
        Assertions.assertTrue((boolean)map1.toString().contains("NULL=NaN"));
    }

    @Test
    public void testEquals() {
        ConcurrentNeutralValueMap map1 = new ConcurrentNeutralValueMap();
        ConcurrentNeutralValueMap map2 = new ConcurrentNeutralValueMap();
        map1.put((Object)"0", (Object)Float.valueOf(0.0f));
        map1.put((Object)"NULL", null);
        map2.put((Object)"NULL", null);
        map2.put((Object)"0", (Object)Float.valueOf(0.0f));
        Assertions.assertEquals((int)map1.hashCode(), (int)map2.hashCode());
        Assertions.assertEquals((Object)map1, (Object)map2);
        map1 = new ConcurrentNeutralValueMap();
        map2 = new ConcurrentNeutralValueMap();
        map1.put((Object)"0", (Object)Float.valueOf(0.0f));
        map1.put((Object)"1", (Object)Float.valueOf(1.0f));
        map1.put((Object)"NULL", null);
        map2.put((Object)"NULL", null);
        map2.put((Object)"0", (Object)Float.valueOf(0.0f));
        Assertions.assertNotEquals((int)map1.hashCode(), (int)map2.hashCode());
        Assertions.assertNotEquals((Object)map1, (Object)map2);
        map1 = new ConcurrentNeutralValueMap((Object)Float.valueOf(Float.NaN));
        map2 = new ConcurrentNeutralValueMap((Object)Float.valueOf(Float.NaN));
        map1.put((Object)"0", (Object)Float.valueOf(0.0f));
        map1.put((Object)"NULL", null);
        map2.put((Object)"NULL", null);
        map2.put((Object)"0", (Object)Float.valueOf(0.0f));
        Assertions.assertEquals((int)map1.hashCode(), (int)map2.hashCode());
        Assertions.assertEquals((Object)map1, (Object)map2);
        map1 = new ConcurrentNeutralValueMap((Object)Float.valueOf(Float.NaN));
        map2 = new ConcurrentNeutralValueMap((Object)Float.valueOf(Float.NaN));
        map1.put((Object)"0", (Object)Float.valueOf(0.0f));
        map1.put((Object)"1", (Object)Float.valueOf(1.0f));
        map1.put((Object)"NULL", null);
        map2.put((Object)"NULL", null);
        map2.put((Object)"0", (Object)Float.valueOf(0.0f));
        Assertions.assertNotEquals((int)map1.hashCode(), (int)map2.hashCode());
        Assertions.assertNotEquals((Object)map1, (Object)map2);
    }
}

