/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.tests.contexts;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import org.eclipse.e4.core.contexts.ContextFunction;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.contexts.RunAndTrack;
import org.eclipse.e4.core.internal.tests.contexts.AddContextFunction;
import org.eclipse.e4.core.internal.tests.contexts.inject.ObjectSuperClass;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ReparentingTest {
    @Test
    public void testContextFunctionInParentRemove() {
        IEclipseContext parent = EclipseContextFactory.create((String)"parent");
        IEclipseContext child = parent.createChild("child");
        parent.set("sum", (Object)new AddContextFunction());
        parent.set("x", (Object)3);
        parent.set("y", (Object)3);
        child.set("x", (Object)1);
        child.set("y", (Object)1);
        Assertions.assertEquals((int)6, (int)((Integer)parent.get("sum")));
        Assertions.assertEquals((int)2, (int)((Integer)child.get("sum")));
        child.setParent(EclipseContextFactory.create());
        Assertions.assertEquals((int)6, (int)((Integer)parent.get("sum")));
        Assertions.assertNull((Object)child.get("sum"), (String)("Expected null but was: " + String.valueOf(child.get("sum"))));
    }

    @Test
    public void testContextFunctionInParentAdd() {
        IEclipseContext parent = EclipseContextFactory.create();
        IEclipseContext child = parent.createChild();
        child.set("x", (Object)1);
        child.set("y", (Object)1);
        Assertions.assertEquals(null, (Object)parent.get("sum"));
        Assertions.assertEquals(null, (Object)child.get("sum"));
        IEclipseContext newParent = EclipseContextFactory.create();
        child.setParent(newParent);
        newParent.set("sum", (Object)new AddContextFunction());
        Assertions.assertEquals((int)0, (int)((Integer)newParent.get("sum")));
        Assertions.assertEquals((int)2, (int)((Integer)child.get("sum")));
        newParent.set("x", (Object)3);
        newParent.set("y", (Object)3);
        Assertions.assertEquals((int)6, (int)((Integer)newParent.get("sum")));
        Assertions.assertEquals((int)2, (int)((Integer)child.get("sum")));
    }

    @Test
    public void testContextFunctionNullBecomeParent() {
        IEclipseContext child = EclipseContextFactory.create();
        child.set("sum", (Object)new AddContextFunction());
        Assertions.assertEquals((int)0, (int)((Integer)child.get("sum")));
        IEclipseContext parent = EclipseContextFactory.create();
        parent.set("x", (Object)3);
        parent.set("y", (Object)3);
        child.setParent(parent);
        Assertions.assertEquals((int)6, (int)((Integer)child.get("sum")));
    }

    @Test
    public void testContextFunctionParentBecomeNull() {
        IEclipseContext parent = EclipseContextFactory.create();
        IEclipseContext child = parent.createChild();
        parent.set("x", (Object)3);
        parent.set("y", (Object)3);
        child.set("sum", (Object)new AddContextFunction());
        Assertions.assertEquals((int)6, (int)((Integer)child.get("sum")));
        child.setParent(null);
        Assertions.assertEquals((int)0, (int)((Integer)child.get("sum")));
    }

    @Test
    public void testContextFunctionSwitchParent() {
        IEclipseContext parent = EclipseContextFactory.create();
        IEclipseContext child = parent.createChild();
        parent.set("x", (Object)3);
        parent.set("y", (Object)3);
        child.set("sum", (Object)new AddContextFunction());
        Assertions.assertEquals((int)6, (int)((Integer)child.get("sum")));
        IEclipseContext newParent = EclipseContextFactory.create();
        newParent.set("x", (Object)1);
        newParent.set("y", (Object)1);
        child.setParent(newParent);
        Assertions.assertEquals((int)2, (int)((Integer)child.get("sum")));
    }

    @Test
    public void testRunAndTrackNullBecomesParent() {
        final String[] value = new String[1];
        final IEclipseContext child = EclipseContextFactory.create();
        child.runAndTrack(new RunAndTrack(){

            public boolean changed(IEclipseContext context) {
                value[0] = (String)child.get("x");
                return true;
            }
        });
        Assertions.assertEquals(null, (Object)value[0]);
        IEclipseContext parent = EclipseContextFactory.create();
        parent.set("x", (Object)"newParent");
        child.setParent(parent);
        Assertions.assertEquals((Object)"newParent", (Object)value[0]);
    }

    @Test
    public void testRunAndTrackParentBecomeNull() {
        final String[] value = new String[1];
        IEclipseContext parent = EclipseContextFactory.create();
        final IEclipseContext child = parent.createChild();
        parent.set("x", (Object)"oldParent");
        child.runAndTrack(new RunAndTrack(){

            public boolean changed(IEclipseContext context) {
                value[0] = (String)child.get("x");
                return true;
            }
        });
        Assertions.assertEquals((Object)"oldParent", (Object)value[0]);
        child.setParent(null);
        Assertions.assertNull((Object)value[0]);
    }

    @Test
    public void testRunAndTrackSwitchParent() {
        final String[] value = new String[1];
        IEclipseContext parent = EclipseContextFactory.create();
        final IEclipseContext child = parent.createChild();
        parent.set("x", (Object)"oldParent");
        child.runAndTrack(new RunAndTrack(){

            public boolean changed(IEclipseContext context) {
                value[0] = (String)child.get("x");
                return true;
            }
        });
        Assertions.assertEquals((Object)"oldParent", (Object)value[0]);
        IEclipseContext newParent = EclipseContextFactory.create();
        newParent.set("x", (Object)"newParent");
        child.setParent(newParent);
        Assertions.assertEquals((Object)"newParent", (Object)value[0]);
    }

    @Test
    public void testInjectSwitchParent() {
        IEclipseContext oldParent = EclipseContextFactory.create();
        oldParent.set("String", (Object)"oldField");
        oldParent.set(String.class.getName(), (Object)"old");
        oldParent.set(Float.class.getName(), (Object)Float.valueOf(12.3f));
        IEclipseContext newParent = EclipseContextFactory.create();
        newParent.set("String", (Object)"newField");
        newParent.set(String.class.getName(), (Object)"new");
        newParent.set(Float.class.getName(), (Object)Float.valueOf(34.5f));
        IEclipseContext child = oldParent.createChild();
        ObjectSuperClass object = new ObjectSuperClass();
        ContextInjectionFactory.inject((Object)object, (IEclipseContext)child);
        Assertions.assertEquals((int)1, (int)object.setStringCalled);
        Assertions.assertEquals((Object)"old", (Object)object.getStringViaMethod());
        child.setParent(newParent);
        Assertions.assertEquals((Object)"new", (Object)object.getStringViaMethod());
        Assertions.assertEquals((int)2, (int)object.setStringCalled);
    }

    @Test
    public void testInjectSwitchParentSameGrandparent() {
        IEclipseContext grandpa = EclipseContextFactory.create();
        grandpa.set("String", (Object)"field");
        grandpa.set(String.class.getName(), (Object)"s");
        grandpa.set(Float.class.getName(), (Object)Float.valueOf(12.3f));
        IEclipseContext oldParent = grandpa.createChild();
        IEclipseContext newParent = grandpa.createChild();
        IEclipseContext child = oldParent.createChild();
        ObjectSuperClass object = new ObjectSuperClass();
        ContextInjectionFactory.inject((Object)object, (IEclipseContext)child);
        Assertions.assertEquals((int)1, (int)object.setStringCalled);
        child.setParent(newParent);
        Assertions.assertEquals((int)1, (int)object.setStringCalled);
    }

    @Test
    public void testUpdateSameParent() {
        final Boolean[] called = new Boolean[1];
        IEclipseContext parent = EclipseContextFactory.create((String)"parent");
        IEclipseContext newParent = EclipseContextFactory.create((String)"newParent");
        IEclipseContext child = parent.createChild("child");
        parent.set("x", (Object)"1");
        newParent.set("x", (Object)"2");
        child.runAndTrack(new RunAndTrack(){

            public boolean changed(IEclipseContext context) {
                called[0] = true;
                context.get("x");
                return true;
            }
        });
        called[0] = false;
        child.setParent(parent);
        Assertions.assertFalse((boolean)called[0]);
        child.setParent(newParent);
        Assertions.assertTrue((boolean)called[0]);
    }

    @Test
    public void testUpdateSameParentCalculated() {
        final int[] testServiceCount = new int[]{0};
        IEclipseContext parentContext = EclipseContextFactory.create((String)"parent");
        parentContext.set(TestService.class.getName(), (Object)new ContextFunction(){

            public Object compute(IEclipseContext context, String contextKey) {
                testServiceCount[0] = testServiceCount[0] + 1;
                return ContextInjectionFactory.make(TestService.class, (IEclipseContext)context);
            }
        });
        IEclipseContext childContext = parentContext.createChild("child");
        childContext.get(TestService.class);
        Assertions.assertEquals((int)1, (int)testServiceCount[0]);
        childContext.setParent(childContext.getParent());
        Assertions.assertEquals((int)1, (int)testServiceCount[0]);
    }

    @Test
    public void testBug468048_contextFunction() {
        IEclipseContext p1 = EclipseContextFactory.create((String)"parent1");
        p1.set("sample", (Object)new ContextFunction(){

            public Object compute(IEclipseContext context) {
                return 1;
            }
        });
        IEclipseContext p2 = EclipseContextFactory.create((String)"parent2");
        p2.set("sample", (Object)new ContextFunction(){

            public Object compute(IEclipseContext context) {
                return 2;
            }
        });
        IEclipseContext intermed = p1.createChild("intermed");
        IEclipseContext leaf = intermed.createChild("leaf");
        Assertions.assertEquals((Object)1, (Object)leaf.get("sample"));
        intermed.setParent(p2);
        Assertions.assertEquals((Object)2, (Object)leaf.get("sample"));
    }

    @Test
    public void testBug468048_injection() {
        IEclipseContext p1 = EclipseContextFactory.create((String)"parent1");
        p1.set("sample", (Object)new ContextFunction(){

            public Object compute(IEclipseContext context) {
                return 1;
            }
        });
        IEclipseContext p2 = EclipseContextFactory.create((String)"parent2");
        p2.set("sample", (Object)new ContextFunction(){

            public Object compute(IEclipseContext context) {
                return 2;
            }
        });
        IEclipseContext intermed = p1.createChild("intermed");
        IEclipseContext leaf = intermed.createChild("leaf");
        Bug468048 b = (Bug468048)ContextInjectionFactory.make(Bug468048.class, (IEclipseContext)leaf);
        Assertions.assertEquals((Integer)1, (Integer)b.sample);
        intermed.setParent(p2);
        Assertions.assertEquals((Integer)2, (Integer)b.sample);
    }

    @Test
    public void testContextFunctionSwitchParent_2() {
        IEclipseContext superParent = EclipseContextFactory.create((String)"root");
        IEclipseContext parent = superParent.createChild("parent-1");
        final IEclipseContext child = parent.createChild("child-1");
        child.set("x", (Object)3);
        child.set("y", (Object)3);
        superParent.set("sum", (Object)new ContextFunction(){

            public Object compute(IEclipseContext context, String contextKey) {
                if (context != child) {
                    throw new IllegalStateException("Invalid context state");
                }
                return (Integer)context.get("x") + (Integer)context.get("y");
            }
        });
        Bug541498 bug = (Bug541498)ContextInjectionFactory.make(Bug541498.class, (IEclipseContext)child);
        Assertions.assertEquals((Integer)6, (Integer)bug.value);
        IEclipseContext newParent = superParent.createChild("parent-2");
        child.setParent(newParent);
        Assertions.assertEquals((Integer)6, (Integer)bug.value);
    }

    public static class Bug468048 {
        @Inject
        @Named(value="sample")
        public Integer sample;
    }

    public static class Bug541498 {
        @Inject
        @Named(value="sum")
        Integer value;
    }

    public static class TestService {
    }
}

