/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.tests.contexts;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Supplier;
import java.util.stream.StreamSupport;
import org.eclipse.e4.core.internal.contexts.StrongIterable;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class StrongIterableTest {
    @Test
    public void testStrongIterableDeque() {
        this.testStrongIterable(ConcurrentLinkedDeque::new);
    }

    @Test
    public void testStrongIterableQueue() {
        this.testStrongIterable(ConcurrentLinkedQueue::new);
    }

    void testStrongIterable(Supplier<Collection<Reference<Integer>>> constructor) {
        this.testIterate(constructor.get());
        this.testRemoveWhileIterate(constructor.get());
        this.testRemoveAll(constructor.get());
        this.testRemoveByClear(constructor.get());
        this.testNextWithoutHasNext(constructor.get());
    }

    private void testNextWithoutHasNext(Collection<Reference<Integer>> iterable) {
        WeakReference<Object> EMPTY1 = new WeakReference<Object>(null);
        WeakReference<Object> EMPTY2 = new WeakReference<Object>(null);
        WeakReference<Integer> ONE = new WeakReference<Integer>(1);
        WeakReference<Integer> TWO = new WeakReference<Integer>(2);
        WeakReference<Integer> THREE = new WeakReference<Integer>(3);
        iterable.add(EMPTY1);
        iterable.add(ONE);
        iterable.add(TWO);
        iterable.add(EMPTY2);
        iterable.add(THREE);
        StrongIterable strongIterable = new StrongIterable(iterable);
        Iterator i = strongIterable.iterator();
        Assertions.assertEquals((int)1, (int)((Integer)i.next()));
        Assertions.assertEquals((int)2, (int)((Integer)i.next()));
        Assertions.assertEquals((int)3, (int)((Integer)i.next()));
        try {
            i.next();
        }
        catch (NoSuchElementException e) {
            Assertions.assertNotNull((Object)e);
        }
        i = strongIterable.iterator();
        Assertions.assertEquals((int)1, (int)((Integer)i.next()));
        Assertions.assertEquals((long)3L, (long)this.count((Iterable<?>)strongIterable));
        Assertions.assertEquals((long)3L, (long)this.poorMansCount((Iterable<?>)strongIterable));
        i.remove();
        Assertions.assertEquals((long)2L, (long)this.count((Iterable<?>)strongIterable));
        Assertions.assertEquals((long)2L, (long)this.poorMansCount((Iterable<?>)strongIterable));
        Assertions.assertEquals((int)2, (int)((Integer)i.next()));
        i.remove();
        Assertions.assertEquals((int)3, (int)((Integer)i.next()));
        i.remove();
        try {
            i.next();
        }
        catch (NoSuchElementException e) {
            Assertions.assertNotNull((Object)e);
        }
        Assertions.assertEquals((long)0L, (long)this.count((Iterable<?>)strongIterable));
        Assertions.assertEquals((long)0L, (long)this.poorMansCount((Iterable<?>)strongIterable));
    }

    void testRemoveWhileIterate(Collection<Reference<Integer>> iterable) {
        WeakReference<Integer> ONE = new WeakReference<Integer>(1);
        WeakReference<Integer> TWO = new WeakReference<Integer>(2);
        WeakReference<Integer> THREE = new WeakReference<Integer>(3);
        iterable.add(ONE);
        iterable.add(TWO);
        iterable.add(THREE);
        Assertions.assertEquals((long)3L, (long)this.poorMansCount(iterable));
        StrongIterable strongIterable = new StrongIterable(iterable);
        Iterator i = strongIterable.iterator();
        Assertions.assertEquals((long)3L, (long)this.count((Iterable<?>)strongIterable));
        Assertions.assertEquals((long)3L, (long)this.poorMansCount((Iterable<?>)strongIterable));
        Assertions.assertTrue((boolean)i.hasNext());
        Assertions.assertEquals((int)1, (int)((Integer)i.next()));
        Assertions.assertTrue((boolean)i.hasNext());
        Assertions.assertEquals((int)2, (int)((Integer)i.next()));
        i.remove();
        Assertions.assertEquals((long)2L, (long)this.count((Iterable<?>)strongIterable));
        Assertions.assertEquals((long)2L, (long)this.poorMansCount((Iterable<?>)strongIterable));
        Assertions.assertTrue((boolean)i.hasNext());
        Assertions.assertEquals((int)3, (int)((Integer)i.next()));
        i.remove();
        Assertions.assertEquals((long)1L, (long)this.count((Iterable<?>)strongIterable));
        Assertions.assertEquals((long)1L, (long)this.poorMansCount((Iterable<?>)strongIterable));
        Assertions.assertFalse((boolean)i.hasNext());
        try {
            i.next();
        }
        catch (NoSuchElementException e) {
            Assertions.assertNotNull((Object)e);
        }
    }

    void testRemoveAll(Collection<Reference<Integer>> iterable) {
        WeakReference<Integer> ONE = new WeakReference<Integer>(1);
        WeakReference<Integer> TWO = new WeakReference<Integer>(2);
        WeakReference<Integer> THREE = new WeakReference<Integer>(3);
        iterable.add(ONE);
        iterable.add(TWO);
        iterable.add(THREE);
        StrongIterable strongIterable = new StrongIterable(iterable);
        Assertions.assertEquals((long)3L, (long)this.count((Iterable<?>)strongIterable));
        Iterator i = strongIterable.iterator();
        while (i.hasNext()) {
            i.next();
            i.remove();
        }
        Assertions.assertEquals((long)0L, (long)this.count((Iterable<?>)strongIterable));
        Assertions.assertEquals((long)0L, (long)this.poorMansCount((Iterable<?>)strongIterable));
    }

    void testRemoveByClear(Collection<Reference<Integer>> iterable) {
        WeakReference<Integer> ONE = new WeakReference<Integer>(1);
        WeakReference<Integer> TWO = new WeakReference<Integer>(2);
        WeakReference<Integer> THREE = new WeakReference<Integer>(3);
        iterable.add(ONE);
        iterable.add(TWO);
        iterable.add(THREE);
        StrongIterable strongIterable = new StrongIterable(iterable);
        Assertions.assertEquals((long)3L, (long)this.count((Iterable<?>)strongIterable));
        for (Reference<Integer> ref : iterable) {
            ref.clear();
        }
        Assertions.assertEquals((long)0L, (long)this.count((Iterable<?>)strongIterable));
    }

    void testIterate(Collection<Reference<Integer>> iterable) {
        WeakReference<Object> EMPTY1 = new WeakReference<Object>(null);
        WeakReference<Object> EMPTY2 = new WeakReference<Object>(null);
        WeakReference<Integer> ONE = new WeakReference<Integer>(1);
        WeakReference<Integer> TWO = new WeakReference<Integer>(2);
        WeakReference<Integer> THREE = new WeakReference<Integer>(3);
        iterable.add(EMPTY1);
        iterable.add(ONE);
        iterable.add(TWO);
        iterable.add(EMPTY2);
        iterable.add(THREE);
        StrongIterable strongIterable = new StrongIterable(iterable);
        Iterator i = strongIterable.iterator();
        Assertions.assertEquals((long)3L, (long)this.count((Iterable<?>)strongIterable));
        Assertions.assertTrue((boolean)i.hasNext());
        Assertions.assertEquals((int)1, (int)((Integer)i.next()));
        Assertions.assertTrue((boolean)i.hasNext());
        Assertions.assertEquals((int)2, (int)((Integer)i.next()));
        Assertions.assertTrue((boolean)i.hasNext());
        Assertions.assertEquals((int)3, (int)((Integer)i.next()));
        Assertions.assertFalse((boolean)i.hasNext());
        try {
            i.next();
        }
        catch (NoSuchElementException e) {
            Assertions.assertNotNull((Object)e);
        }
        for (Integer strong : strongIterable) {
            Assertions.assertNotNull((Object)strong);
        }
        Assertions.assertTrue((boolean)iterable.remove(TWO));
        for (Integer strong : strongIterable) {
            Assertions.assertNotNull((Object)strong);
        }
        i = strongIterable.iterator();
        Assertions.assertEquals((long)2L, (long)this.count((Iterable<?>)strongIterable));
        Assertions.assertTrue((boolean)i.hasNext());
        Assertions.assertEquals((int)1, (int)((Integer)i.next()));
        Assertions.assertTrue((boolean)i.hasNext());
        Assertions.assertEquals((int)3, (int)((Integer)i.next()));
        Assertions.assertFalse((boolean)i.hasNext());
        try {
            i.next();
        }
        catch (NoSuchElementException e) {
            Assertions.assertNotNull((Object)e);
        }
        ONE.clear();
        i = strongIterable.iterator();
        Assertions.assertEquals((long)1L, (long)this.count((Iterable<?>)strongIterable));
        Assertions.assertTrue((boolean)i.hasNext());
        Assertions.assertEquals((int)3, (int)((Integer)i.next()));
        Assertions.assertFalse((boolean)i.hasNext());
        try {
            i.next();
        }
        catch (NoSuchElementException e) {
            Assertions.assertNotNull((Object)e);
        }
        for (Integer strong : strongIterable) {
            Assertions.assertNotNull((Object)strong);
        }
        THREE.clear();
        i = strongIterable.iterator();
        Assertions.assertEquals((long)0L, (long)this.count((Iterable<?>)strongIterable));
        Assertions.assertFalse((boolean)i.hasNext());
        try {
            i.next();
        }
        catch (NoSuchElementException e) {
            Assertions.assertNotNull((Object)e);
        }
        for (Integer strong : strongIterable) {
            Assertions.assertNotNull((Object)strong);
        }
    }

    private long count(Iterable<?> i) {
        return StreamSupport.stream(i.spliterator(), false).count();
    }

    private long poorMansCount(Iterable<?> i) {
        long count = -1L;
        try {
            Iterator<?> it = i.iterator();
            while (true) {
                ++count;
                it.next();
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            return count;
        }
    }
}

