/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.tests.contexts.inject;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.internal.tests.contexts.inject.ObjectBasic;
import org.eclipse.e4.core.internal.tests.contexts.inject.ObjectSubClass;
import org.eclipse.e4.core.internal.tests.contexts.inject.OptionalAnnotations;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AnnotationsInjectionTest {
    @Test
    public void testContextSetOneArg() {
        IEclipseContext context = EclipseContextFactory.create();
        class TestData {
            TestData() {
            }
        }
        TestData methodValue = new TestData();
        context.set("testing123", (Object)methodValue);
        class Injected {
            int contextSetCalled = 0;
            int setMethodCalled = 0;
            public TestData value;

            Injected() {
            }

            @Inject
            public void settings(IEclipseContext context) {
                ++this.contextSetCalled;
            }

            @Inject
            public void injectedMethod(@Named(value="testing123") TestData arg) {
                ++this.setMethodCalled;
                this.value = arg;
            }
        }
        Injected object = new Injected();
        ContextInjectionFactory.inject((Object)object, (IEclipseContext)context);
        Assertions.assertEquals((int)1, (int)object.setMethodCalled);
        Assertions.assertEquals((int)1, (int)object.contextSetCalled);
        TestData methodValue2 = new TestData();
        context.set("testing123", (Object)methodValue2);
        Assertions.assertEquals((int)2, (int)object.setMethodCalled);
        Assertions.assertEquals((Object)methodValue2, (Object)object.value);
        Assertions.assertEquals((int)1, (int)object.contextSetCalled);
    }

    @Test
    public void testPostConstruct() {
        IEclipseContext context = EclipseContextFactory.create();
        class TestData {
            TestData() {
            }
        }
        TestData methodValue = new TestData();
        context.set(TestData.class, (Object)methodValue);
        class Injected {
            int postConstructCalled = 0;
            int setMethodCalled = 0;
            public TestData value;

            Injected() {
            }

            @PostConstruct
            public void init() {
                ++this.postConstructCalled;
            }

            @Inject
            public void setData(TestData arg) {
                ++this.setMethodCalled;
                this.value = arg;
            }
        }
        Injected object = new Injected();
        ContextInjectionFactory.inject((Object)object, (IEclipseContext)context);
        Assertions.assertEquals((int)1, (int)object.setMethodCalled);
        Assertions.assertEquals((int)1, (int)object.postConstructCalled);
        TestData methodValue2 = new TestData();
        context.set(TestData.class, (Object)methodValue2);
        Assertions.assertEquals((int)2, (int)object.setMethodCalled);
        Assertions.assertEquals((int)1, (int)object.postConstructCalled);
        Assertions.assertEquals((Object)methodValue2, (Object)object.value);
    }

    @Test
    public synchronized void testInjection() {
        Integer testInt = 123;
        String testString = "abc";
        Double testDouble = 1.23;
        Float testFloat = Float.valueOf(12.3f);
        Character testChar = Character.valueOf('v');
        IEclipseContext context = EclipseContextFactory.create();
        context.set(Integer.class, (Object)testInt);
        context.set(String.class, (Object)testString);
        context.set(Double.class, (Object)testDouble);
        context.set(Float.class, (Object)testFloat);
        context.set(Character.class, (Object)testChar);
        ObjectBasic userObject = new ObjectBasic();
        ContextInjectionFactory.inject((Object)userObject, (IEclipseContext)context);
        Assertions.assertEquals((Object)testString, (Object)userObject.injectedString);
        Assertions.assertEquals((Integer)testInt, (Integer)userObject.getInt());
        Assertions.assertEquals((Object)context, (Object)userObject.context);
        Assertions.assertEquals((int)1, (int)userObject.setMethodCalled);
        Assertions.assertEquals((int)1, (int)userObject.setMethodCalled2);
        Assertions.assertEquals((Double)testDouble, (Double)userObject.d);
        Assertions.assertEquals((Float)testFloat, (Float)userObject.f);
        Assertions.assertEquals((Character)testChar, (Character)userObject.c);
        Assertions.assertTrue((boolean)userObject.finalized);
    }

    @Test
    public void testFieldMethodOrder() {
        AssertionError[] error = new AssertionError[1];
        IEclipseContext context = EclipseContextFactory.create();
        class TestData {
            TestData() {
            }
        }
        TestData fieldValue = new TestData();
        TestData methodValue = new TestData();
        context.set("valueField", (Object)fieldValue);
        context.set("valueMethod", (Object)methodValue);
        class Injected {
            @Inject
            @Named(value="valueField")
            Object injectedField;
            Object methodValue;
            private final /* synthetic */ AssertionError[] val$error;

            Injected(AssertionError[] assertionErrorArray) {
                this.val$error = assertionErrorArray;
            }

            @Inject
            public void injectedMethod(@Optional @Named(value="valueMethod") Object arg) {
                try {
                    Assertions.assertTrue((this.injectedField != null ? 1 : 0) != 0);
                }
                catch (AssertionError e) {
                    this.val$error[0] = e;
                }
                this.methodValue = arg;
            }
        }
        Injected object = new Injected(error);
        ContextInjectionFactory.inject((Object)object, (IEclipseContext)context);
        if (error[0] != null) {
            throw error[0];
        }
        Assertions.assertEquals((Object)fieldValue, (Object)object.injectedField);
        Assertions.assertEquals((Object)methodValue, (Object)object.methodValue);
        context.remove("valueMethod");
        if (error[0] != null) {
            throw error[0];
        }
        Assertions.assertEquals((Object)fieldValue, (Object)object.injectedField);
        Assertions.assertNull((Object)object.methodValue);
        context.dispose();
        if (error[0] != null) {
            throw error[0];
        }
    }

    @Test
    public void testOptionalInjection() {
        Integer testInt = 123;
        IEclipseContext context = EclipseContextFactory.create();
        context.set(Integer.class, (Object)testInt);
        OptionalAnnotations userObject = new OptionalAnnotations();
        ContextInjectionFactory.inject((Object)userObject, (IEclipseContext)context);
        Assertions.assertEquals((int)0, (int)userObject.methodOptionalCalled);
        Assertions.assertEquals((int)1, (int)userObject.methodRequiredCalled);
        Assertions.assertEquals((Integer)testInt, (Integer)userObject.i);
        Assertions.assertNull((Object)userObject.s);
        Assertions.assertNull((Object)userObject.d);
        Assertions.assertNull((Object)userObject.f);
        String testString = "abc";
        Double testDouble = 1.23;
        Float testFloat = Float.valueOf(12.3f);
        context.set(String.class, (Object)testString);
        context.set(Double.class, (Object)testDouble);
        context.set(Float.class, (Object)testFloat);
        Assertions.assertEquals((int)1, (int)userObject.methodOptionalCalled);
        Assertions.assertEquals((int)2, (int)userObject.methodRequiredCalled);
        Assertions.assertEquals((Integer)testInt, (Integer)userObject.i);
        Assertions.assertEquals((Object)testString, (Object)userObject.s);
        Assertions.assertEquals((Double)testDouble, (Double)userObject.d);
        Assertions.assertEquals((Float)testFloat, (Float)userObject.f);
    }

    @Test
    public void testOptionalInvoke() {
        IEclipseContext context = EclipseContextFactory.create();
        Object notAnObject = new Object();
        class TestObject {
            public int called = 0;

            TestObject() {
            }

            @Execute
            public String something(@Optional String param) {
                ++this.called;
                return param;
            }
        }
        TestObject testObject = new TestObject();
        context.set(String.class.getName(), (Object)testObject);
        Object result = ContextInjectionFactory.invoke((Object)testObject, Execute.class, (IEclipseContext)context, (Object)notAnObject);
        Assertions.assertNull((Object)result);
        Assertions.assertEquals((int)1, (int)testObject.called);
        String string = "sample";
        context.set(String.class, (Object)string);
        result = ContextInjectionFactory.invoke((Object)testObject, Execute.class, (IEclipseContext)context, (Object)notAnObject);
        Assertions.assertEquals((Object)string, (Object)result);
        Assertions.assertEquals((int)2, (int)testObject.called);
    }

    @Test
    public void testInheritedSpecialMethods() {
        IEclipseContext context = EclipseContextFactory.create();
        context.set(Integer.class, (Object)123);
        context.set(String.class, (Object)"abc");
        context.set(Float.class, (Object)Float.valueOf(12.3f));
        ObjectSubClass userObject = new ObjectSubClass();
        ContextInjectionFactory.inject((Object)userObject, (IEclipseContext)context);
        Assertions.assertEquals((int)1, (int)userObject.superPostConstructCount);
        Assertions.assertEquals((int)1, (int)userObject.subPostConstructCount);
        Assertions.assertEquals((int)0, (int)userObject.superPreDestroyCount);
        Assertions.assertEquals((int)0, (int)userObject.subPreDestroyCount);
        Assertions.assertEquals((int)0, (int)userObject.overriddenPreDestroyCount);
        context.set(Float.class, (Object)Float.valueOf(45.6f));
        Assertions.assertEquals((int)1, (int)userObject.superPostConstructCount);
        Assertions.assertEquals((int)1, (int)userObject.subPostConstructCount);
        Assertions.assertEquals((int)0, (int)userObject.superPreDestroyCount);
        Assertions.assertEquals((int)0, (int)userObject.subPreDestroyCount);
        Assertions.assertEquals((int)0, (int)userObject.overriddenPreDestroyCount);
        context.dispose();
        Assertions.assertEquals((int)1, (int)userObject.superPreDestroyCount);
        Assertions.assertEquals((int)1, (int)userObject.subPreDestroyCount);
        Assertions.assertEquals((int)1, (int)userObject.overriddenPreDestroyCount);
    }

    @Test
    public void testInvoke() {
        IEclipseContext context = EclipseContextFactory.create();
        class TestData {
            public String value;

            public TestData(String tmp) {
                this.value = tmp;
            }
        }
        TestData methodValue = new TestData("abc");
        context.set("testing123", (Object)methodValue);
        class Injected {
            public String myString;

            @Execute
            public String something(@Named(value="testing123") TestData data) {
                this.myString = data.value;
                return "true";
            }
        }
        Injected object = new Injected();
        Assertions.assertNull((Object)object.myString);
        Assertions.assertEquals((Object)"true", (Object)ContextInjectionFactory.invoke((Object)object, Execute.class, (IEclipseContext)context, null));
        Assertions.assertEquals((Object)"abc", (Object)object.myString);
    }

    @Test
    public void testPreDestroy() {
        IEclipseContext context = EclipseContextFactory.create();
        class TestData {
            TestData() {
            }
        }
        TestData methodValue = new TestData();
        context.set(TestData.class, (Object)methodValue);
        class Injected {
            int preDestoryCalled = 0;
            public TestData value;
            @Inject
            public TestData directFieldInjection;

            Injected() {
            }

            @PreDestroy
            public void aboutToClose() {
                ++this.preDestoryCalled;
                Assertions.assertNotNull((Object)this.value);
                Assertions.assertNotNull((Object)this.directFieldInjection);
            }

            @Inject
            public void setData(TestData arg) {
                this.value = arg;
            }
        }
        Injected object = new Injected();
        ContextInjectionFactory.inject((Object)object, (IEclipseContext)context);
        Assertions.assertNotNull((Object)object.value);
        Assertions.assertNotNull((Object)object.directFieldInjection);
        context.dispose();
        Assertions.assertEquals((int)1, (int)object.preDestoryCalled);
        Assertions.assertNotNull((Object)object.value);
        Assertions.assertNotNull((Object)object.directFieldInjection);
    }
}

