/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.tests.contexts.inject;

import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import org.eclipse.e4.core.contexts.ContextFunction;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ComplexDisposalTest {
    @Test
    public void testU() {
        IEclipseContext parentContext = EclipseContextFactory.create();
        parentContext.set("aString", (Object)"");
        parentContext.set(MyTest.class.getName(), (Object)new TestFunction());
        IEclipseContext context = parentContext.createChild();
        MyTest test = (MyTest)context.get(MyTest.class);
        Assertions.assertEquals((int)0, (int)test.getCount());
        context.dispose();
        Assertions.assertEquals((int)1, (int)test.getCount(), (String)"Context disposed, @PreDestroy should've been called");
        parentContext.dispose();
        Assertions.assertEquals((int)1, (int)test.getCount(), (String)"Parent context disposed, @PreDestroy should not have been called again");
    }

    @Test
    public void testV() {
        IEclipseContext parentContext = EclipseContextFactory.create();
        parentContext.set("aString", (Object)"");
        IEclipseContext context = parentContext.createChild();
        MyTest test = (MyTest)ContextInjectionFactory.make(MyTest.class, (IEclipseContext)context);
        Assertions.assertEquals((int)0, (int)test.getCount());
        context.dispose();
        Assertions.assertEquals((int)1, (int)test.getCount(), (String)"Context disposed, @PreDestroy should've been called");
        parentContext.dispose();
        Assertions.assertEquals((int)1, (int)test.getCount(), (String)"Parent context disposed, @PreDestroy should not have been called again");
    }

    @Test
    public void testW() {
        IEclipseContext parentContext = EclipseContextFactory.create();
        parentContext.set("aString", (Object)"");
        IEclipseContext context = parentContext.createChild();
        MyTest test = new MyTest();
        ContextInjectionFactory.inject((Object)test, (IEclipseContext)context);
        Assertions.assertEquals((int)0, (int)test.getCount());
        context.dispose();
        Assertions.assertEquals((int)1, (int)test.getCount(), (String)"Context disposed, @PreDestroy should've been called");
        parentContext.dispose();
        Assertions.assertEquals((int)1, (int)test.getCount(), (String)"Parent context disposed, @PreDestroy should not have been called again");
    }

    public static class MyTest {
        private int count = 0;
        @Inject
        @Named(value="aString")
        String string;

        public int getCount() {
            return this.count;
        }

        @PreDestroy
        void preDestroy() {
            ++this.count;
        }
    }

    public static class TestFunction
    extends ContextFunction {
        public Object compute(IEclipseContext context, String contextKey) {
            return ContextInjectionFactory.make(MyTest.class, (IEclipseContext)context);
        }
    }
}

