/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.tests.contexts.inject;

import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.contexts.RunAndTrack;
import org.eclipse.e4.core.internal.tests.contexts.inject.ObjectBasic;
import org.eclipse.e4.core.internal.tests.contexts.inject.ObjectSubClass;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ContextInjectionTest {
    @Test
    public void testContextSetOneArg() {
        IEclipseContext context = EclipseContextFactory.create();
        class TestData {
            TestData() {
            }
        }
        TestData methodValue = new TestData();
        context.set(TestData.class.getName(), (Object)methodValue);
        class Injected {
            int contextSetCalled = 0;
            int setMethodCalled = 0;
            public TestData value;

            Injected() {
            }

            @Inject
            public void contextSet(IEclipseContext context) {
                ++this.contextSetCalled;
            }

            @Inject
            public void InjectedMethod(TestData arg) {
                ++this.setMethodCalled;
                this.value = arg;
            }
        }
        Injected object = new Injected();
        ContextInjectionFactory.inject((Object)object, (IEclipseContext)context);
        Assertions.assertEquals((int)1, (int)object.setMethodCalled);
        Assertions.assertEquals((int)1, (int)object.contextSetCalled);
        TestData methodValue2 = new TestData();
        context.set(TestData.class.getName(), (Object)methodValue2);
        Assertions.assertEquals((int)2, (int)object.setMethodCalled);
        Assertions.assertEquals((Object)methodValue2, (Object)object.value);
        Assertions.assertEquals((int)1, (int)object.contextSetCalled);
    }

    @Test
    public void testContextSetZeroArgs() {
        IEclipseContext context = EclipseContextFactory.create();
        class TestData {
            TestData() {
            }
        }
        TestData methodValue = new TestData();
        context.set(TestData.class.getName(), (Object)methodValue);
        class Injected {
            int contextSetCalled = 0;
            int setMethodCalled = 0;
            public TestData value;

            Injected() {
            }

            @Inject
            public void contextSet() {
                ++this.contextSetCalled;
            }

            @Inject
            public void InjectedMethod(TestData arg) {
                ++this.setMethodCalled;
                this.value = arg;
            }
        }
        Injected object = new Injected();
        ContextInjectionFactory.inject((Object)object, (IEclipseContext)context);
        Assertions.assertEquals((int)1, (int)object.setMethodCalled);
        Assertions.assertEquals((int)1, (int)object.contextSetCalled);
        TestData methodValue2 = new TestData();
        context.set(TestData.class.getName(), (Object)methodValue2);
        Assertions.assertEquals((int)2, (int)object.setMethodCalled);
        Assertions.assertEquals((Object)methodValue2, (Object)object.value);
        Assertions.assertEquals((int)1, (int)object.contextSetCalled);
    }

    @Test
    public synchronized void testInjection() {
        Integer testInt = 123;
        String testString = "abc";
        Double testDouble = 1.23;
        Float testFloat = Float.valueOf(12.3f);
        Character testChar = Character.valueOf('v');
        IEclipseContext context = EclipseContextFactory.create();
        context.set(Integer.class, (Object)testInt);
        context.set(String.class, (Object)testString);
        context.set(Double.class, (Object)testDouble);
        context.set(Float.class, (Object)testFloat);
        context.set(Character.class, (Object)testChar);
        ObjectBasic userObject = new ObjectBasic();
        ContextInjectionFactory.inject((Object)userObject, (IEclipseContext)context);
        Assertions.assertEquals((Object)testString, (Object)userObject.injectedString);
        Assertions.assertEquals((Integer)testInt, (Integer)userObject.getInt());
        Assertions.assertEquals((int)1, (int)userObject.setMethodCalled);
        Assertions.assertEquals((int)1, (int)userObject.setMethodCalled2);
        Assertions.assertEquals((Double)testDouble, (Double)userObject.d);
        Assertions.assertEquals((Float)testFloat, (Float)userObject.f);
        Assertions.assertEquals((Character)testChar, (Character)userObject.c);
        Assertions.assertTrue((boolean)userObject.finalized);
    }

    @Test
    public synchronized void testInjectionFromParent() {
        Integer testInt = 123;
        String testString = "abc";
        Double testDouble = 1.23;
        Float testFloat = Float.valueOf(12.3f);
        Character testChar = Character.valueOf('v');
        IEclipseContext parentContext = EclipseContextFactory.create();
        parentContext.set(Integer.class.getName(), (Object)testInt);
        parentContext.set(String.class.getName(), (Object)testString);
        IEclipseContext context = parentContext.createChild();
        context.set(Double.class.getName(), (Object)testDouble);
        context.set(Float.class.getName(), (Object)testFloat);
        context.set(Character.class.getName(), (Object)testChar);
        ObjectBasic userObject = new ObjectBasic();
        ContextInjectionFactory.inject((Object)userObject, (IEclipseContext)context);
        Assertions.assertEquals((Object)testString, (Object)userObject.injectedString);
        Assertions.assertEquals((Integer)testInt, (Integer)userObject.getInt());
        Assertions.assertEquals((int)1, (int)userObject.setMethodCalled);
        Assertions.assertEquals((int)1, (int)userObject.setMethodCalled2);
        Assertions.assertEquals((Double)testDouble, (Double)userObject.d);
        Assertions.assertEquals((Float)testFloat, (Float)userObject.f);
        Assertions.assertEquals((Character)testChar, (Character)userObject.c);
        Assertions.assertTrue((boolean)userObject.finalized);
    }

    @Test
    public synchronized void testInjectionAndInheritance() {
        Integer testInt = 123;
        String testString = "abc";
        Float testFloat = Float.valueOf(12.3f);
        IEclipseContext context = EclipseContextFactory.create();
        context.set(Integer.class.getName(), (Object)testInt);
        context.set(String.class.getName(), (Object)testString);
        context.set(Float.class.getName(), (Object)testFloat);
        ObjectSubClass userObject = new ObjectSubClass();
        ContextInjectionFactory.inject((Object)userObject, (IEclipseContext)context);
        Assertions.assertEquals((Object)testString, (Object)userObject.getString());
        Assertions.assertEquals((Object)testString, (Object)userObject.getStringViaMethod());
        Assertions.assertEquals((int)1, (int)userObject.setStringCalled);
        Assertions.assertEquals((Integer)testInt, (Integer)userObject.getInteger());
        Assertions.assertEquals((Object)testFloat, (Object)userObject.getObjectViaMethod());
        Assertions.assertEquals((int)1, (int)userObject.setObjectCalled);
        Assertions.assertEquals((int)1, (int)userObject.setOverriddenCalled);
        Assertions.assertEquals((int)1, (int)userObject.getFinalizedCalled());
    }

    @Test
    public synchronized void testInjectionCloseOverride() {
        Integer testInt = 123;
        String testString = "abc";
        Double testDouble = 12.3;
        Boolean testBoolean = Boolean.TRUE;
        IEclipseContext context = EclipseContextFactory.create();
        context.set(Integer.class, (Object)testInt);
        context.set(String.class, (Object)testString);
        context.set(Double.class, (Object)testDouble);
        context.set(Boolean.class, (Object)testBoolean);
        OverrideTest userObject = new OverrideTest();
        ContextInjectionFactory.inject((Object)userObject, (IEclipseContext)context);
        Assertions.assertEquals((Object)testString, (Object)userObject.selectionString);
        Assertions.assertEquals((Object)testString, (Object)userObject.inputString);
        Assertions.assertTrue((boolean)userObject.finishCalled);
        Assertions.assertEquals((Integer)testInt, (Integer)userObject.selectionNum);
        Assertions.assertEquals((Object)testString, (Object)userObject.inputStringSubclass);
        Assertions.assertEquals((Double)testDouble, (Double)userObject.inputDouble);
        Assertions.assertTrue((boolean)userObject.finishOverrideCalled);
    }

    @Test
    public void testBug374421() {
        try {
            IEclipseContext context = EclipseContextFactory.create();
            context.runAndTrack(new RunAndTrack(){

                public boolean changed(IEclipseContext context) {
                    IEclipseContext staticContext = EclipseContextFactory.create();
                    ContextInjectionFactory.make(Object.class, (IEclipseContext)context, (IEclipseContext)staticContext);
                    return true;
                }
            });
        }
        catch (StackOverflowError e) {
            Assertions.fail((String)"See bug 374421 for details.");
        }
    }

    public static class BaseOverrideTest {
        public String selectionString;
        public String inputString;
        public boolean finishCalled = false;

        @Inject
        public void setSelection(String selectionString) {
            this.selectionString = selectionString;
        }

        @Inject
        public void setInput(String inputString) {
            this.inputString = inputString;
        }

        @PostConstruct
        public void finish() {
            this.finishCalled = true;
        }
    }

    public static class OverrideTest
    extends BaseOverrideTest {
        public Integer selectionNum;
        public String inputStringSubclass;
        public Double inputDouble;
        public Boolean arg;
        public boolean finishOverrideCalled = false;

        @Inject
        public void setSelection(Integer selectionNum) {
            this.selectionNum = selectionNum;
        }

        @Inject
        public void setInput(String inputString, Double inputDouble) {
            this.inputStringSubclass = inputString;
            this.inputDouble = inputDouble;
        }

        @PostConstruct
        public void finish(Boolean arg) {
            this.finishOverrideCalled = true;
            this.arg = arg;
        }
    }
}

