/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.tests.contexts.inject;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DisposingReferencedContextTest {
    @Test
    public void testContextDisposeCausesCompleteUninjection_Mandatory_True() {
        this.testContextDisposeCausesCompleteUninjection_Mandatory(true);
    }

    @Test
    public void testContextDisposeCausesCompleteUninjection_Mandatory_False() {
        this.testContextDisposeCausesCompleteUninjection_Mandatory(false);
    }

    @Test
    public void testContextDisposeCausesCompleteUninjection_Optional_True() {
        this.testContextDisposeCausesCompleteUninjection_Optional(true);
    }

    @Test
    public void testContextDisposeCausesCompleteUninjection_Optional_False() {
        this.testContextDisposeCausesCompleteUninjection_Optional(false);
    }

    private void testContextDisposeCausesCompleteUninjection_Mandatory(boolean disposeFirst) {
        IEclipseContext windowContext = EclipseContextFactory.create((String)"windowContext");
        IEclipseContext partContext = windowContext.createChild("partContext");
        partContext.activate();
        Object o = new Object();
        windowContext.set("object", o);
        MandatoryTarget target = new MandatoryTarget();
        ContextInjectionFactory.inject((Object)target, (IEclipseContext)windowContext);
        Assertions.assertEquals((Object)o, (Object)target.object, (String)"The object should have been injected");
        partContext.dispose();
        Assertions.assertEquals((Object)o, (Object)target.object, (String)"The object should not have been uninjected");
    }

    private void testContextDisposeCausesCompleteUninjection_Optional(boolean disposeFirst) {
        IEclipseContext windowContext = EclipseContextFactory.create();
        IEclipseContext partContext = windowContext.createChild();
        partContext.activate();
        Object o = new Object();
        windowContext.set("object", o);
        OptionalTarget target = new OptionalTarget();
        ContextInjectionFactory.inject((Object)target, (IEclipseContext)windowContext);
        Assertions.assertEquals((Object)o, (Object)target.object, (String)"The object should have been injected");
        partContext.dispose();
        Assertions.assertEquals((Object)o, (Object)target.object, (String)"The object should not have been uninjected");
    }

    static class MandatoryTarget {
        @Inject
        @Named(value="object")
        Object object;

        MandatoryTarget() {
        }

        @Inject
        void setActiveContext(@Named(value="activeChildContext") IEclipseContext partContext) {
            if (partContext != null) {
                partContext.get("someVar");
            }
        }
    }

    static class OptionalTarget {
        @Inject
        @Named(value="object")
        Object object;

        OptionalTarget() {
        }

        @Inject
        void setActiveContext(@Optional @Named(value="activeChildContext") IEclipseContext partContext) {
            if (partContext != null) {
                partContext.get("someVar");
            }
        }
    }
}

