/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.tests.contexts.inject;

import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ExtraDependenciesTest {
    @Test
    public void testExtraDependencies() throws InvocationTargetException, InstantiationException {
        IEclipseContext context = EclipseContextFactory.create();
        context.set("arg1", (Object)"abc");
        context.set("arg2", (Object)123);
        IEclipseContext otherContext = EclipseContextFactory.create();
        otherContext.set("arg3", (Object)"other");
        context.set("otherContext", (Object)otherContext);
        TestObject object = (TestObject)ContextInjectionFactory.make(TestObject.class, (IEclipseContext)context);
        Assertions.assertEquals((Object)"abc", (Object)object.string);
        Assertions.assertEquals((Integer)123, (Integer)object.integer);
        Assertions.assertEquals((Object)"other", (Object)object.other);
        context.set("arg2", (Object)789);
        otherContext.set("arg3", (Object)"wrong");
        Assertions.assertEquals((Object)"other", (Object)object.other);
        otherContext.dispose();
        Assertions.assertEquals((Object)"other", (Object)object.other);
        Assertions.assertFalse((boolean)object.disposed);
        context.remove("otherContext");
        Assertions.assertEquals((Object)"other", (Object)object.other);
        context.set("arg1", (Object)"xyz");
        context.set("arg2", (Object)456);
        Assertions.assertEquals((Object)"xyz", (Object)object.string);
        Assertions.assertEquals((Integer)456, (Integer)object.integer);
        Assertions.assertNull((Object)object.other);
        context.dispose();
        Assertions.assertTrue((boolean)object.disposed);
        Assertions.assertNotNull((Object)object.string);
        Assertions.assertNotNull((Object)object.integer);
        Assertions.assertNull((Object)object.other);
    }

    public static class TestObject {
        public String string;
        public Integer integer;
        public String other;
        public boolean disposed = false;

        @Inject
        public void injectedMethod(@Named(value="arg1") String strValue, @Named(value="arg2") Integer intValue, IEclipseContext context) {
            this.string = strValue;
            this.integer = intValue;
            if (context == null) {
                this.other = null;
                return;
            }
            IEclipseContext otherContext = (IEclipseContext)context.get("otherContext");
            this.other = otherContext == null ? null : (String)otherContext.get("arg3");
        }

        @PreDestroy
        public void finita() {
            this.disposed = true;
        }
    }
}

