/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.tests.contexts.inject;

import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class GenericsListTest {
    @Test
    public void testRawListInjection() {
        ArrayList list = new ArrayList();
        IEclipseContext context = EclipseContextFactory.create();
        context.set(List.class, list);
        TestNamedObject userObject = new TestNamedObject();
        ContextInjectionFactory.inject((Object)userObject, (IEclipseContext)context);
        Assertions.assertEquals(list, userObject.field);
    }

    @Test
    public void testTypeErasure() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(1);
        IEclipseContext context = EclipseContextFactory.create();
        context.set(List.class, list);
        TestNamedObject userObject = new TestNamedObject();
        ContextInjectionFactory.inject((Object)userObject, (IEclipseContext)context);
        Assertions.assertEquals(list, userObject.field);
        Assertions.assertThrows(ClassCastException.class, () -> {
            String string = userObject.combineIt();
        });
    }

    public static class TestNamedObject {
        public List<String> field;

        @Inject
        public void setList(List<String> value) {
            this.field = value;
        }

        public String combineIt() {
            StringBuilder stringBuilder = new StringBuilder();
            for (String string : this.field) {
                stringBuilder.append(string);
            }
            return stringBuilder.toString();
        }
    }
}

