/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.tests.contexts.inject;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.GroupUpdates;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class GroupedUpdatesTest {
    @Test
    public void testNoGrouping() {
        IEclipseContext context = EclipseContextFactory.create();
        context.set("string1", (Object)"x");
        context.set("string2", (Object)"y");
        InjectTargetImmediate target = new InjectTargetImmediate();
        ContextInjectionFactory.inject((Object)target, (IEclipseContext)context);
        Assertions.assertEquals((int)1, (int)target.countMain);
        target.resetCounters();
        context.set("string1", (Object)"a");
        context.set("string2", (Object)"b");
        Assertions.assertEquals((int)2, (int)target.countMain);
        Assertions.assertEquals((int)1, (int)target.countSecondary);
        context.processWaiting();
        Assertions.assertEquals((int)2, (int)target.countMain);
        Assertions.assertEquals((int)1, (int)target.countSecondary);
    }

    @Test
    public void testGrouping() {
        IEclipseContext context = EclipseContextFactory.create();
        context.set("string1", (Object)"x");
        context.set("string2", (Object)"y");
        InjectTargetWait target = new InjectTargetWait();
        ContextInjectionFactory.inject((Object)target, (IEclipseContext)context);
        Assertions.assertEquals((int)1, (int)target.countMain);
        target.resetCounters();
        context.set("string1", (Object)"a");
        context.set("string2", (Object)"b");
        Assertions.assertEquals((int)0, (int)target.countMain);
        Assertions.assertEquals((int)0, (int)target.countSecondary);
        context.processWaiting();
        Assertions.assertEquals((int)1, (int)target.countMain);
        Assertions.assertEquals((int)1, (int)target.countSecondary);
        context.processWaiting();
        Assertions.assertEquals((int)1, (int)target.countMain);
        Assertions.assertEquals((int)1, (int)target.countSecondary);
        target.resetCounters();
        context.set("string1", (Object)"x");
        context.set("string2", (Object)"y");
        context.set("string2", (Object)"z");
        context.set("string1", (Object)"delta");
        Assertions.assertEquals((int)0, (int)target.countMain);
        Assertions.assertEquals((int)0, (int)target.countSecondary);
        context.processWaiting();
        Assertions.assertEquals((int)1, (int)target.countMain);
        Assertions.assertEquals((int)1, (int)target.countSecondary);
        Assertions.assertEquals((Object)target.s1, (Object)"delta");
        Assertions.assertEquals((Object)target.s2, (Object)"z");
    }

    static class InjectTarget {
        public int countMain = 0;
        public int countSecondary = 0;
        public String s1;
        public String s2;

        InjectTarget() {
        }

        public void resetCounters() {
            this.countMain = 0;
            this.countSecondary = 0;
        }
    }

    static class InjectTargetImmediate
    extends InjectTarget {
        InjectTargetImmediate() {
        }

        @Inject
        void setInfo(@Named(value="string1") String s, @Named(value="string2") String s2) {
            ++this.countMain;
            this.s1 = s;
            this.s2 = s2;
        }

        @Inject
        void setInfoSecondary(@Named(value="string2") String s2) {
            ++this.countSecondary;
            this.s2 = s2;
        }
    }

    static class InjectTargetWait
    extends InjectTarget {
        InjectTargetWait() {
        }

        @Inject
        @GroupUpdates
        void setInfo(@Named(value="string1") String s, @Named(value="string2") String s2) {
            ++this.countMain;
            this.s1 = s;
            this.s2 = s2;
        }

        @Inject
        @GroupUpdates
        void setInfoSecondary(@Named(value="string2") String s2) {
            ++this.countSecondary;
            this.s2 = s2;
        }
    }
}

