/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.tests.contexts.inject;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class InjectStaticContextTest {
    @Test
    public void testStaticMake() {
        IEclipseContext trackedContext = EclipseContextFactory.create();
        trackedContext.set("a", (Object)"abc");
        trackedContext.set("aConstructor", (Object)"abcConstructor");
        trackedContext.set("b", (Object)"bbc");
        IEclipseContext staticContext = EclipseContextFactory.create();
        staticContext.set("b", (Object)"123");
        staticContext.set("bConstructor", (Object)"123Constructor");
        staticContext.set("c", (Object)"xyz");
        TestClass testObject = (TestClass)ContextInjectionFactory.make(TestClass.class, (IEclipseContext)trackedContext, (IEclipseContext)staticContext);
        Assertions.assertEquals((Object)trackedContext, (Object)testObject.injectedContext);
        Assertions.assertEquals((Object)"abcConstructor", (Object)testObject.aConstructorString);
        Assertions.assertEquals((Object)"123Constructor", (Object)testObject.bConstructorString);
        Assertions.assertEquals((Object)"abc", (Object)testObject.aString);
        Assertions.assertEquals((Object)"123", (Object)testObject.bString);
        Assertions.assertEquals((Object)"xyz", (Object)testObject.cString);
        Assertions.assertEquals((int)1, (int)testObject.postConstructCalled);
        Assertions.assertEquals((int)0, (int)testObject.preDestroyCalled);
        staticContext.set("b", (Object)"_123_");
        staticContext.set("bConstructor", (Object)"_123Constructor_");
        staticContext.set("c", (Object)"_xyz_");
        Assertions.assertEquals((Object)"abcConstructor", (Object)testObject.aConstructorString);
        Assertions.assertEquals((Object)"123Constructor", (Object)testObject.bConstructorString);
        Assertions.assertEquals((Object)"abc", (Object)testObject.aString);
        Assertions.assertEquals((Object)"123", (Object)testObject.bString);
        Assertions.assertEquals((Object)"xyz", (Object)testObject.cString);
        Assertions.assertEquals((int)1, (int)testObject.postConstructCalled);
        Assertions.assertEquals((int)0, (int)testObject.preDestroyCalled);
        staticContext.dispose();
        Assertions.assertEquals((Object)"abcConstructor", (Object)testObject.aConstructorString);
        Assertions.assertEquals((Object)"123Constructor", (Object)testObject.bConstructorString);
        Assertions.assertEquals((Object)"abc", (Object)testObject.aString);
        Assertions.assertEquals((Object)"123", (Object)testObject.bString);
        Assertions.assertEquals((Object)"xyz", (Object)testObject.cString);
        Assertions.assertEquals((int)1, (int)testObject.postConstructCalled);
        Assertions.assertEquals((int)0, (int)testObject.preDestroyCalled);
        trackedContext.set("a", (Object)"_abc_");
        trackedContext.set("b", (Object)"_bbc_");
        Assertions.assertEquals((Object)"_abc_", (Object)testObject.aString);
        Assertions.assertEquals((Object)"123", (Object)testObject.bString);
        ContextInjectionFactory.uninject((Object)testObject, (IEclipseContext)trackedContext);
        Assertions.assertNull((Object)testObject.injectedContext);
        Assertions.assertNull((Object)testObject.aString);
        Assertions.assertEquals((int)1, (int)testObject.postConstructCalled);
        Assertions.assertEquals((int)1, (int)testObject.preDestroyCalled);
        trackedContext.set("a", (Object)"+abc+");
        Assertions.assertNull((Object)testObject.aString);
        trackedContext.dispose();
        Assertions.assertEquals((int)1, (int)testObject.postConstructCalled);
        Assertions.assertEquals((int)1, (int)testObject.preDestroyCalled);
    }

    @Test
    public void testStaticInject() {
        IEclipseContext trackedContext = EclipseContextFactory.create();
        trackedContext.set("a", (Object)"abc");
        trackedContext.set("aConstructor", (Object)"abcConstructor");
        trackedContext.set("b", (Object)"bbc");
        IEclipseContext staticContext = EclipseContextFactory.create();
        staticContext.set("b", (Object)"123");
        staticContext.set("bConstructor", (Object)"123Constructor");
        staticContext.set("c", (Object)"xyz");
        TestClass testObject = new TestClass();
        Assertions.assertNull((Object)testObject.injectedContext);
        Assertions.assertNull((Object)testObject.aConstructorString);
        Assertions.assertNull((Object)testObject.bConstructorString);
        Assertions.assertNull((Object)testObject.aString);
        Assertions.assertNull((Object)testObject.bString);
        Assertions.assertNull((Object)testObject.cString);
        Assertions.assertEquals((int)0, (int)testObject.postConstructCalled);
        Assertions.assertEquals((int)0, (int)testObject.preDestroyCalled);
        ContextInjectionFactory.inject((Object)testObject, (IEclipseContext)trackedContext, (IEclipseContext)staticContext);
        Assertions.assertEquals((Object)trackedContext, (Object)testObject.injectedContext);
        Assertions.assertEquals((Object)"abcConstructor", (Object)testObject.aConstructorString);
        Assertions.assertEquals((Object)"123Constructor", (Object)testObject.bConstructorString);
        Assertions.assertEquals((Object)"abc", (Object)testObject.aString);
        Assertions.assertEquals((Object)"123", (Object)testObject.bString);
        Assertions.assertEquals((Object)"xyz", (Object)testObject.cString);
        Assertions.assertEquals((int)1, (int)testObject.postConstructCalled);
        Assertions.assertEquals((int)0, (int)testObject.preDestroyCalled);
        staticContext.set("b", (Object)"_123_");
        staticContext.set("bConstructor", (Object)"_123Constructor_");
        staticContext.set("c", (Object)"_xyz_");
        Assertions.assertEquals((Object)"abcConstructor", (Object)testObject.aConstructorString);
        Assertions.assertEquals((Object)"123Constructor", (Object)testObject.bConstructorString);
        Assertions.assertEquals((Object)"abc", (Object)testObject.aString);
        Assertions.assertEquals((Object)"123", (Object)testObject.bString);
        Assertions.assertEquals((Object)"xyz", (Object)testObject.cString);
        Assertions.assertEquals((int)1, (int)testObject.postConstructCalled);
        Assertions.assertEquals((int)0, (int)testObject.preDestroyCalled);
        staticContext.dispose();
        Assertions.assertEquals((Object)"abcConstructor", (Object)testObject.aConstructorString);
        Assertions.assertEquals((Object)"123Constructor", (Object)testObject.bConstructorString);
        Assertions.assertEquals((Object)"abc", (Object)testObject.aString);
        Assertions.assertEquals((Object)"123", (Object)testObject.bString);
        Assertions.assertEquals((Object)"xyz", (Object)testObject.cString);
        Assertions.assertEquals((int)1, (int)testObject.postConstructCalled);
        Assertions.assertEquals((int)0, (int)testObject.preDestroyCalled);
        trackedContext.set("a", (Object)"_abc_");
        trackedContext.set("b", (Object)"_bbc_");
        Assertions.assertEquals((Object)"_abc_", (Object)testObject.aString);
        Assertions.assertEquals((Object)"123", (Object)testObject.bString);
        ContextInjectionFactory.uninject((Object)testObject, (IEclipseContext)trackedContext);
        Assertions.assertNull((Object)testObject.injectedContext);
        Assertions.assertNull((Object)testObject.aString);
        Assertions.assertEquals((int)1, (int)testObject.postConstructCalled);
        Assertions.assertEquals((int)1, (int)testObject.preDestroyCalled);
        trackedContext.set("a", (Object)"+abc+");
        Assertions.assertNull((Object)testObject.aString);
        trackedContext.dispose();
        Assertions.assertEquals((int)1, (int)testObject.postConstructCalled);
        Assertions.assertEquals((int)1, (int)testObject.preDestroyCalled);
    }

    @Test
    public void testStaticInvoke() {
        IEclipseContext trackedContext = EclipseContextFactory.create((String)"main");
        trackedContext.set("a", (Object)"abc");
        IEclipseContext staticContext = EclipseContextFactory.create((String)"static");
        staticContext.set("b", (Object)"123");
        TestInvokeClass testObject = new TestInvokeClass();
        Assertions.assertNull((Object)testObject.aString);
        Assertions.assertNull((Object)testObject.bString);
        Object result = ContextInjectionFactory.invoke((Object)testObject, Execute.class, (IEclipseContext)trackedContext, (IEclipseContext)staticContext, null);
        Assertions.assertEquals((Object)"abc123", (Object)result);
        Assertions.assertEquals((Object)"abc", (Object)testObject.aString);
        Assertions.assertEquals((Object)"123", (Object)testObject.bString);
        Assertions.assertEquals((Object)trackedContext, (Object)testObject.context);
    }

    static class TestClass {
        public IEclipseContext injectedContext;
        public String aString;
        public String bString;
        public String cString;
        public String aConstructorString;
        public String bConstructorString;
        public int postConstructCalled = 0;
        public int preDestroyCalled = 0;

        TestClass() {
        }

        @Inject
        public void contextSet(@Optional IEclipseContext context) {
            this.injectedContext = context;
        }

        @Inject
        public void setA(@Optional @Named(value="a") String aString) {
            this.aString = aString;
        }

        @Inject
        public void setB(@Named(value="b") String bString) {
            this.bString = bString;
        }

        @Inject
        public void setC(@Named(value="c") String cString) {
            this.cString = cString;
        }

        @Inject
        public void InjectedMethod(@Named(value="aConstructor") String aString, @Named(value="bConstructor") String bString) {
            this.aConstructorString = aString;
            this.bConstructorString = bString;
        }

        @PostConstruct
        public void init() {
            ++this.postConstructCalled;
        }

        @PreDestroy
        public void dispose() {
            ++this.preDestroyCalled;
        }
    }

    static class TestInvokeClass {
        public String aString;
        public String bString;
        public IEclipseContext context;

        TestInvokeClass() {
        }

        @Execute
        public String testMethod(@Named(value="a") String aString, @Named(value="b") String bString, IEclipseContext context) {
            this.aString = aString;
            this.bString = bString;
            this.context = context;
            return aString + bString;
        }
    }
}

