/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.tests.contexts.inject;

import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import org.eclipse.e4.core.contexts.ContextFunction;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class InjectionUpdateTest {
    private IEclipseContext c1;
    private IEclipseContext c21;
    private IEclipseContext c22;

    @BeforeEach
    public void setUp() throws Exception {
        this.c1 = EclipseContextFactory.create((String)"c1");
        this.c1.set("id", (Object)"c1");
        this.c21 = this.c1.createChild("c21");
        this.c21.set("id", (Object)"c21");
        this.c1.set("c21", (Object)this.c21);
        this.c22 = this.c1.createChild("c22");
        this.c22.set("id", (Object)"c22");
        this.c1.set("c22", (Object)this.c22);
    }

    @Test
    public void testPropagation() {
        this.c1.set("base", (Object)"abc");
        this.c21.set("derived1", (Object)new ContextFunction(){

            public Object compute(IEclipseContext context, String contextKey) {
                String baseString = (String)context.get("base");
                return baseString.charAt(0) + "_";
            }
        });
        this.c22.set("derived2", (Object)new ContextFunction(){

            public Object compute(IEclipseContext context, String contextKey) {
                String baseString = (String)context.get("base");
                return "_" + baseString.charAt(baseString.length() - 1);
            }
        });
        this.c1.set("calculated", (Object)new ContextFunction(){

            public Object compute(IEclipseContext context, String contextKey) {
                IEclipseContext context21 = (IEclipseContext)context.get("c21");
                String derived1 = (String)context21.get("derived1");
                IEclipseContext context22 = (IEclipseContext)context.get("c22");
                String derived2 = (String)context22.get("derived2");
                return derived1 + derived2;
            }
        });
        PropagationTest testObject = (PropagationTest)ContextInjectionFactory.make(PropagationTest.class, (IEclipseContext)this.c1);
        Assertions.assertNotNull((Object)testObject);
        Assertions.assertEquals((int)1, (int)testObject.called);
        Assertions.assertEquals((Object)"a__c", (Object)testObject.in);
        this.c1.set("base", (Object)"123");
        Assertions.assertEquals((int)2, (int)testObject.called);
        Assertions.assertEquals((Object)"1__3", (Object)testObject.in);
        this.c1.set("base", (Object)"xyz");
        Assertions.assertEquals((int)3, (int)testObject.called);
        Assertions.assertEquals((Object)"x__z", (Object)testObject.in);
    }

    @Test
    public void testNestedUpdatesPostConstruct() throws Exception {
        IEclipseContext appContext = EclipseContextFactory.create();
        appContext.set(InjectTarget.class.getName(), (Object)new ContextFunction(){

            public Object compute(IEclipseContext context, String contextKey) {
                return ContextInjectionFactory.make(InjectTarget.class, (IEclipseContext)context);
            }
        });
        InjectTarget targetA = (InjectTarget)appContext.get(InjectTarget.class);
        targetA.modify();
        InjectTarget targetB = (InjectTarget)appContext.get(InjectTarget.class);
        Assertions.assertEquals((Object)targetA, (Object)targetB);
        Assertions.assertSame((Object)targetA, (Object)targetB);
    }

    @Test
    public void testNestedUpdatesConstructor() throws Exception {
        IEclipseContext appContext = EclipseContextFactory.create();
        appContext.set(InjectTarget2.class.getName(), (Object)new ContextFunction(){

            public Object compute(IEclipseContext context, String contextKey) {
                return ContextInjectionFactory.make(InjectTarget2.class, (IEclipseContext)context);
            }
        });
        InjectTarget2 targetA = (InjectTarget2)appContext.get(InjectTarget2.class);
        targetA.modify();
        InjectTarget2 targetB = (InjectTarget2)appContext.get(InjectTarget2.class);
        Assertions.assertEquals((Object)targetA, (Object)targetB);
        Assertions.assertSame((Object)targetA, (Object)targetB);
    }

    public static class InjectTarget {
        private static final String KEY = "key";
        @Inject
        private IEclipseContext context;

        @PostConstruct
        void pc() {
            this.context.containsKey(KEY);
        }

        public void modify() {
            this.context.set(KEY, null);
        }
    }

    public static class InjectTarget2 {
        private static final String KEY = "key";
        @Inject
        private IEclipseContext context;
        public Object key;

        @Inject
        public InjectTarget2(@Optional @Named(value="key") Object key) {
            this.key = key;
        }

        public void modify() {
            this.context.set(KEY, null);
        }
    }

    public static class PropagationTest {
        public int called = 0;
        public String in;

        @Inject
        public PropagationTest() {
        }

        @Inject
        public void setCalculated(@Named(value="calculated") String string) {
            ++this.called;
            this.in = string;
        }
    }
}

