/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.tests.contexts.inject;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ParentContextDisposalTest {
    @Test
    public void testParentContextDisposal() {
        IEclipseContext context = EclipseContextFactory.create();
        IEclipseContext child = context.createChild();
        child.set("o", new Object());
        Target target = (Target)ContextInjectionFactory.make(Target.class, (IEclipseContext)child);
        Assertions.assertEquals((int)1, (int)target.pc);
        context.dispose();
        Assertions.assertEquals((int)1, (int)target.pd);
    }

    static class Target {
        int pc = 0;
        int pd = 0;
        @Inject
        @Named(value="o")
        Object o;

        Target() {
        }

        @PostConstruct
        void pc() {
            ++this.pc;
        }

        @PreDestroy
        void pd() {
            ++this.pd;
        }
    }
}

