/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.tests.contexts.inject;

import jakarta.inject.Inject;
import jakarta.inject.Provider;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.IInjector;
import org.eclipse.e4.core.di.InjectorFactory;
import org.eclipse.e4.core.di.annotations.Execute;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ProviderInjectionTest {
    @Test
    public synchronized void testInvokeWithProvider() {
        IEclipseContext context = EclipseContextFactory.create();
        context.set(String.class.getName(), (Object)"abc");
        IInjector injector = InjectorFactory.getDefault();
        injector.addBinding(TestData.class);
        TestInvokeClass userObject = new TestInvokeClass();
        Assertions.assertEquals((Object)1, (Object)ContextInjectionFactory.invoke((Object)userObject, Execute.class, (IEclipseContext)context, null));
        Assertions.assertNotNull((Object)userObject.provider.get());
        Assertions.assertEquals((Object)"abc", (Object)((TestData)userObject.provider.get()).data);
    }

    @Test
    public synchronized void testConstructorWithProvider() {
        IEclipseContext context = EclipseContextFactory.create();
        context.set(String.class.getName(), (Object)"abc");
        IInjector injector = InjectorFactory.getDefault();
        injector.addBinding(TestData.class);
        TestConstructorClass userObject = (TestConstructorClass)ContextInjectionFactory.make(TestConstructorClass.class, (IEclipseContext)context);
        Assertions.assertNotNull((Object)userObject);
        Assertions.assertNotNull(userObject.provider);
        Assertions.assertNotNull((Object)userObject.provider.get());
        Assertions.assertEquals((Object)"abc", (Object)((TestData)userObject.provider.get()).data);
    }

    public static class TestConstructorClass {
        public Provider<TestData> provider;

        @Inject
        public TestConstructorClass(Provider<TestData> provider) {
            this.provider = provider;
        }
    }

    public static class TestData {
        public String data;

        @Inject
        public TestData(String tmp) {
            this.data = tmp;
        }
    }

    public static class TestInvokeClass {
        public Provider<TestData> provider;

        @Execute
        public int execute(Provider<TestData> arg) {
            this.provider = arg;
            return 1;
        }
    }
}

