/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.tests.contexts.inject;

import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.contexts.RunAndTrack;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.internal.tests.CoreTestsActivator;
import org.eclipse.e4.core.internal.tests.contexts.inject.PrintService;
import org.eclipse.e4.core.internal.tests.contexts.inject.StringPrintService;
import org.eclipse.e4.core.internal.tests.contexts.inject.TestOtherService;
import org.eclipse.e4.core.internal.tests.contexts.inject.TestService;
import org.eclipse.e4.core.internal.tests.contexts.inject.TestServiceA;
import org.eclipse.e4.core.internal.tests.contexts.inject.TestServiceB;
import org.eclipse.e4.core.internal.tests.contexts.inject.TestServiceController;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class ServiceContextTest {
    private IEclipseContext context;
    private final List<ServiceRegistration<?>> registrations = new ArrayList();

    @BeforeEach
    public void setUp() throws Exception {
        BundleContext bundleContext = CoreTestsActivator.getDefault().getBundleContext();
        this.context = EclipseContextFactory.getServiceContext((BundleContext)bundleContext);
        this.registrations.clear();
    }

    @AfterEach
    public void tearDown() throws Exception {
        for (ServiceRegistration<?> reg : this.registrations) {
            try {
                reg.unregister();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        this.registrations.clear();
        this.context = null;
    }

    @Test
    public void testDeclarativeService() {
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.context.containsKey("sum"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)0, (Object)this.context.get("sum"));
        this.context.set("x", (Object)1);
        this.context.set("y", (Object)2);
        int result = (Integer)this.context.get("sum");
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)result);
        this.context.set("x", (Object)5);
        result = (Integer)this.context.get("sum");
        org.junit.jupiter.api.Assertions.assertEquals((int)7, (int)result);
    }

    @Test
    public void testServiceContextAsParent() {
        IEclipseContext child = this.context.createChild("child");
        DebugOptions service = (DebugOptions)child.get(DebugOptions.class.getName());
        org.junit.jupiter.api.Assertions.assertNotNull((Object)service);
    }

    @Test
    public void testServiceInjection() {
        ServiceRegistration reg1 = null;
        ServiceRegistration reg2 = null;
        try {
            Printer userObject = new Printer();
            StringPrintService stringPrint1 = new StringPrintService();
            BundleContext bundleContext = CoreTestsActivator.getDefault().getBundleContext();
            reg1 = bundleContext.registerService(PrintService.SERVICE_NAME, (Object)stringPrint1, null);
            ContextInjectionFactory.inject((Object)userObject, (IEclipseContext)this.context);
            userObject.print("test");
            org.junit.jupiter.api.Assertions.assertEquals((Object)"test", (Object)stringPrint1.toString());
            reg1.unregister();
            reg1 = null;
            userObject.print("another test");
            org.junit.jupiter.api.Assertions.assertEquals((Object)"test", (Object)stringPrint1.toString());
            org.junit.jupiter.api.Assertions.assertNull((Object)userObject.printer);
            StringPrintService stringPrint2 = new StringPrintService();
            reg2 = bundleContext.registerService(PrintService.SERVICE_NAME, (Object)stringPrint2, null);
            userObject.print("yet another test");
            org.junit.jupiter.api.Assertions.assertEquals((Object)"test", (Object)stringPrint1.toString());
            org.junit.jupiter.api.Assertions.assertEquals((Object)"yet another test", (Object)stringPrint2.toString());
            reg2.unregister();
            reg2 = null;
            org.junit.jupiter.api.Assertions.assertNull((Object)userObject.printer);
        }
        finally {
            if (reg1 != null) {
                reg1.unregister();
                reg1 = null;
            }
            if (reg2 != null) {
                reg2.unregister();
                reg2 = null;
            }
        }
    }

    @Test
    public void testServiceAddition() {
        ServiceRegistration reg1 = null;
        try {
            Printer userObject = new Printer();
            ContextInjectionFactory.inject((Object)userObject, (IEclipseContext)this.context);
            StringPrintService stringPrint1 = new StringPrintService();
            BundleContext bundleContext = CoreTestsActivator.getDefault().getBundleContext();
            reg1 = bundleContext.registerService(PrintService.SERVICE_NAME, (Object)stringPrint1, null);
            userObject.print("test");
            org.junit.jupiter.api.Assertions.assertEquals((Object)"test", (Object)stringPrint1.toString());
        }
        finally {
            if (reg1 != null) {
                reg1.unregister();
                reg1 = null;
            }
        }
    }

    protected void ensureUnregistered(ServiceRegistration<?> reg) {
        this.registrations.add(reg);
    }

    @Test
    public void testServiceRemovalOnContextDispose() {
        StringPrintService stringPrint1 = new StringPrintService();
        BundleContext bundleContext = CoreTestsActivator.getDefault().getBundleContext();
        Bundle otherBundle = null;
        Bundle[] bundleArray = bundleContext.getBundles();
        int n = bundleArray.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle b = bundleArray[n2];
            if (b.getSymbolicName().equals("org.eclipse.core.tests.harness")) {
                otherBundle = b;
                break;
            }
            ++n2;
        }
        org.junit.jupiter.api.Assertions.assertNotNull(otherBundle);
        IEclipseContext otherServiceContext = EclipseContextFactory.getServiceContext((BundleContext)otherBundle.getBundleContext());
        ServiceRegistration reg1 = bundleContext.registerService(PrintService.SERVICE_NAME, (Object)stringPrint1, null);
        try {
            ServiceReference ref = reg1.getReference();
            PrintService service = (PrintService)otherServiceContext.get(PrintService.SERVICE_NAME);
            org.junit.jupiter.api.Assertions.assertEquals((Object)stringPrint1, (Object)service);
            Assertions.assertThat((Object[])ref.getUsingBundles()).hasSize(1);
            service = null;
            otherServiceContext.dispose();
            org.junit.jupiter.api.Assertions.assertNull((Object)ref.getUsingBundles());
        }
        finally {
            reg1.unregister();
        }
    }

    @Test
    public void testRecursiveServiceRemoval() {
        BundleContext bundleContext = CoreTestsActivator.getDefault().getBundleContext();
        ServiceRegistration reg1 = bundleContext.registerService(PrintService.SERVICE_NAME, (Object)new StringPrintService(), null);
        final IEclipseContext child = this.context.createChild();
        IEclipseContext child2 = this.context.createChild();
        child.get(PrintService.SERVICE_NAME);
        child2.get(PrintService.SERVICE_NAME);
        this.ensureUnregistered(reg1);
        final boolean[] done = new boolean[1];
        this.context.runAndTrack(new RunAndTrack(){

            public boolean changed(IEclipseContext context) {
                if (context.get(PrintService.SERVICE_NAME) == null) {
                    child.dispose();
                    done[0] = true;
                }
                return true;
            }
        });
        reg1.unregister();
    }

    @Test
    public void testServiceExample() {
        BundleContext bundleContext = CoreTestsActivator.getDefault().getBundleContext();
        ServiceRegistration reg = bundleContext.registerService(IPaletteService.class.getName(), (Object)new PaletteImpl(Color.BLUE), null);
        IEclipseContext context = EclipseContextFactory.getServiceContext((BundleContext)bundleContext);
        Crayon crayon = new Crayon();
        ContextInjectionFactory.inject((Object)crayon, (IEclipseContext)context);
        crayon.draw();
        reg.unregister();
        crayon.draw();
    }

    @Test
    public void testOptionalReferences() throws InterruptedException {
        BundleContext context = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
        IEclipseContext serviceContext = EclipseContextFactory.getServiceContext((BundleContext)context);
        TestBean bean = (TestBean)ContextInjectionFactory.make(TestBean.class, (IEclipseContext)serviceContext);
        org.junit.jupiter.api.Assertions.assertNull((Object)bean.testService);
        ServiceReference ref = context.getServiceReference(TestServiceController.class);
        TestServiceController controller = (TestServiceController)context.getService(ref);
        try {
            controller.enableTestServiceA();
            Thread.sleep(100L);
            org.junit.jupiter.api.Assertions.assertNotNull((Object)bean.testService);
            org.junit.jupiter.api.Assertions.assertSame(TestServiceA.class, bean.testService.getClass());
            org.junit.jupiter.api.Assertions.assertNotNull((Object)bean.testOtherService);
            org.junit.jupiter.api.Assertions.assertSame(TestServiceA.class, bean.testOtherService.getClass());
            controller.enableTestServiceB();
            Thread.sleep(100L);
            org.junit.jupiter.api.Assertions.assertNotNull((Object)bean.testService);
            org.junit.jupiter.api.Assertions.assertSame(TestServiceB.class, bean.testService.getClass());
            org.junit.jupiter.api.Assertions.assertNotNull((Object)bean.testOtherService);
            org.junit.jupiter.api.Assertions.assertSame(TestServiceB.class, bean.testOtherService.getClass());
            controller.disableTestServiceB();
            Thread.sleep(100L);
            org.junit.jupiter.api.Assertions.assertNotNull((Object)bean.testService);
            org.junit.jupiter.api.Assertions.assertSame(TestServiceA.class, bean.testService.getClass());
            org.junit.jupiter.api.Assertions.assertNotNull((Object)bean.testOtherService);
            org.junit.jupiter.api.Assertions.assertSame(TestServiceA.class, bean.testOtherService.getClass());
            controller.disableTestServiceA();
            Thread.sleep(100L);
            org.junit.jupiter.api.Assertions.assertNull((Object)bean.testService);
            org.junit.jupiter.api.Assertions.assertNull((Object)bean.testOtherService);
        }
        finally {
            controller.disableTestServiceA();
            controller.disableTestServiceB();
            Thread.sleep(100L);
        }
    }

    @Test
    public void testServiceRanking() throws InterruptedException {
        BundleContext context = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
        IEclipseContext serviceContext = EclipseContextFactory.getServiceContext((BundleContext)context);
        TestBean bean = (TestBean)ContextInjectionFactory.make(TestBean.class, (IEclipseContext)serviceContext);
        org.junit.jupiter.api.Assertions.assertNull((Object)bean.testService);
        ServiceReference ref = context.getServiceReference(TestServiceController.class);
        TestServiceController controller = (TestServiceController)context.getService(ref);
        try {
            controller.enableTestServiceB();
            Thread.sleep(100L);
            org.junit.jupiter.api.Assertions.assertNotNull((Object)bean.testService);
            org.junit.jupiter.api.Assertions.assertSame(TestServiceB.class, bean.testService.getClass());
            org.junit.jupiter.api.Assertions.assertNotNull((Object)bean.testOtherService);
            org.junit.jupiter.api.Assertions.assertSame(TestServiceB.class, bean.testOtherService.getClass());
            controller.enableTestServiceA();
            Thread.sleep(100L);
            org.junit.jupiter.api.Assertions.assertNotNull((Object)bean.testService);
            org.junit.jupiter.api.Assertions.assertSame(TestServiceB.class, bean.testService.getClass());
            org.junit.jupiter.api.Assertions.assertNotNull((Object)bean.testOtherService);
            org.junit.jupiter.api.Assertions.assertSame(TestServiceB.class, bean.testOtherService.getClass());
            controller.disableTestServiceB();
            Thread.sleep(100L);
            org.junit.jupiter.api.Assertions.assertNotNull((Object)bean.testService);
            org.junit.jupiter.api.Assertions.assertSame(TestServiceA.class, bean.testService.getClass());
            org.junit.jupiter.api.Assertions.assertNotNull((Object)bean.testOtherService);
            org.junit.jupiter.api.Assertions.assertSame(TestServiceA.class, bean.testOtherService.getClass());
            controller.disableTestServiceA();
            Thread.sleep(100L);
            org.junit.jupiter.api.Assertions.assertNull((Object)bean.testService);
            org.junit.jupiter.api.Assertions.assertNull((Object)bean.testOtherService);
        }
        finally {
            controller.disableTestServiceA();
            controller.disableTestServiceB();
            Thread.sleep(100L);
        }
    }

    static enum Color {
        RED,
        BLUE,
        YELLOW,
        GREEN,
        ORANGE,
        PURPLE;

    }

    static class Crayon {
        @Inject
        IPaletteService palette;
        String msg;

        Crayon() {
        }

        public void draw() {
            this.msg = this.palette == null ? "I'm out of ink!" : "My ink is  " + String.valueOf((Object)this.palette.getColor());
        }
    }

    static interface IPaletteService {
        public Color getColor();
    }

    static class PaletteImpl
    implements IPaletteService {
        private final Color color;

        PaletteImpl(Color color) {
            this.color = color;
        }

        @Override
        public Color getColor() {
            return this.color;
        }
    }

    static class Printer {
        @Inject
        @Optional
        PrintService printer;

        Printer() {
        }

        public void print(String message) {
            if (this.printer != null) {
                this.printer.print(message);
            }
        }
    }

    static class TestBean {
        @Inject
        @Optional
        TestService testService;
        @Inject
        @Optional
        TestOtherService testOtherService;

        TestBean() {
        }
    }
}

