/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.tests.di;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.EventTopic;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DisposeClassLinkTest {
    @Test
    public void testMake() throws Exception {
        IEclipseContext context = EclipseContextFactory.create();
        MyTest test = (MyTest)ContextInjectionFactory.make(MyTest.class, (IEclipseContext)context);
        Assertions.assertEquals((int)0, (int)test.getCount());
        context.dispose();
        Assertions.assertEquals((int)1, (int)test.getCount());
    }

    @Test
    public void testDisposeParent() throws Exception {
        IEclipseContext parentContext = EclipseContextFactory.create();
        IEclipseContext context = parentContext.createChild();
        MyTest test = (MyTest)ContextInjectionFactory.make(MyTest.class, (IEclipseContext)context);
        Assertions.assertEquals((int)0, (int)test.getCount());
        context.dispose();
        Assertions.assertEquals((int)1, (int)test.getCount());
        parentContext.dispose();
        Assertions.assertEquals((int)1, (int)test.getCount());
    }

    @Test
    public void testInject() throws Exception {
        IEclipseContext parentContext = EclipseContextFactory.create();
        IEclipseContext context = parentContext.createChild();
        MyTest test = new MyTest();
        ContextInjectionFactory.inject((Object)test, (IEclipseContext)context);
        Assertions.assertEquals((int)0, (int)test.getCount());
        context.dispose();
        Assertions.assertEquals((int)1, (int)test.getCount());
    }

    @Test
    public void testDisposeParentFirst() throws Exception {
        IEclipseContext parentContext = EclipseContextFactory.create();
        IEclipseContext context = parentContext.createChild();
        MyTest test = new MyTest();
        ContextInjectionFactory.inject((Object)test, (IEclipseContext)context);
        Assertions.assertEquals((int)0, (int)test.getCount());
        context.dispose();
        Assertions.assertEquals((int)1, (int)test.getCount());
        parentContext.dispose();
        Assertions.assertEquals((int)1, (int)test.getCount());
    }

    @Test
    public void testInjectedWithContext() throws Exception {
        IEclipseContext context = EclipseContextFactory.create();
        InjectionObject obj = (InjectionObject)ContextInjectionFactory.make(InjectionObject.class, (IEclipseContext)context);
        Assertions.assertEquals((Object)context, (Object)obj.context, (String)"The object has been injected with the context");
        Assertions.assertEquals((int)1, (int)obj.postConstruct, (String)"@PostConstruct should have been called once");
        Assertions.assertEquals((int)0, (int)obj.preDestroy, (String)"@PreDestroy should not have been called");
        context.dispose();
        Assertions.assertNotNull((Object)obj.context);
        Assertions.assertEquals((int)1, (int)obj.postConstruct, (String)"@PostConstruct should only have been called once");
        Assertions.assertEquals((int)1, (int)obj.preDestroy, (String)"@PreDestroy should have been called during uninjection");
    }

    @Test
    public void testBug430041() {
        IEclipseContext context = EclipseContextFactory.create();
        TestBug430041 obj = (TestBug430041)ContextInjectionFactory.make(TestBug430041.class, (IEclipseContext)context);
        context.dispose();
        Assertions.assertEquals((int)1, (int)obj.preDestroy);
    }

    public static class InjectionObject {
        @Inject
        IEclipseContext context;
        int postConstruct = 0;
        int preDestroy = 0;

        @PostConstruct
        void construct() {
            ++this.postConstruct;
        }

        @PreDestroy
        void destroy() {
            ++this.preDestroy;
        }
    }

    public static class MyTest {
        private int count = 0;

        public int getCount() {
            return this.count;
        }

        @PreDestroy
        void preDestroy() {
            ++this.count;
        }
    }

    public static class TestBug430041 {
        int preDestroy = 0;

        @Inject
        @Optional
        public void inject(@EventTopic(value="Bla") String bla) {
        }

        @PreDestroy
        void destroy() {
            ++this.preDestroy;
        }
    }
}

