/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.tests.di;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class InjectArraysTest {
    @Test
    public void testArrayInjection() {
        String[] arrayString = new String[]{"abc", "xyz", "ttt"};
        Integer[] arrayInteger = new Integer[]{5, 6, 7};
        int[] arrayInt = new int[]{1, 2, 3};
        char[] arrayChar = new char[]{'a', 'b', 'c'};
        IEclipseContext context = EclipseContextFactory.create();
        context.set("test_array_String", (Object)arrayString);
        context.set(Integer[].class, (Object)arrayInteger);
        context.set("test_array_int", (Object)arrayInt);
        context.set("test_array_char", (Object)arrayChar);
        TestClass testClass = (TestClass)ContextInjectionFactory.make(TestClass.class, (IEclipseContext)context);
        this.checkArraysEqual(arrayString, testClass.stringArray);
        this.checkArraysEqual(arrayInteger, testClass.integerArray);
        this.checkArraysEqual(arrayInt, testClass.intArray);
        this.checkArraysEqual(arrayChar, testClass.charAray);
    }

    private void checkArraysEqual(Object array1, Object array2) {
        Assertions.assertNotNull((Object)array2);
        Assertions.assertEquals((Object)array1, (Object)array2);
    }

    static class TestClass {
        @Inject
        @Named(value="test_array_String")
        public String[] stringArray;
        @Inject
        public Integer[] integerArray;
        public int[] intArray;
        public char[] charAray;

        TestClass() {
        }

        @Inject
        public void set(@Named(value="test_array_int") int[] intArray, @Named(value="test_array_char") char[] charAray) {
            this.intArray = intArray;
            this.charAray = charAray;
        }
    }
}

