/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.tests.di;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class InjectBaseTypeTest {
    @Test
    public void testPrimitiveTypes() {
        IEclipseContext context = EclipseContextFactory.create();
        context.set("test_int", (Object)12);
        context.set("test_long", (Object)124564523466L);
        context.set("test_float", (Object)Float.valueOf(12.34f));
        context.set("test_double", (Object)12.345345345634634);
        context.set("test_short", (Object)10);
        context.set("test_byte", (Object)55);
        context.set("test_boolean", (Object)true);
        context.set("test_char", (Object)Character.valueOf('a'));
        TestClass testClass = (TestClass)ContextInjectionFactory.make(TestClass.class, (IEclipseContext)context);
        Assertions.assertEquals((int)12, (int)testClass.intField);
        Assertions.assertEquals((int)0, (int)testClass.intFieldOptional);
        Assertions.assertEquals((long)124564523466L, (long)testClass.longField);
        Assertions.assertEquals((float)12.34f, (float)testClass.floatField, (float)0.0f);
        Assertions.assertEquals((double)12.345345345634634, (double)testClass.doubleField, (double)0.0);
        Assertions.assertEquals((short)10, (short)testClass.shortField);
        Assertions.assertEquals((byte)55, (byte)testClass.byteField);
        Assertions.assertEquals((Object)true, (Object)testClass.booleanField);
        Assertions.assertEquals((char)'a', (char)testClass.charField);
        Assertions.assertEquals((int)12, (int)testClass.intArg);
        Assertions.assertEquals((char)'a', (char)testClass.charArg);
        Assertions.assertEquals((Object)true, (Object)testClass.booleanArg);
        ContextInjectionFactory.uninject((Object)testClass, (IEclipseContext)context);
        Assertions.assertEquals((int)12, (int)testClass.intField);
        Assertions.assertEquals((int)0, (int)testClass.intFieldOptional);
        Assertions.assertEquals((long)124564523466L, (long)testClass.longField);
        Assertions.assertEquals((float)12.34f, (float)testClass.floatField, (float)0.0f);
        Assertions.assertEquals((double)12.345345345634634, (double)testClass.doubleField, (double)0.0);
        Assertions.assertEquals((short)10, (short)testClass.shortField);
        Assertions.assertEquals((byte)55, (byte)testClass.byteField);
        Assertions.assertEquals((Object)false, (Object)testClass.booleanField);
        Assertions.assertEquals((char)'a', (char)testClass.charField);
        Assertions.assertEquals((int)12, (int)testClass.intArg);
        Assertions.assertEquals((char)'a', (char)testClass.charArg);
        Assertions.assertEquals((Object)true, (Object)testClass.booleanArg);
    }

    static class TestClass {
        @Inject
        @Named(value="test_int")
        public int intField;
        @Inject
        @Named(value="test_int_optional")
        @Optional
        public int intFieldOptional;
        @Inject
        @Named(value="test_long")
        public long longField;
        @Inject
        @Named(value="test_float")
        public float floatField;
        @Inject
        @Named(value="test_double")
        public double doubleField;
        @Inject
        @Named(value="test_short")
        public short shortField;
        @Inject
        @Named(value="test_byte")
        public byte byteField;
        @Inject
        @Optional
        @Named(value="test_boolean")
        public boolean booleanField;
        @Inject
        @Named(value="test_char")
        public char charField;
        public int intArg;
        public char charArg;
        public boolean booleanArg;

        TestClass() {
        }

        @Inject
        public void set(@Named(value="test_int") int intArg, @Named(value="test_char") char charArg, @Named(value="test_boolean") boolean booleanArg) {
            this.intArg = intArg;
            this.charArg = charArg;
            this.booleanArg = booleanArg;
        }
    }
}

