/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.tests.di;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.InjectionException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class InjectionOrderTest {
    @Test
    public void testSpecialMethodOnFailure() {
        IEclipseContext appContext = EclipseContextFactory.create();
        boolean exception = false;
        try {
            ContextInjectionFactory.make(InjectUnsatisfied.class, (IEclipseContext)appContext);
        }
        catch (InjectionException e) {
            exception = true;
        }
        Assertions.assertTrue((boolean)exception);
        appContext.dispose();
        Assertions.assertEquals((int)0, (int)InjectUnsatisfied.count);
    }

    public static interface ITestObject {
    }

    public static class InjectUnsatisfied {
        @Inject
        ITestObject object;
        public static int count = 0;

        @PostConstruct
        public void postConstruct() {
            ++count;
            this.object.toString();
        }

        @PreDestroy
        public void preDestroy() {
            ++count;
            this.object.toString();
        }
    }
}

