/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.tests.di.extensions;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.extensions.Preference;
import org.eclipse.e4.core.internal.tests.CoreTestsActivator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.osgi.service.prefs.BackingStoreException;

public class InjectionMixedSuppliersTest {
    @Test
    public void testPreferencesQualifier() throws BackingStoreException, InvocationTargetException, InstantiationException {
        IEclipseContext context = EclipseContextFactory.create();
        this.setPreference("injectedPrefs", "abc");
        context.set("testMixed", (Object)"other");
        InjectTarget target = (InjectTarget)ContextInjectionFactory.make(InjectTarget.class, (IEclipseContext)context);
        Assertions.assertEquals((Object)"abc", (Object)target.pref);
        Assertions.assertEquals((Object)"other", (Object)target.other);
        this.setPreference("injectedPrefs", "xyz");
        context.set("testMixed", (Object)"bingo");
        Assertions.assertEquals((Object)"xyz", (Object)target.pref);
        Assertions.assertEquals((Object)"bingo", (Object)target.other);
    }

    private void setPreference(String key, String value) throws BackingStoreException {
        String nodePath = CoreTestsActivator.getDefault().getBundleContext().getBundle().getSymbolicName();
        IEclipsePreferences node = InstanceScope.INSTANCE.getNode(nodePath);
        node.put(key, value);
        node.flush();
    }

    static class InjectTarget {
        public String pref;
        public String other;

        InjectTarget() {
        }

        @Inject
        public void setPrefs(@Named(value="testMixed") String otherString, @Preference(value="injectedPrefs") String string) {
            this.pref = string;
            this.other = otherString;
        }
    }
}

