/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.tests.di.extensions;

import jakarta.inject.Inject;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.OSGiBundle;
import org.eclipse.e4.core.internal.tests.CoreTestsActivator;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

public class InjectionOSGiTest {
    private InjectionTarget target;
    private Bundle bundle;

    @AfterEach
    public void tearDown() throws Exception {
        this.bundle.start();
        BundleContext bundleContext = CoreTestsActivator.getDefault().getBundleContext();
        IEclipseContext localContext = EclipseContextFactory.getServiceContext((BundleContext)bundleContext);
        ContextInjectionFactory.uninject((Object)this.target, (IEclipseContext)localContext);
    }

    @BeforeEach
    public void setUp() throws Exception {
        BundleContext bundleContext = CoreTestsActivator.getDefault().getBundleContext();
        this.bundle = bundleContext.getBundle();
        IEclipseContext localContext = EclipseContextFactory.getServiceContext((BundleContext)bundleContext);
        this.target = (InjectionTarget)ContextInjectionFactory.make(InjectionTarget.class, (IEclipseContext)localContext);
    }

    @Test
    public void ensureJavaxIsNotAvailable() {
        Assumptions.assumeFalse((boolean)Boolean.parseBoolean(System.getenv().getOrDefault("ECLIPSE_I_BUILD_TEST", "false")));
        Assertions.assertThrows(ClassNotFoundException.class, () -> {
            Class<?> clazz = Class.forName("javax.inject.Inject");
        });
        Assertions.assertThrows(ClassNotFoundException.class, () -> {
            Class<?> clazz = Class.forName("javax.inject.Singleton");
        });
        Assertions.assertThrows(ClassNotFoundException.class, () -> {
            Class<?> clazz = Class.forName("javax.inject.Qualifier");
        });
        Assertions.assertThrows(ClassNotFoundException.class, () -> {
            Class<?> clazz = Class.forName("javax.inject.Provider");
        });
        Assertions.assertThrows(ClassNotFoundException.class, () -> {
            Class<?> clazz = Class.forName("javax.inject.Named");
        });
        Assertions.assertThrows(ClassNotFoundException.class, () -> {
            Class<?> clazz = Class.forName("javax.annotation.PreDestroy");
        });
        Assertions.assertThrows(ClassNotFoundException.class, () -> {
            Class<?> clazz = Class.forName("javax.annotation.PostConstruct");
        });
    }

    @Test
    public void testInject() {
        Assertions.assertTrue((boolean)this.target.hasContext());
    }

    @Test
    public void testUnInject() throws BundleException, InterruptedException {
        Assertions.assertTrue((boolean)this.target.hasContext());
        BundleContext firstContext = this.target.getContext();
        this.bundle.stop();
        Assertions.assertFalse((boolean)this.target.hasContext());
        this.bundle.start();
        Assertions.assertTrue((boolean)this.target.hasContext());
        BundleContext secondContext = this.target.getContext();
        Assertions.assertNotSame((Object)firstContext, (Object)secondContext);
    }

    @Test
    public void testBundleInject() throws BundleException {
        Assertions.assertNotNull((Object)this.target.getBundle());
        this.bundle.stop();
        Assertions.assertNotNull((Object)this.target.getBundle());
        Assertions.assertTrue((this.target.getBundle().getState() == 4 ? 1 : 0) != 0);
        Assertions.assertNotNull((Object)this.target.getBundle().getSymbolicName());
        Assertions.assertNull((Object)this.target.getContext());
    }

    static class InjectionBundleTarget
    extends InjectionTarget {
        InjectionBundleTarget() {
        }
    }

    static class InjectionTarget {
        private BundleContext ctx;
        private Bundle b;

        InjectionTarget() {
        }

        @Inject
        public void setBundleContext(@OSGiBundle @Optional BundleContext ctx) {
            this.ctx = ctx;
        }

        public boolean hasContext() {
            return this.ctx != null;
        }

        public BundleContext getContext() {
            return this.ctx;
        }

        @Inject
        public void setBundle(@OSGiBundle Bundle b) {
            this.b = b;
        }

        public Bundle getBundle() {
            return this.b;
        }

        @Inject
        public void setFoo(@OSGiBundle Object o) {
        }
    }
}

