/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.tests.di.extensions;

import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.Service;
import org.eclipse.e4.core.internal.tests.di.extensions.ComponentEnabler;
import org.eclipse.e4.core.internal.tests.di.extensions.DisabledServiceA;
import org.eclipse.e4.core.internal.tests.di.extensions.DisabledServiceB;
import org.eclipse.e4.core.internal.tests.di.extensions.FilterServiceA;
import org.eclipse.e4.core.internal.tests.di.extensions.FilterServiceB;
import org.eclipse.e4.core.internal.tests.di.extensions.SampleServiceA;
import org.eclipse.e4.core.internal.tests.di.extensions.SampleServiceB;
import org.eclipse.e4.core.internal.tests.di.extensions.TestService;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class ServiceSupplierTestCase {
    private final List<ServiceRegistration<?>> registrations = new ArrayList();

    @AfterEach
    public void cleanup() {
        this.registrations.forEach(ServiceRegistration::unregister);
    }

    @Test
    public void testInitialInject() {
        IEclipseContext serviceContext = EclipseContextFactory.getServiceContext((BundleContext)FrameworkUtil.getBundle(this.getClass()).getBundleContext());
        TestBean bean = (TestBean)ContextInjectionFactory.make(TestBean.class, (IEclipseContext)serviceContext);
        Assertions.assertNotNull((Object)bean.service);
        Assertions.assertNotNull(bean.serviceList);
        Assertions.assertSame(SampleServiceA.class, bean.service.getClass());
        Assertions.assertEquals((int)1, (int)bean.serviceInjectionCount);
        Assertions.assertEquals((int)4, (int)bean.serviceList.size());
        Assertions.assertEquals((int)1, (int)bean.serviceListInjectionCount);
        Assertions.assertSame(SampleServiceA.class, bean.serviceList.get(0).getClass());
        Assertions.assertSame(SampleServiceB.class, bean.serviceList.get(1).getClass());
    }

    @Test
    public void testStaticFilter() {
        IEclipseContext serviceContext = EclipseContextFactory.getServiceContext((BundleContext)FrameworkUtil.getBundle(this.getClass()).getBundleContext());
        TestStaticFilterBean bean = (TestStaticFilterBean)ContextInjectionFactory.make(TestStaticFilterBean.class, (IEclipseContext)serviceContext);
        Assertions.assertNotNull((Object)bean.service);
        Assertions.assertNotNull(bean.serviceList);
        Assertions.assertSame(FilterServiceA.class, bean.service.getClass());
        Assertions.assertEquals((int)1, (int)bean.serviceInjectionCount);
        Assertions.assertEquals((int)2, (int)bean.serviceList.size());
        Assertions.assertEquals((int)1, (int)bean.serviceListInjectionCount);
        Assertions.assertSame(FilterServiceA.class, bean.serviceList.get(0).getClass());
        Assertions.assertSame(FilterServiceB.class, bean.serviceList.get(1).getClass());
    }

    @Test
    @Timeout(value=30L)
    public void testDynamicAdd() {
        BundleContext context = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
        IEclipseContext serviceContext = EclipseContextFactory.getServiceContext((BundleContext)context);
        TestBean bean = (TestBean)ContextInjectionFactory.make(TestBean.class, (IEclipseContext)serviceContext);
        Assertions.assertEquals((int)1, (int)bean.serviceInjectionCount);
        Assertions.assertEquals((int)1, (int)bean.serviceListInjectionCount);
        TestService t = new TestService(){};
        Hashtable<String, Integer> properties = new Hashtable<String, Integer>();
        properties.put("service.ranking", 10000);
        bean.updated = false;
        bean.listUpdated = false;
        System.out.println("-------------------");
        this.registrations.add(context.registerService(TestService.class, (Object)t, properties));
        this.spinWait(() -> testBean.updated && testBean.listUpdated && testBean.service == t);
        System.out.println("-------------------");
        System.out.println("Final " + String.valueOf(bean.service));
        Assertions.assertSame((Object)t, (Object)bean.service);
        Assertions.assertEquals((int)2, (int)bean.serviceInjectionCount);
        Assertions.assertEquals((int)2, (int)bean.serviceListInjectionCount);
        Assertions.assertEquals((int)5, (int)bean.serviceList.size());
        Assertions.assertSame((Object)t, (Object)bean.serviceList.get(0));
        TestService t2 = new TestService(){};
        properties = new Hashtable();
        properties.put("service.ranking", -1);
        bean.updated = false;
        bean.listUpdated = false;
        this.registrations.add(context.registerService(TestService.class, (Object)t2, properties));
        this.spinWait(() -> testBean.updated && testBean.listUpdated);
        Assertions.assertSame((Object)t, (Object)bean.service);
        Assertions.assertEquals((int)3, (int)bean.serviceInjectionCount);
        Assertions.assertEquals((int)3, (int)bean.serviceListInjectionCount);
        Assertions.assertEquals((int)6, (int)bean.serviceList.size());
        Assertions.assertSame((Object)t, (Object)bean.serviceList.get(0));
    }

    private void spinWait(BooleanSupplier condition) {
        while (!condition.getAsBoolean() && !Thread.currentThread().isInterrupted()) {
            Thread.onSpinWait();
        }
    }

    @Test
    public void testDynamicAddRemove() {
        BundleContext context = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
        IEclipseContext serviceContext = EclipseContextFactory.getServiceContext((BundleContext)context);
        TestBean bean = (TestBean)ContextInjectionFactory.make(TestBean.class, (IEclipseContext)serviceContext);
        Assertions.assertEquals((int)1, (int)bean.serviceInjectionCount);
        Assertions.assertEquals((int)1, (int)bean.serviceListInjectionCount);
        TestService t = new TestService(){};
        Hashtable<String, Integer> properties = new Hashtable<String, Integer>();
        properties.put("service.ranking", 52);
        bean.updated = false;
        bean.listUpdated = false;
        this.registrations.add(context.registerService(TestService.class, (Object)t, properties));
        this.spinWait(() -> testBean.updated && testBean.listUpdated);
        Assertions.assertSame((Object)t, (Object)bean.service);
        Assertions.assertEquals((int)2, (int)bean.serviceInjectionCount);
        Assertions.assertEquals((int)2, (int)bean.serviceListInjectionCount);
        Assertions.assertEquals((int)5, (int)bean.serviceList.size());
        Assertions.assertSame((Object)t, (Object)bean.serviceList.get(0));
        bean.updated = false;
        bean.listUpdated = false;
        ServiceRegistration<?> registration = this.registrations.get(0);
        registration.unregister();
        this.registrations.remove(registration);
        this.spinWait(() -> testBean.updated && testBean.listUpdated);
        Assertions.assertEquals((int)3, (int)bean.serviceInjectionCount);
        Assertions.assertEquals((int)3, (int)bean.serviceListInjectionCount);
        Assertions.assertSame(SampleServiceA.class, bean.service.getClass());
        Assertions.assertEquals((int)4, (int)bean.serviceList.size());
        Assertions.assertSame(SampleServiceA.class, bean.serviceList.get(0).getClass());
        Assertions.assertSame(SampleServiceB.class, bean.serviceList.get(1).getClass());
    }

    @Test
    @Timeout(value=30L)
    public void testCleanup() {
        BundleContext context = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
        IEclipseContext eclipseContext = EclipseContextFactory.getServiceContext((BundleContext)context);
        IEclipseContext iec = eclipseContext.createChild();
        TestBean bean = (TestBean)ContextInjectionFactory.make(TestBean.class, (IEclipseContext)iec);
        TestBean bean2 = (TestBean)ContextInjectionFactory.make(TestBean.class, (IEclipseContext)eclipseContext);
        iec.dispose();
        TestService t = new TestService(){};
        Hashtable<String, Integer> properties = new Hashtable<String, Integer>();
        properties.put("service.ranking", 2);
        bean2.listUpdated = false;
        this.registrations.add(context.registerService(TestService.class, (Object)t, properties));
        this.spinWait(() -> testBean.listUpdated);
        Assertions.assertSame(SampleServiceA.class, bean.service.getClass());
    }

    @Test
    public void testOptionalReferences() throws Exception {
        BundleContext context = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
        IEclipseContext serviceContext = EclipseContextFactory.getServiceContext((BundleContext)context);
        TestDisabledBean bean = (TestDisabledBean)ContextInjectionFactory.make(TestDisabledBean.class, (IEclipseContext)serviceContext);
        Assertions.assertNull((Object)bean.disabledService);
        Assertions.assertEquals((int)0, (int)bean.services.size());
        ServiceReference ref = context.getServiceReference(ComponentEnabler.class);
        ComponentEnabler enabler = (ComponentEnabler)context.getService(ref);
        int timeoutInMillis = 1000;
        try {
            enabler.enableDisabledServiceA();
            this.waitForCondition(() -> testDisabledBean.services.size() == 1 && testDisabledBean.disabledService != null, 1000);
            Assertions.assertNotNull((Object)bean.disabledService);
            Assertions.assertEquals((int)1, (int)bean.services.size());
            Assertions.assertSame(DisabledServiceA.class, bean.disabledService.getClass());
            enabler.enableDisabledServiceB();
            this.waitForCondition(() -> testDisabledBean.services.size() == 2 && testDisabledBean.disabledService instanceof DisabledServiceB, 1000);
            Assertions.assertNotNull((Object)bean.disabledService);
            Assertions.assertEquals((int)2, (int)bean.services.size());
            Assertions.assertSame(DisabledServiceB.class, bean.disabledService.getClass());
            enabler.disableDisabledServiceB();
            this.waitForCondition(() -> testDisabledBean.services.size() == 1 && testDisabledBean.disabledService instanceof DisabledServiceA, 1000);
            Assertions.assertNotNull((Object)bean.disabledService);
            Assertions.assertEquals((int)1, (int)bean.services.size());
            Assertions.assertSame(DisabledServiceA.class, bean.disabledService.getClass());
            enabler.disableDisabledServiceA();
            this.waitForCondition(() -> testDisabledBean.services.size() == 0 && testDisabledBean.disabledService == null, 1000);
            Assertions.assertNull((Object)bean.disabledService);
            Assertions.assertEquals((int)0, (int)bean.services.size());
        }
        catch (Throwable throwable) {
            enabler.disableDisabledServiceA();
            enabler.disableDisabledServiceB();
            this.waitForCondition(() -> testDisabledBean.services.size() == 0 && testDisabledBean.disabledService == null, 1000);
            throw throwable;
        }
        enabler.disableDisabledServiceA();
        enabler.disableDisabledServiceB();
        this.waitForCondition(() -> testDisabledBean.services.size() == 0 && testDisabledBean.disabledService == null, 1000);
    }

    private void waitForCondition(Supplier<Boolean> condition, int timeoutInMillis) throws Exception {
        long startTimeInMillis = System.currentTimeMillis();
        while (!condition.get().booleanValue() && System.currentTimeMillis() - startTimeInMillis < (long)timeoutInMillis) {
            Thread.sleep(20L);
        }
    }

    @Test
    @Disabled(value="See Bug 572546")
    public void testUselessUpdates() throws InterruptedException {
        BundleContext context = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
        IEclipseContext serviceContext = EclipseContextFactory.getServiceContext((BundleContext)context);
        TestBean bean = (TestBean)ContextInjectionFactory.make(TestBean.class, (IEclipseContext)serviceContext);
        Assertions.assertEquals((int)1, (int)bean.serviceInjectionCount);
        Assertions.assertEquals((int)1, (int)bean.serviceListInjectionCount);
        TestService current = bean.service;
        TestService t = new TestService(){};
        Hashtable<String, Integer> properties = new Hashtable<String, Integer>();
        properties.put("service.ranking", -1);
        bean.updated = false;
        bean.listUpdated = false;
        this.registrations.add(context.registerService(TestService.class, (Object)t, properties));
        this.spinWait(() -> testBean.listUpdated);
        Thread.sleep(100L);
        Assertions.assertEquals((Object)current, (Object)bean.service);
        Assertions.assertEquals((int)1, (int)bean.serviceInjectionCount);
    }

    public static class TestBean {
        volatile TestService service;
        volatile List<TestService> serviceList;
        volatile int serviceInjectionCount;
        volatile int serviceListInjectionCount;
        volatile boolean updated;
        volatile boolean listUpdated;

        @Inject
        public void setService(@Service TestService service) {
            this.service = service;
            ++this.serviceInjectionCount;
            this.updated = true;
        }

        @Inject
        public void setServiceList(@Service List<TestService> serviceList) {
            this.serviceList = serviceList;
            ++this.serviceListInjectionCount;
            this.listUpdated = true;
        }
    }

    public static class TestDisabledBean {
        @Inject
        @Optional
        @Service(filterExpression="(component=disabled)")
        volatile TestService disabledService;
        @Inject
        @Service(filterExpression="(component=disabled)")
        volatile List<TestService> services;
    }

    public static class TestStaticFilterBean {
        TestService service;
        List<TestService> serviceList;
        int serviceInjectionCount;
        int serviceListInjectionCount;

        @Inject
        public void setService(@Service(filterExpression="(filtervalue=Test)") TestService service) {
            this.service = service;
            ++this.serviceInjectionCount;
        }

        @Inject
        public void setServiceList(@Service(filterExpression="(filtervalue=Test)") List<TestService> serviceList) {
            this.serviceList = serviceList;
            ++this.serviceListInjectionCount;
        }
    }
}

