/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.tests.manual;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.InjectionException;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class InjectionErrorReportingTest {
    @Test
    public void testMethodInjectionError() {
        IEclipseContext context = EclipseContextFactory.create();
        TestData methodValue = new TestData();
        context.set("testing", (Object)methodValue);
        InjectedMethod object = new InjectedMethod();
        Assertions.assertThrows(InjectionException.class, () -> ContextInjectionFactory.inject((Object)object, (IEclipseContext)context));
    }

    @Test
    public void testMethodInjectionNullError() {
        IEclipseContext context = EclipseContextFactory.create();
        TestData methodValue = new TestData();
        context.set("testing", (Object)methodValue);
        InjectedMethodNull object = new InjectedMethodNull();
        Assertions.assertThrows(InjectionException.class, () -> ContextInjectionFactory.inject((Object)object, (IEclipseContext)context));
    }

    @Test
    public void testConstructorInjectionError() {
        IEclipseContext context = EclipseContextFactory.create();
        TestData methodValue = new TestData();
        context.set("testing", (Object)methodValue);
        Assertions.assertThrows(InjectionException.class, () -> {
            Object object = ContextInjectionFactory.make(InjectedConstructor.class, (IEclipseContext)context);
        });
    }

    @Test
    public void testConstructorCastError() {
        IEclipseContext context = EclipseContextFactory.create();
        TestData methodValue = new TestData();
        context.set("testing", (Object)methodValue);
        Assertions.assertThrows(InjectionException.class, () -> {
            Object object = ContextInjectionFactory.make(InjectedConstructorCast.class, (IEclipseContext)context);
        });
    }

    @Test
    public void testFieldInjectionError() {
        IEclipseContext context = EclipseContextFactory.create();
        TestData methodValue = new TestData();
        context.set("testing", (Object)methodValue);
        InjectedField object = new InjectedField();
        Assertions.assertThrows(InjectionException.class, () -> ContextInjectionFactory.inject((Object)object, (IEclipseContext)context));
    }

    @Test
    public void testPostConstructError() {
        IEclipseContext context = EclipseContextFactory.create();
        TestData methodValue = new TestData();
        context.set("testing", (Object)methodValue);
        Assertions.assertThrows(InjectionException.class, () -> {
            Object object = ContextInjectionFactory.make(InjectedPostConstruct.class, (IEclipseContext)context);
        });
    }

    @Test
    public void testPreDestoryError() {
        IEclipseContext context = EclipseContextFactory.create();
        TestData methodValue = new TestData();
        context.set("testing", (Object)methodValue);
        Assertions.assertThrows(InjectionException.class, () -> {
            Object object = ContextInjectionFactory.make(InjectedPreDestroy.class, (IEclipseContext)context);
        });
        context.dispose();
    }

    @Test
    public void testRecursionError() {
        IEclipseContext context = EclipseContextFactory.create();
        ContextInjectionFactory.make(InjectedRecursive.class, (IEclipseContext)context);
        context.set(InjectedRecursive.class, (Object)new InjectedRecursive());
        Assertions.assertThrows(StackOverflowError.class, () -> {
            Object object = ContextInjectionFactory.make(InjectedRecursive.class, (IEclipseContext)context);
        });
    }

    static class InjectedConstructor {
        public int setMethodCalled = 0;
        public TestData value;

        @Inject
        public InjectedConstructor(@Named(value="testing123") TestData arg) {
            ++this.setMethodCalled;
            this.value = arg;
        }
    }

    static class InjectedConstructorCast {
        public int setMethodCalled = 0;
        public TestData value;
        public String nullString = "abc";

        @Inject
        public InjectedConstructorCast(@Named(value="testing") TestData arg) {
            ++this.setMethodCalled;
            this.value = arg;
            TestData otherObject = new TestData();
            this.nullString = (String)((Object)otherObject);
        }
    }

    static class InjectedField {
        @Inject
        @Named(value="testing123")
        public TestData data;

        InjectedField() {
        }
    }

    static class InjectedMethod {
        public int setMethodCalled = 0;
        public TestData value;

        InjectedMethod() {
        }

        @Inject
        public void injectedMethod(@Named(value="testing123") TestData arg) {
            ++this.setMethodCalled;
            this.value = arg;
        }
    }

    static class InjectedMethodNull {
        public int setMethodCalled = 0;
        public String nullString = null;

        InjectedMethodNull() {
        }

        @Inject
        public int injectedMethod(@Named(value="testing") TestData arg) {
            ++this.setMethodCalled;
            return this.nullString.length();
        }
    }

    static class InjectedPostConstruct {
        public int setMethodCalled = 0;
        public String nullString = null;
        public int length;

        InjectedPostConstruct() {
        }

        @PostConstruct
        public void myMethod() {
            ++this.setMethodCalled;
            this.length = this.nullString.length();
        }
    }

    static class InjectedPreDestroy {
        public int setMethodCalled = 0;
        public String nullString = null;
        public int length;

        InjectedPreDestroy() {
        }

        @Inject
        public void injectedMethod(@Named(value="testing") TestData arg) {
            ++this.setMethodCalled;
        }

        @PreDestroy
        public void myMethod() {
            ++this.setMethodCalled;
            this.length = this.nullString.length();
        }
    }

    @Creatable
    static class InjectedRecursive {
        @Inject
        public InjectedRecursive field;

        InjectedRecursive() {
        }
    }

    static class TestData {
        TestData() {
        }
    }
}

