/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.tests.nls;

import java.util.Locale;
import org.eclipse.e4.core.internal.services.ResourceBundleHelper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class LocaleTransformationTest {
    @Test
    public void testValidLanguageCountryVariant() {
        String localeString = "de_DE_EURO";
        Locale locale = ResourceBundleHelper.toLocale((String)localeString);
        Assertions.assertEquals((Object)"de", (Object)locale.getLanguage());
        Assertions.assertEquals((Object)"DE", (Object)locale.getCountry());
        Assertions.assertEquals((Object)"EURO", (Object)locale.getVariant());
    }

    @Test
    public void testValidLanguageCountry() {
        String localeString = "de_DE";
        Locale locale = ResourceBundleHelper.toLocale((String)localeString);
        Assertions.assertEquals((Object)"de", (Object)locale.getLanguage());
        Assertions.assertEquals((Object)"DE", (Object)locale.getCountry());
        Assertions.assertEquals((Object)"", (Object)locale.getVariant());
    }

    @Test
    public void testValidLanguage() {
        String localeString = "de";
        Locale locale = ResourceBundleHelper.toLocale((String)localeString);
        Assertions.assertEquals((Object)"de", (Object)locale.getLanguage());
        Assertions.assertEquals((Object)"", (Object)locale.getCountry());
        Assertions.assertEquals((Object)"", (Object)locale.getVariant());
    }

    @Test
    public void testValidCountry() {
        String localeString = "_DE";
        Locale locale = ResourceBundleHelper.toLocale((String)localeString);
        Assertions.assertEquals((Object)"", (Object)locale.getLanguage());
        Assertions.assertEquals((Object)"DE", (Object)locale.getCountry());
        Assertions.assertEquals((Object)"", (Object)locale.getVariant());
    }

    @Test
    public void testValidLanguageVariant() {
        String localeString = "de__EURO";
        Locale locale = ResourceBundleHelper.toLocale((String)localeString);
        Assertions.assertEquals((Object)"de", (Object)locale.getLanguage());
        Assertions.assertEquals((Object)"", (Object)locale.getCountry());
        Assertions.assertEquals((Object)"EURO", (Object)locale.getVariant());
    }

    @Test
    public void testValidVariant() {
        String localeString = "__EURO";
        Locale locale = ResourceBundleHelper.toLocale((String)localeString);
        Assertions.assertEquals((Object)"", (Object)locale.getLanguage());
        Assertions.assertEquals((Object)"", (Object)locale.getCountry());
        Assertions.assertEquals((Object)"EURO", (Object)locale.getVariant());
    }

    @Test
    public void testValidCountryVariant() {
        String localeString = "_DE_EURO";
        Locale locale = ResourceBundleHelper.toLocale((String)localeString);
        Assertions.assertEquals((Object)"", (Object)locale.getLanguage());
        Assertions.assertEquals((Object)"DE", (Object)locale.getCountry());
        Assertions.assertEquals((Object)"EURO", (Object)locale.getVariant());
    }

    @Test
    public void testInvalidLanguage() {
        Locale defaultLocale = Locale.getDefault();
        Locale.setDefault(Locale.ENGLISH);
        String localeString = "1234";
        Locale locale = ResourceBundleHelper.toLocale((String)localeString);
        Assertions.assertEquals((Object)"en", (Object)locale.getLanguage());
        Assertions.assertEquals((Object)"", (Object)locale.getCountry());
        Assertions.assertEquals((Object)"", (Object)locale.getVariant());
        Locale.setDefault(defaultLocale);
    }

    @Test
    public void testInvalidOneLetterLanguage() {
        Locale defaultLocale = Locale.getDefault();
        Locale.setDefault(Locale.ENGLISH);
        String localeString = "a";
        Locale locale = ResourceBundleHelper.toLocale((String)localeString);
        Assertions.assertEquals((Object)"en", (Object)locale.getLanguage());
        Assertions.assertEquals((Object)"", (Object)locale.getCountry());
        Assertions.assertEquals((Object)"", (Object)locale.getVariant());
        Locale.setDefault(defaultLocale);
    }

    @Test
    public void testThreeLetterValidLanguage() {
        String localeString = "kok";
        Locale locale = ResourceBundleHelper.toLocale((String)localeString);
        Assertions.assertEquals((Object)"kok", (Object)locale.getLanguage());
        Assertions.assertEquals((Object)"", (Object)locale.getCountry());
        Assertions.assertEquals((Object)"", (Object)locale.getVariant());
    }

    @Test
    public void testInvalidOneLetterCountry() {
        Locale defaultLocale = Locale.getDefault();
        Locale.setDefault(Locale.ENGLISH);
        String localeString = "_X";
        Locale locale = ResourceBundleHelper.toLocale((String)localeString);
        Assertions.assertEquals((Object)"en", (Object)locale.getLanguage());
        Assertions.assertEquals((Object)"", (Object)locale.getCountry());
        Assertions.assertEquals((Object)"", (Object)locale.getVariant());
        Locale.setDefault(defaultLocale);
    }

    @Test
    public void testInvalidThreeLetterCountry() {
        Locale defaultLocale = Locale.getDefault();
        Locale.setDefault(Locale.ENGLISH);
        String localeString = "_XXX";
        Locale locale = ResourceBundleHelper.toLocale((String)localeString);
        Assertions.assertEquals((Object)"en", (Object)locale.getLanguage());
        Assertions.assertEquals((Object)"", (Object)locale.getCountry());
        Assertions.assertEquals((Object)"", (Object)locale.getVariant());
        Locale.setDefault(defaultLocale);
    }

    @Test
    public void testValidNumericAreaCode() {
        Locale defaultLocale = Locale.getDefault();
        Locale.setDefault(Locale.ENGLISH);
        String localeString = "_029";
        Locale locale = ResourceBundleHelper.toLocale((String)localeString);
        Assertions.assertEquals((Object)"", (Object)locale.getLanguage());
        Assertions.assertEquals((Object)"029", (Object)locale.getCountry());
        Assertions.assertEquals((Object)"", (Object)locale.getVariant());
        Locale.setDefault(defaultLocale);
    }
}

