/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.tests.nls;

import jakarta.inject.Inject;
import java.util.Locale;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.internal.tests.nls.BundleMessages;
import org.eclipse.e4.core.internal.tests.nls.BundleMessagesRegistry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public class MessageRegistryTest {
    private IEclipseContext context;

    @BeforeEach
    public void setUp() {
        this.context = EclipseContextFactory.getServiceContext((BundleContext)FrameworkUtil.getBundle(this.getClass()).getBundleContext());
        ContextInjectionFactory.setDefault((IEclipseContext)this.context);
    }

    @Test
    public void testRegisterLocalizationByProperty() {
        this.context.set("org.eclipse.e4.core.locale", (Object)Locale.ENGLISH);
        TestObject o = (TestObject)ContextInjectionFactory.make(TestObject.class, (IEclipseContext)this.context);
        TestLocalizableObject control = new TestLocalizableObject();
        o.registry.registerProperty(control, "localizableValue", "message");
        Assertions.assertNotNull((Object)control.getLocalizableValue());
        Assertions.assertEquals((Object)"BundleMessage", (Object)control.getLocalizableValue());
    }

    @Test
    public void testRegisterLocalizationByMethod() {
        this.context.set("org.eclipse.e4.core.locale", (Object)Locale.ENGLISH);
        TestObject o = (TestObject)ContextInjectionFactory.make(TestObject.class, (IEclipseContext)this.context);
        TestLocalizableObject control = new TestLocalizableObject();
        o.registry.register(control, "setLocalizableValue", "message");
        Assertions.assertNotNull((Object)control.getLocalizableValue());
        Assertions.assertEquals((Object)"BundleMessage", (Object)control.getLocalizableValue());
    }

    @Test
    public void testRegisterLocalizationByMethodReference() {
        this.context.set("org.eclipse.e4.core.locale", (Object)Locale.ENGLISH);
        TestObject o = (TestObject)ContextInjectionFactory.make(TestObject.class, (IEclipseContext)this.context);
        TestLocalizableObject control = new TestLocalizableObject();
        o.registry.register(control::setLocalizableValue, m -> m.message);
        Assertions.assertNotNull((Object)control.getLocalizableValue());
        Assertions.assertEquals((Object)"BundleMessage", (Object)control.getLocalizableValue());
    }

    @Test
    public void testRegisterLocalizationByPropertyAndChangeLocale() {
        this.context.set("org.eclipse.e4.core.locale", (Object)Locale.ENGLISH);
        TestObject o = (TestObject)ContextInjectionFactory.make(TestObject.class, (IEclipseContext)this.context);
        TestLocalizableObject control = new TestLocalizableObject();
        o.registry.registerProperty(control, "localizableValue", "message");
        Assertions.assertNotNull((Object)control.getLocalizableValue());
        Assertions.assertEquals((Object)"BundleMessage", (Object)control.getLocalizableValue());
        this.context.set("org.eclipse.e4.core.locale", (Object)Locale.GERMAN);
        Assertions.assertEquals((Object)"BundleNachricht", (Object)control.getLocalizableValue());
    }

    @Test
    public void testRegisterLocalizationByMethodAndChangeLocale() {
        this.context.set("org.eclipse.e4.core.locale", (Object)Locale.ENGLISH);
        TestObject o = (TestObject)ContextInjectionFactory.make(TestObject.class, (IEclipseContext)this.context);
        TestLocalizableObject control = new TestLocalizableObject();
        o.registry.register(control, "setLocalizableValue", "message");
        Assertions.assertNotNull((Object)control.getLocalizableValue());
        Assertions.assertEquals((Object)"BundleMessage", (Object)control.getLocalizableValue());
        this.context.set("org.eclipse.e4.core.locale", (Object)Locale.GERMAN);
        Assertions.assertEquals((Object)"BundleNachricht", (Object)control.getLocalizableValue());
    }

    @Test
    public void testRegisterLocalizationByMethodReferenceAndChangeLocale() {
        this.context.set("org.eclipse.e4.core.locale", (Object)Locale.ENGLISH);
        TestObject o = (TestObject)ContextInjectionFactory.make(TestObject.class, (IEclipseContext)this.context);
        TestLocalizableObject control = new TestLocalizableObject();
        o.registry.register(control::setLocalizableValue, BundleMessages::getMessage);
        Assertions.assertNotNull((Object)control.getLocalizableValue());
        Assertions.assertEquals((Object)"BundleMessage", (Object)control.getLocalizableValue());
        this.context.set("org.eclipse.e4.core.locale", (Object)Locale.GERMAN);
        Assertions.assertEquals((Object)"BundleNachricht", (Object)control.getLocalizableValue());
    }

    static class TestLocalizableObject {
        private String localizableValue;

        TestLocalizableObject() {
        }

        public String getLocalizableValue() {
            return this.localizableValue;
        }

        public void setLocalizableValue(String localizableValue) {
            this.localizableValue = localizableValue;
        }
    }

    static class TestObject {
        @Inject
        BundleMessagesRegistry registry;

        TestObject() {
        }
    }
}

