/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.tests.nls;

import jakarta.inject.Inject;
import java.util.Locale;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.internal.tests.nls.BundleMessages;
import org.eclipse.e4.core.internal.tests.nls.Messages;
import org.eclipse.e4.core.internal.tests.nls.ResourceBundleClassMessages;
import org.eclipse.e4.core.internal.tests.nls.ResourcesMessages;
import org.eclipse.e4.core.internal.tests.nls.SimpleMessages;
import org.eclipse.e4.core.services.nls.Translation;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public class NLSTest {
    private IEclipseContext context;
    private Locale beforeLocale;

    @BeforeEach
    public void setUp() {
        this.context = EclipseContextFactory.getServiceContext((BundleContext)FrameworkUtil.getBundle(this.getClass()).getBundleContext());
        ContextInjectionFactory.setDefault((IEclipseContext)this.context);
        this.beforeLocale = Locale.getDefault();
        Locale.setDefault(new Locale("en"));
    }

    @AfterEach
    public void tearDown() {
        Locale.setDefault(this.beforeLocale);
    }

    @Test
    public void testSimpleMessages() {
        this.context.set("org.eclipse.e4.core.locale", (Object)Locale.ENGLISH);
        TestSimpleObject o = (TestSimpleObject)ContextInjectionFactory.make(TestSimpleObject.class, (IEclipseContext)this.context);
        SimpleMessages messages = o.simpleMessages;
        Assertions.assertNotNull((Object)messages);
        Assertions.assertNotNull((Object)messages.message);
        Assertions.assertNotNull((Object)messages.message_one);
        Assertions.assertNotNull((Object)messages.messageOne);
        Assertions.assertNotNull((Object)messages.message_two);
        Assertions.assertNotNull((Object)messages.messageThree);
        Assertions.assertNotNull((Object)messages.messageFour);
        Assertions.assertNotNull((Object)messages.messageFive_Sub);
        Assertions.assertNotNull((Object)messages.messageSix_Sub);
        Assertions.assertNotNull((Object)messages.messageSeven_Sub);
        Assertions.assertNotNull((Object)messages.messageEight_Sub);
        Assertions.assertNotNull((Object)messages.messageNine_Sub);
        Assertions.assertEquals((Object)"SimpleMessage", (Object)messages.message);
        Assertions.assertEquals((Object)"SimpleMessageUnderscore", (Object)messages.message_one);
        Assertions.assertEquals((Object)"SimpleMessageCamelCase", (Object)messages.messageOne);
        Assertions.assertEquals((Object)"SimpleMessageUnderscoreDot", (Object)messages.message_two);
        Assertions.assertEquals((Object)"SimpleMessageCamelCaseDot", (Object)messages.messageThree);
        Assertions.assertEquals((Object)"The idea is from Tom", (Object)messages.messageFour);
        Assertions.assertEquals((Object)"SimpleMessageCamelCaseAndUnderscoreOriginal", (Object)messages.messageFive_Sub);
        Assertions.assertEquals((Object)"SimpleMessageCamelCaseAndUnderscoreDeCamelCasified", (Object)messages.messageSix_Sub);
        Assertions.assertEquals((Object)"SimpleMessageCamelCaseAndUnderscoreDeCamelCasifiedAndDeUnderscorified", (Object)messages.messageSeven_Sub);
        Assertions.assertEquals((Object)"SimpleMessageCamelCaseAndUnderscoreDeUnderscorified", (Object)messages.messageEight_Sub);
        Assertions.assertEquals((Object)"SimpleMessageCamelCaseAndUnderscoreDeUnderscorifiedAndDeCamelCasified", (Object)messages.messageNine_Sub);
    }

    @Test
    public void testSimpleMessagesDifferentLocale() {
        this.context.set("org.eclipse.e4.core.locale", (Object)Locale.GERMAN);
        TestSimpleObject o = (TestSimpleObject)ContextInjectionFactory.make(TestSimpleObject.class, (IEclipseContext)this.context);
        SimpleMessages messages = o.simpleMessages;
        Assertions.assertNotNull((Object)messages);
        Assertions.assertNotNull((Object)messages.message);
        Assertions.assertNotNull((Object)messages.message_one);
        Assertions.assertNotNull((Object)messages.messageOne);
        Assertions.assertNotNull((Object)messages.message_two);
        Assertions.assertNotNull((Object)messages.messageThree);
        Assertions.assertNotNull((Object)messages.messageFour);
        Assertions.assertNotNull((Object)messages.messageFive_Sub);
        Assertions.assertNotNull((Object)messages.messageSix_Sub);
        Assertions.assertNotNull((Object)messages.messageSeven_Sub);
        Assertions.assertNotNull((Object)messages.messageEight_Sub);
        Assertions.assertNotNull((Object)messages.messageNine_Sub);
        Assertions.assertEquals((Object)"SimpleNachricht", (Object)messages.message);
        Assertions.assertEquals((Object)"SimpleNachrichtUnderscore", (Object)messages.message_one);
        Assertions.assertEquals((Object)"SimpleNachrichtCamelCase", (Object)messages.messageOne);
        Assertions.assertEquals((Object)"SimpleNachrichtUnderscoreDot", (Object)messages.message_two);
        Assertions.assertEquals((Object)"SimpleMessageCamelCaseDot", (Object)messages.messageThree);
        Assertions.assertEquals((Object)"Die Idee ist von Tom", (Object)messages.messageFour);
        Assertions.assertEquals((Object)"SimpleNachrichtCamelCaseAndUnderscoreOriginal", (Object)messages.messageFive_Sub);
        Assertions.assertEquals((Object)"SimpleNachrichtCamelCaseAndUnderscoreDeCamelCasified", (Object)messages.messageSix_Sub);
        Assertions.assertEquals((Object)"SimpleNachrichtCamelCaseAndUnderscoreDeCamelCasifiedAndDeUnderscorified", (Object)messages.messageSeven_Sub);
        Assertions.assertEquals((Object)"SimpleNachrichtCamelCaseAndUnderscoreDeUnderscorified", (Object)messages.messageEight_Sub);
        Assertions.assertEquals((Object)"SimpleNachrichtCamelCaseAndUnderscoreDeUnderscorifiedAndDeCamelCasified", (Object)messages.messageNine_Sub);
    }

    @Test
    public void testSimpleMessagesSkipDefaultLocaleForEquinoxRoot() {
        Locale.setDefault(new Locale("de"));
        this.context.set("org.eclipse.e4.core.locale", (Object)Locale.ENGLISH);
        TestSimpleObject o = (TestSimpleObject)ContextInjectionFactory.make(TestSimpleObject.class, (IEclipseContext)this.context);
        SimpleMessages messages = o.simpleMessages;
        Assertions.assertNotNull((Object)messages);
        Assertions.assertNotNull((Object)messages.message);
        Assertions.assertNotNull((Object)messages.message_one);
        Assertions.assertNotNull((Object)messages.messageOne);
        Assertions.assertNotNull((Object)messages.message_two);
        Assertions.assertNotNull((Object)messages.messageThree);
        Assertions.assertNotNull((Object)messages.messageFour);
        Assertions.assertNotNull((Object)messages.messageFive_Sub);
        Assertions.assertNotNull((Object)messages.messageSix_Sub);
        Assertions.assertNotNull((Object)messages.messageSeven_Sub);
        Assertions.assertNotNull((Object)messages.messageEight_Sub);
        Assertions.assertNotNull((Object)messages.messageNine_Sub);
        Assertions.assertEquals((Object)"SimpleMessage", (Object)messages.message);
        Assertions.assertEquals((Object)"SimpleMessageUnderscore", (Object)messages.message_one);
        Assertions.assertEquals((Object)"SimpleMessageCamelCase", (Object)messages.messageOne);
        Assertions.assertEquals((Object)"SimpleMessageUnderscoreDot", (Object)messages.message_two);
        Assertions.assertEquals((Object)"SimpleMessageCamelCaseDot", (Object)messages.messageThree);
        Assertions.assertEquals((Object)"The idea is from Tom", (Object)messages.messageFour);
        Assertions.assertEquals((Object)"SimpleMessageCamelCaseAndUnderscoreOriginal", (Object)messages.messageFive_Sub);
        Assertions.assertEquals((Object)"SimpleMessageCamelCaseAndUnderscoreDeCamelCasified", (Object)messages.messageSix_Sub);
        Assertions.assertEquals((Object)"SimpleMessageCamelCaseAndUnderscoreDeCamelCasifiedAndDeUnderscorified", (Object)messages.messageSeven_Sub);
        Assertions.assertEquals((Object)"SimpleMessageCamelCaseAndUnderscoreDeUnderscorified", (Object)messages.messageEight_Sub);
        Assertions.assertEquals((Object)"SimpleMessageCamelCaseAndUnderscoreDeUnderscorifiedAndDeCamelCasified", (Object)messages.messageNine_Sub);
    }

    @Test
    public void testSimpleMessagesUseDefaultLocaleForInvalidLocale() {
        Locale.setDefault(new Locale("de"));
        this.context.set("org.eclipse.e4.core.locale", (Object)Locale.FRENCH);
        TestSimpleObject o = (TestSimpleObject)ContextInjectionFactory.make(TestSimpleObject.class, (IEclipseContext)this.context);
        SimpleMessages messages = o.simpleMessages;
        Assertions.assertNotNull((Object)messages);
        Assertions.assertNotNull((Object)messages.message);
        Assertions.assertNotNull((Object)messages.message_one);
        Assertions.assertNotNull((Object)messages.messageOne);
        Assertions.assertNotNull((Object)messages.message_two);
        Assertions.assertNotNull((Object)messages.messageThree);
        Assertions.assertNotNull((Object)messages.messageFour);
        Assertions.assertNotNull((Object)messages.messageFive_Sub);
        Assertions.assertNotNull((Object)messages.messageSix_Sub);
        Assertions.assertNotNull((Object)messages.messageSeven_Sub);
        Assertions.assertNotNull((Object)messages.messageEight_Sub);
        Assertions.assertNotNull((Object)messages.messageNine_Sub);
        Assertions.assertEquals((Object)"SimpleNachricht", (Object)messages.message);
        Assertions.assertEquals((Object)"SimpleNachrichtUnderscore", (Object)messages.message_one);
        Assertions.assertEquals((Object)"SimpleNachrichtCamelCase", (Object)messages.messageOne);
        Assertions.assertEquals((Object)"SimpleNachrichtUnderscoreDot", (Object)messages.message_two);
        Assertions.assertEquals((Object)"SimpleMessageCamelCaseDot", (Object)messages.messageThree);
        Assertions.assertEquals((Object)"Die Idee ist von Tom", (Object)messages.messageFour);
        Assertions.assertEquals((Object)"SimpleNachrichtCamelCaseAndUnderscoreOriginal", (Object)messages.messageFive_Sub);
        Assertions.assertEquals((Object)"SimpleNachrichtCamelCaseAndUnderscoreDeCamelCasified", (Object)messages.messageSix_Sub);
        Assertions.assertEquals((Object)"SimpleNachrichtCamelCaseAndUnderscoreDeCamelCasifiedAndDeUnderscorified", (Object)messages.messageSeven_Sub);
        Assertions.assertEquals((Object)"SimpleNachrichtCamelCaseAndUnderscoreDeUnderscorified", (Object)messages.messageEight_Sub);
        Assertions.assertEquals((Object)"SimpleNachrichtCamelCaseAndUnderscoreDeUnderscorifiedAndDeCamelCasified", (Object)messages.messageNine_Sub);
    }

    @Test
    public void testMessages() {
        this.context.set("org.eclipse.e4.core.locale", (Object)Locale.ENGLISH);
        TestMessagesObject o = (TestMessagesObject)ContextInjectionFactory.make(TestMessagesObject.class, (IEclipseContext)this.context);
        Messages messages = o.Messages;
        Assertions.assertNotNull((Object)messages);
        Assertions.assertNotNull((Object)messages.message);
        Assertions.assertNotNull((Object)messages.message_one);
        Assertions.assertNotNull((Object)messages.messageOne);
        Assertions.assertNotNull((Object)messages.message_two);
        Assertions.assertNotNull((Object)messages.messageThree);
        Assertions.assertNotNull((Object)messages.messageFour);
        Assertions.assertNotNull((Object)messages.messageFive_Sub);
        Assertions.assertNotNull((Object)messages.messageSix_Sub);
        Assertions.assertNotNull((Object)messages.messageSeven_Sub);
        Assertions.assertNotNull((Object)messages.messageEight_Sub);
        Assertions.assertNotNull((Object)messages.messageNine_Sub);
        Assertions.assertEquals((Object)"Message", (Object)messages.message);
        Assertions.assertEquals((Object)"MessageUnderscore", (Object)messages.message_one);
        Assertions.assertEquals((Object)"MessageCamelCase", (Object)messages.messageOne);
        Assertions.assertEquals((Object)"MessageUnderscoreDot", (Object)messages.message_two);
        Assertions.assertEquals((Object)"MessageCamelCaseDot", (Object)messages.messageThree);
        Assertions.assertEquals((Object)"The idea is from Tom", (Object)messages.messageFour);
        Assertions.assertEquals((Object)"MessageCamelCaseAndUnderscoreOriginal", (Object)messages.messageFive_Sub);
        Assertions.assertEquals((Object)"MessageCamelCaseAndUnderscoreDeCamelCasified", (Object)messages.messageSix_Sub);
        Assertions.assertEquals((Object)"MessageCamelCaseAndUnderscoreDeCamelCasifiedAndDeUnderscorified", (Object)messages.messageSeven_Sub);
        Assertions.assertEquals((Object)"MessageCamelCaseAndUnderscoreDeUnderscorified", (Object)messages.messageEight_Sub);
        Assertions.assertEquals((Object)"MessageCamelCaseAndUnderscoreDeUnderscorifiedAndDeCamelCasified", (Object)messages.messageNine_Sub);
    }

    @Test
    public void testMessagesDifferentLocale() {
        this.context.set("org.eclipse.e4.core.locale", (Object)Locale.GERMAN);
        TestMessagesObject o = (TestMessagesObject)ContextInjectionFactory.make(TestMessagesObject.class, (IEclipseContext)this.context);
        Messages messages = o.Messages;
        Assertions.assertNotNull((Object)messages);
        Assertions.assertNotNull((Object)messages.message);
        Assertions.assertNotNull((Object)messages.message_one);
        Assertions.assertNotNull((Object)messages.messageOne);
        Assertions.assertNotNull((Object)messages.message_two);
        Assertions.assertNotNull((Object)messages.messageThree);
        Assertions.assertNotNull((Object)messages.messageFour);
        Assertions.assertNotNull((Object)messages.messageFive_Sub);
        Assertions.assertNotNull((Object)messages.messageSix_Sub);
        Assertions.assertNotNull((Object)messages.messageSeven_Sub);
        Assertions.assertNotNull((Object)messages.messageEight_Sub);
        Assertions.assertNotNull((Object)messages.messageNine_Sub);
        Assertions.assertEquals((Object)"Nachricht", (Object)messages.message);
        Assertions.assertEquals((Object)"NachrichtUnderscore", (Object)messages.message_one);
        Assertions.assertEquals((Object)"NachrichtCamelCase", (Object)messages.messageOne);
        Assertions.assertEquals((Object)"NachrichtUnderscoreDot", (Object)messages.message_two);
        Assertions.assertEquals((Object)"MessageCamelCaseDot", (Object)messages.messageThree);
        Assertions.assertEquals((Object)"Die Idee ist von Tom", (Object)messages.messageFour);
        Assertions.assertEquals((Object)"NachrichtCamelCaseAndUnderscoreOriginal", (Object)messages.messageFive_Sub);
        Assertions.assertEquals((Object)"NachrichtCamelCaseAndUnderscoreDeCamelCasified", (Object)messages.messageSix_Sub);
        Assertions.assertEquals((Object)"NachrichtCamelCaseAndUnderscoreDeCamelCasifiedAndDeUnderscorified", (Object)messages.messageSeven_Sub);
        Assertions.assertEquals((Object)"NachrichtCamelCaseAndUnderscoreDeUnderscorified", (Object)messages.messageEight_Sub);
        Assertions.assertEquals((Object)"NachrichtCamelCaseAndUnderscoreDeUnderscorifiedAndDeCamelCasified", (Object)messages.messageNine_Sub);
    }

    @Test
    public void testMessagesSkipDefaultLocaleForEquinoxRoot() {
        Locale.setDefault(new Locale("de"));
        this.context.set("org.eclipse.e4.core.locale", (Object)Locale.ENGLISH);
        TestMessagesObject o = (TestMessagesObject)ContextInjectionFactory.make(TestMessagesObject.class, (IEclipseContext)this.context);
        Messages messages = o.Messages;
        Assertions.assertNotNull((Object)messages);
        Assertions.assertNotNull((Object)messages.message);
        Assertions.assertNotNull((Object)messages.message_one);
        Assertions.assertNotNull((Object)messages.messageOne);
        Assertions.assertNotNull((Object)messages.message_two);
        Assertions.assertNotNull((Object)messages.messageThree);
        Assertions.assertNotNull((Object)messages.messageFour);
        Assertions.assertNotNull((Object)messages.messageFive_Sub);
        Assertions.assertNotNull((Object)messages.messageSix_Sub);
        Assertions.assertNotNull((Object)messages.messageSeven_Sub);
        Assertions.assertNotNull((Object)messages.messageEight_Sub);
        Assertions.assertNotNull((Object)messages.messageNine_Sub);
        Assertions.assertEquals((Object)"Message", (Object)messages.message);
        Assertions.assertEquals((Object)"MessageUnderscore", (Object)messages.message_one);
        Assertions.assertEquals((Object)"MessageCamelCase", (Object)messages.messageOne);
        Assertions.assertEquals((Object)"MessageUnderscoreDot", (Object)messages.message_two);
        Assertions.assertEquals((Object)"MessageCamelCaseDot", (Object)messages.messageThree);
        Assertions.assertEquals((Object)"The idea is from Tom", (Object)messages.messageFour);
        Assertions.assertEquals((Object)"MessageCamelCaseAndUnderscoreOriginal", (Object)messages.messageFive_Sub);
        Assertions.assertEquals((Object)"MessageCamelCaseAndUnderscoreDeCamelCasified", (Object)messages.messageSix_Sub);
        Assertions.assertEquals((Object)"MessageCamelCaseAndUnderscoreDeCamelCasifiedAndDeUnderscorified", (Object)messages.messageSeven_Sub);
        Assertions.assertEquals((Object)"MessageCamelCaseAndUnderscoreDeUnderscorified", (Object)messages.messageEight_Sub);
        Assertions.assertEquals((Object)"MessageCamelCaseAndUnderscoreDeUnderscorifiedAndDeCamelCasified", (Object)messages.messageNine_Sub);
    }

    @Test
    public void testSimpleMessagesRegionCode() {
        Locale locale = new Locale("de", "CH");
        this.context.set("org.eclipse.e4.core.locale", (Object)locale);
        TestSimpleObject o = (TestSimpleObject)ContextInjectionFactory.make(TestSimpleObject.class, (IEclipseContext)this.context);
        SimpleMessages messages = o.simpleMessages;
        Assertions.assertNotNull((Object)messages);
        Assertions.assertNotNull((Object)messages.message);
        Assertions.assertNotNull((Object)messages.messageOne);
        Assertions.assertEquals((Object)"Region", (Object)messages.message);
        Assertions.assertEquals((Object)"RegionOne", (Object)messages.messageOne);
    }

    @Test
    public void testSimpleMessagesRegionAndVariantCode() {
        Locale locale = new Locale("de", "CH", "TEST");
        this.context.set("org.eclipse.e4.core.locale", (Object)locale);
        TestSimpleObject o = (TestSimpleObject)ContextInjectionFactory.make(TestSimpleObject.class, (IEclipseContext)this.context);
        SimpleMessages messages = o.simpleMessages;
        Assertions.assertNotNull((Object)messages);
        Assertions.assertNotNull((Object)messages.message);
        Assertions.assertNotNull((Object)messages.messageOne);
        Assertions.assertEquals((Object)"RegionWithTestVariant", (Object)messages.message);
        Assertions.assertEquals((Object)"RegionWithTestVariantOne", (Object)messages.messageOne);
        locale = new Locale("de", "CH", "OTHER");
        this.context.set("org.eclipse.e4.core.locale", (Object)locale);
        TestSimpleObject otherO = (TestSimpleObject)ContextInjectionFactory.make(TestSimpleObject.class, (IEclipseContext)this.context);
        SimpleMessages otherMessages = otherO.simpleMessages;
        Assertions.assertEquals((Object)"RegionWithOtherVariant", (Object)otherMessages.message);
        Assertions.assertEquals((Object)"RegionWithOtherVariantOne", (Object)otherMessages.messageOne);
    }

    @Test
    public void testMessagesUseDefaultLocaleForInvalidLocale() {
        Locale.setDefault(new Locale("de"));
        this.context.set("org.eclipse.e4.core.locale", (Object)Locale.FRENCH);
        TestMessagesObject o = (TestMessagesObject)ContextInjectionFactory.make(TestMessagesObject.class, (IEclipseContext)this.context);
        Messages messages = o.Messages;
        Assertions.assertNotNull((Object)messages);
        Assertions.assertNotNull((Object)messages.message);
        Assertions.assertNotNull((Object)messages.message_one);
        Assertions.assertNotNull((Object)messages.messageOne);
        Assertions.assertNotNull((Object)messages.message_two);
        Assertions.assertNotNull((Object)messages.messageThree);
        Assertions.assertNotNull((Object)messages.messageFour);
        Assertions.assertNotNull((Object)messages.messageFive_Sub);
        Assertions.assertNotNull((Object)messages.messageSix_Sub);
        Assertions.assertNotNull((Object)messages.messageSeven_Sub);
        Assertions.assertNotNull((Object)messages.messageEight_Sub);
        Assertions.assertNotNull((Object)messages.messageNine_Sub);
        Assertions.assertEquals((Object)"Nachricht", (Object)messages.message);
        Assertions.assertEquals((Object)"NachrichtUnderscore", (Object)messages.message_one);
        Assertions.assertEquals((Object)"NachrichtCamelCase", (Object)messages.messageOne);
        Assertions.assertEquals((Object)"NachrichtUnderscoreDot", (Object)messages.message_two);
        Assertions.assertEquals((Object)"MessageCamelCaseDot", (Object)messages.messageThree);
        Assertions.assertEquals((Object)"Die Idee ist von Tom", (Object)messages.messageFour);
        Assertions.assertEquals((Object)"NachrichtCamelCaseAndUnderscoreOriginal", (Object)messages.messageFive_Sub);
        Assertions.assertEquals((Object)"NachrichtCamelCaseAndUnderscoreDeCamelCasified", (Object)messages.messageSix_Sub);
        Assertions.assertEquals((Object)"NachrichtCamelCaseAndUnderscoreDeCamelCasifiedAndDeUnderscorified", (Object)messages.messageSeven_Sub);
        Assertions.assertEquals((Object)"NachrichtCamelCaseAndUnderscoreDeUnderscorified", (Object)messages.messageEight_Sub);
        Assertions.assertEquals((Object)"NachrichtCamelCaseAndUnderscoreDeUnderscorifiedAndDeCamelCasified", (Object)messages.messageNine_Sub);
    }

    @Test
    public void testBundleMessages() {
        this.context.set("org.eclipse.e4.core.locale", (Object)Locale.ENGLISH);
        TestBundleObject o = (TestBundleObject)ContextInjectionFactory.make(TestBundleObject.class, (IEclipseContext)this.context);
        BundleMessages messages = o.bundleMessages;
        Assertions.assertNotNull((Object)messages);
        Assertions.assertNotNull((Object)messages.message);
        Assertions.assertNotNull((Object)messages.message_one);
        Assertions.assertNotNull((Object)messages.messageOne);
        Assertions.assertNotNull((Object)messages.message_two);
        Assertions.assertNotNull((Object)messages.messageThree);
        Assertions.assertNotNull((Object)messages.messageFour);
        Assertions.assertNotNull((Object)messages.messageFive_Sub);
        Assertions.assertNotNull((Object)messages.messageSix_Sub);
        Assertions.assertNotNull((Object)messages.messageSeven_Sub);
        Assertions.assertNotNull((Object)messages.messageEight_Sub);
        Assertions.assertNotNull((Object)messages.messageNine_Sub);
        Assertions.assertEquals((Object)"BundleMessage", (Object)messages.message);
        Assertions.assertEquals((Object)"BundleMessageUnderscore", (Object)messages.message_one);
        Assertions.assertEquals((Object)"BundleMessageCamelCase", (Object)messages.messageOne);
        Assertions.assertEquals((Object)"BundleMessageUnderscoreDot", (Object)messages.message_two);
        Assertions.assertEquals((Object)"BundleMessageCamelCaseDot", (Object)messages.messageThree);
        Assertions.assertEquals((Object)"The idea is from Tom", (Object)messages.messageFour);
        Assertions.assertEquals((Object)"BundleMessageCamelCaseAndUnderscoreOriginal", (Object)messages.messageFive_Sub);
        Assertions.assertEquals((Object)"BundleMessageCamelCaseAndUnderscoreDeCamelCasified", (Object)messages.messageSix_Sub);
        Assertions.assertEquals((Object)"BundleMessageCamelCaseAndUnderscoreDeCamelCasifiedAndDeUnderscorified", (Object)messages.messageSeven_Sub);
        Assertions.assertEquals((Object)"BundleMessageCamelCaseAndUnderscoreDeUnderscorified", (Object)messages.messageEight_Sub);
        Assertions.assertEquals((Object)"BundleMessageCamelCaseAndUnderscoreDeUnderscorifiedAndDeCamelCasified", (Object)messages.messageNine_Sub);
    }

    @Test
    public void testBundleMessagesDifferentLocale() {
        this.context.set("org.eclipse.e4.core.locale", (Object)Locale.GERMAN);
        TestBundleObject o = (TestBundleObject)ContextInjectionFactory.make(TestBundleObject.class, (IEclipseContext)this.context);
        BundleMessages messages = o.bundleMessages;
        Assertions.assertNotNull((Object)messages);
        Assertions.assertNotNull((Object)messages.message);
        Assertions.assertNotNull((Object)messages.message_one);
        Assertions.assertNotNull((Object)messages.messageOne);
        Assertions.assertNotNull((Object)messages.message_two);
        Assertions.assertNotNull((Object)messages.messageThree);
        Assertions.assertNotNull((Object)messages.messageFour);
        Assertions.assertNotNull((Object)messages.messageFive_Sub);
        Assertions.assertNotNull((Object)messages.messageSix_Sub);
        Assertions.assertNotNull((Object)messages.messageSeven_Sub);
        Assertions.assertNotNull((Object)messages.messageEight_Sub);
        Assertions.assertNotNull((Object)messages.messageNine_Sub);
        Assertions.assertEquals((Object)"BundleNachricht", (Object)messages.message);
        Assertions.assertEquals((Object)"BundleNachrichtUnderscore", (Object)messages.message_one);
        Assertions.assertEquals((Object)"BundleNachrichtCamelCase", (Object)messages.messageOne);
        Assertions.assertEquals((Object)"BundleNachrichtUnderscoreDot", (Object)messages.message_two);
        Assertions.assertEquals((Object)"BundleMessageCamelCaseDot", (Object)messages.messageThree);
        Assertions.assertEquals((Object)"Die Idee ist von Tom", (Object)messages.messageFour);
        Assertions.assertEquals((Object)"BundleNachrichtCamelCaseAndUnderscoreOriginal", (Object)messages.messageFive_Sub);
        Assertions.assertEquals((Object)"BundleNachrichtCamelCaseAndUnderscoreDeCamelCasified", (Object)messages.messageSix_Sub);
        Assertions.assertEquals((Object)"BundleNachrichtCamelCaseAndUnderscoreDeCamelCasifiedAndDeUnderscorified", (Object)messages.messageSeven_Sub);
        Assertions.assertEquals((Object)"BundleNachrichtCamelCaseAndUnderscoreDeUnderscorified", (Object)messages.messageEight_Sub);
        Assertions.assertEquals((Object)"BundleNachrichtCamelCaseAndUnderscoreDeUnderscorifiedAndDeCamelCasified", (Object)messages.messageNine_Sub);
    }

    @Test
    public void testBundleMessagesSkipDefaultLocaleForEquinoxRoot() {
        Locale.setDefault(new Locale("de"));
        this.context.set("org.eclipse.e4.core.locale", (Object)Locale.ENGLISH);
        TestBundleObject o = (TestBundleObject)ContextInjectionFactory.make(TestBundleObject.class, (IEclipseContext)this.context);
        BundleMessages messages = o.bundleMessages;
        Assertions.assertNotNull((Object)messages);
        Assertions.assertNotNull((Object)messages.message);
        Assertions.assertNotNull((Object)messages.message_one);
        Assertions.assertNotNull((Object)messages.messageOne);
        Assertions.assertNotNull((Object)messages.message_two);
        Assertions.assertNotNull((Object)messages.messageThree);
        Assertions.assertNotNull((Object)messages.messageFour);
        Assertions.assertNotNull((Object)messages.messageFive_Sub);
        Assertions.assertNotNull((Object)messages.messageSix_Sub);
        Assertions.assertNotNull((Object)messages.messageSeven_Sub);
        Assertions.assertNotNull((Object)messages.messageEight_Sub);
        Assertions.assertNotNull((Object)messages.messageNine_Sub);
        Assertions.assertEquals((Object)"BundleMessage", (Object)messages.message);
        Assertions.assertEquals((Object)"BundleMessageUnderscore", (Object)messages.message_one);
        Assertions.assertEquals((Object)"BundleMessageCamelCase", (Object)messages.messageOne);
        Assertions.assertEquals((Object)"BundleMessageUnderscoreDot", (Object)messages.message_two);
        Assertions.assertEquals((Object)"BundleMessageCamelCaseDot", (Object)messages.messageThree);
        Assertions.assertEquals((Object)"The idea is from Tom", (Object)messages.messageFour);
        Assertions.assertEquals((Object)"BundleMessageCamelCaseAndUnderscoreOriginal", (Object)messages.messageFive_Sub);
        Assertions.assertEquals((Object)"BundleMessageCamelCaseAndUnderscoreDeCamelCasified", (Object)messages.messageSix_Sub);
        Assertions.assertEquals((Object)"BundleMessageCamelCaseAndUnderscoreDeCamelCasifiedAndDeUnderscorified", (Object)messages.messageSeven_Sub);
        Assertions.assertEquals((Object)"BundleMessageCamelCaseAndUnderscoreDeUnderscorified", (Object)messages.messageEight_Sub);
        Assertions.assertEquals((Object)"BundleMessageCamelCaseAndUnderscoreDeUnderscorifiedAndDeCamelCasified", (Object)messages.messageNine_Sub);
    }

    @Test
    public void testBundleMessagesUseDefaultLocaleForInvalidLocale() {
        Locale.setDefault(new Locale("de"));
        this.context.set("org.eclipse.e4.core.locale", (Object)Locale.FRENCH);
        TestBundleObject o = (TestBundleObject)ContextInjectionFactory.make(TestBundleObject.class, (IEclipseContext)this.context);
        BundleMessages messages = o.bundleMessages;
        Assertions.assertNotNull((Object)messages);
        Assertions.assertNotNull((Object)messages.message);
        Assertions.assertNotNull((Object)messages.message_one);
        Assertions.assertNotNull((Object)messages.messageOne);
        Assertions.assertNotNull((Object)messages.message_two);
        Assertions.assertNotNull((Object)messages.messageThree);
        Assertions.assertNotNull((Object)messages.messageFour);
        Assertions.assertNotNull((Object)messages.messageFive_Sub);
        Assertions.assertNotNull((Object)messages.messageSix_Sub);
        Assertions.assertNotNull((Object)messages.messageSeven_Sub);
        Assertions.assertNotNull((Object)messages.messageEight_Sub);
        Assertions.assertNotNull((Object)messages.messageNine_Sub);
        Assertions.assertEquals((Object)"BundleNachricht", (Object)messages.message);
        Assertions.assertEquals((Object)"BundleNachrichtUnderscore", (Object)messages.message_one);
        Assertions.assertEquals((Object)"BundleNachrichtCamelCase", (Object)messages.messageOne);
        Assertions.assertEquals((Object)"BundleNachrichtUnderscoreDot", (Object)messages.message_two);
        Assertions.assertEquals((Object)"BundleMessageCamelCaseDot", (Object)messages.messageThree);
        Assertions.assertEquals((Object)"Die Idee ist von Tom", (Object)messages.messageFour);
        Assertions.assertEquals((Object)"BundleNachrichtCamelCaseAndUnderscoreOriginal", (Object)messages.messageFive_Sub);
        Assertions.assertEquals((Object)"BundleNachrichtCamelCaseAndUnderscoreDeCamelCasified", (Object)messages.messageSix_Sub);
        Assertions.assertEquals((Object)"BundleNachrichtCamelCaseAndUnderscoreDeCamelCasifiedAndDeUnderscorified", (Object)messages.messageSeven_Sub);
        Assertions.assertEquals((Object)"BundleNachrichtCamelCaseAndUnderscoreDeUnderscorified", (Object)messages.messageEight_Sub);
        Assertions.assertEquals((Object)"BundleNachrichtCamelCaseAndUnderscoreDeUnderscorifiedAndDeCamelCasified", (Object)messages.messageNine_Sub);
    }

    @Test
    public void testClassBasedResourceBundle() {
        this.context.set("org.eclipse.e4.core.locale", (Object)Locale.ENGLISH);
        TestResourceBundleClassObject o = (TestResourceBundleClassObject)ContextInjectionFactory.make(TestResourceBundleClassObject.class, (IEclipseContext)this.context);
        ResourceBundleClassMessages messages = o.bundleClassMessages;
        Assertions.assertNotNull((Object)messages);
        Assertions.assertNotNull((Object)messages.message);
        Assertions.assertNotNull((Object)messages.message_one);
        Assertions.assertNotNull((Object)messages.messageOne);
        Assertions.assertNotNull((Object)messages.message_two);
        Assertions.assertNotNull((Object)messages.messageThree);
        Assertions.assertNotNull((Object)messages.messageFour);
        Assertions.assertNotNull((Object)messages.messageFive_Sub);
        Assertions.assertNotNull((Object)messages.messageSix_Sub);
        Assertions.assertNotNull((Object)messages.messageSeven_Sub);
        Assertions.assertNotNull((Object)messages.messageEight_Sub);
        Assertions.assertNotNull((Object)messages.messageNine_Sub);
        Assertions.assertEquals((Object)"ResourceBundleClassMessage", (Object)messages.message);
        Assertions.assertEquals((Object)"ResourceBundleClassMessageUnderscore", (Object)messages.message_one);
        Assertions.assertEquals((Object)"ResourceBundleClassMessageCamelCase", (Object)messages.messageOne);
        Assertions.assertEquals((Object)"ResourceBundleClassMessageUnderscoreDot", (Object)messages.message_two);
        Assertions.assertEquals((Object)"ResourceBundleClassCamelCaseDot", (Object)messages.messageThree);
        Assertions.assertEquals((Object)"The idea is from Tom", (Object)messages.messageFour);
        Assertions.assertEquals((Object)"ResourceBundleClassMessageCamelCaseAndUnderscoreOriginal", (Object)messages.messageFive_Sub);
        Assertions.assertEquals((Object)"ResourceBundleClassMessageCamelCaseAndUnderscoreDeCamelCasified", (Object)messages.messageSix_Sub);
        Assertions.assertEquals((Object)"ResourceBundleClassMessageCamelCaseAndUnderscoreDeCamelCasifiedAndDeUnderscorified", (Object)messages.messageSeven_Sub);
        Assertions.assertEquals((Object)"ResourceBundleClassMessageCamelCaseAndUnderscoreDeUnderscorified", (Object)messages.messageEight_Sub);
        Assertions.assertEquals((Object)"ResourceBundleClassMessageCamelCaseAndUnderscoreDeUnderscorifiedAndDeCamelCasified", (Object)messages.messageNine_Sub);
    }

    @Test
    public void testClassBasedResourceBundleDifferentLocale() {
        this.context.set("org.eclipse.e4.core.locale", (Object)Locale.GERMAN);
        TestResourceBundleClassObject o = (TestResourceBundleClassObject)ContextInjectionFactory.make(TestResourceBundleClassObject.class, (IEclipseContext)this.context);
        ResourceBundleClassMessages messages = o.bundleClassMessages;
        Assertions.assertNotNull((Object)messages);
        Assertions.assertNotNull((Object)messages.message);
        Assertions.assertNotNull((Object)messages.message_one);
        Assertions.assertNotNull((Object)messages.messageOne);
        Assertions.assertNotNull((Object)messages.message_two);
        Assertions.assertNotNull((Object)messages.messageThree);
        Assertions.assertNotNull((Object)messages.messageFour);
        Assertions.assertNotNull((Object)messages.messageFive_Sub);
        Assertions.assertNotNull((Object)messages.messageSix_Sub);
        Assertions.assertNotNull((Object)messages.messageSeven_Sub);
        Assertions.assertNotNull((Object)messages.messageEight_Sub);
        Assertions.assertNotNull((Object)messages.messageNine_Sub);
        Assertions.assertEquals((Object)"ResourceBundleClassNachricht", (Object)messages.message);
        Assertions.assertEquals((Object)"ResourceBundleClassNachrichtUnderscore", (Object)messages.message_one);
        Assertions.assertEquals((Object)"ResourceBundleClassNachrichtCamelCase", (Object)messages.messageOne);
        Assertions.assertEquals((Object)"ResourceBundleNachrichtMessageUnderscoreDot", (Object)messages.message_two);
        Assertions.assertEquals((Object)"ResourceBundleClassCamelCaseDot", (Object)messages.messageThree);
        Assertions.assertEquals((Object)"Die Idee ist von Tom", (Object)messages.messageFour);
        Assertions.assertEquals((Object)"ResourceBundleClassNachrichtCamelCaseAndUnderscoreOriginal", (Object)messages.messageFive_Sub);
        Assertions.assertEquals((Object)"ResourceBundleClassNachrichtCamelCaseAndUnderscoreDeCamelCasified", (Object)messages.messageSix_Sub);
        Assertions.assertEquals((Object)"ResourceBundleClassNachrichtCamelCaseAndUnderscoreDeCamelCasifiedAndDeUnderscorified", (Object)messages.messageSeven_Sub);
        Assertions.assertEquals((Object)"ResourceBundleClassNachrichtCamelCaseAndUnderscoreDeUnderscorified", (Object)messages.messageEight_Sub);
        Assertions.assertEquals((Object)"ResourceBundleClassNachrichtCamelCaseAndUnderscoreDeUnderscorifiedAndDeCamelCasified", (Object)messages.messageNine_Sub);
    }

    @Test
    public void testClassBasedResourceBundleSkipDefaultLocaleForEquinoxRoot() {
        Locale.setDefault(new Locale("de"));
        this.context.set("org.eclipse.e4.core.locale", (Object)Locale.ENGLISH);
        TestResourceBundleClassObject o = (TestResourceBundleClassObject)ContextInjectionFactory.make(TestResourceBundleClassObject.class, (IEclipseContext)this.context);
        ResourceBundleClassMessages messages = o.bundleClassMessages;
        Assertions.assertNotNull((Object)messages);
        Assertions.assertNotNull((Object)messages.message);
        Assertions.assertNotNull((Object)messages.message_one);
        Assertions.assertNotNull((Object)messages.messageOne);
        Assertions.assertNotNull((Object)messages.message_two);
        Assertions.assertNotNull((Object)messages.messageThree);
        Assertions.assertNotNull((Object)messages.messageFour);
        Assertions.assertNotNull((Object)messages.messageFive_Sub);
        Assertions.assertNotNull((Object)messages.messageSix_Sub);
        Assertions.assertNotNull((Object)messages.messageSeven_Sub);
        Assertions.assertNotNull((Object)messages.messageEight_Sub);
        Assertions.assertNotNull((Object)messages.messageNine_Sub);
        Assertions.assertEquals((Object)"ResourceBundleClassMessage", (Object)messages.message);
        Assertions.assertEquals((Object)"ResourceBundleClassMessageUnderscore", (Object)messages.message_one);
        Assertions.assertEquals((Object)"ResourceBundleClassMessageCamelCase", (Object)messages.messageOne);
        Assertions.assertEquals((Object)"ResourceBundleClassMessageUnderscoreDot", (Object)messages.message_two);
        Assertions.assertEquals((Object)"ResourceBundleClassCamelCaseDot", (Object)messages.messageThree);
        Assertions.assertEquals((Object)"The idea is from Tom", (Object)messages.messageFour);
        Assertions.assertEquals((Object)"ResourceBundleClassMessageCamelCaseAndUnderscoreOriginal", (Object)messages.messageFive_Sub);
        Assertions.assertEquals((Object)"ResourceBundleClassMessageCamelCaseAndUnderscoreDeCamelCasified", (Object)messages.messageSix_Sub);
        Assertions.assertEquals((Object)"ResourceBundleClassMessageCamelCaseAndUnderscoreDeCamelCasifiedAndDeUnderscorified", (Object)messages.messageSeven_Sub);
        Assertions.assertEquals((Object)"ResourceBundleClassMessageCamelCaseAndUnderscoreDeUnderscorified", (Object)messages.messageEight_Sub);
        Assertions.assertEquals((Object)"ResourceBundleClassMessageCamelCaseAndUnderscoreDeUnderscorifiedAndDeCamelCasified", (Object)messages.messageNine_Sub);
    }

    @Test
    public void testClassBasedResourceBundleUseDefaultLocaleForInvalidLocale() {
        Locale.setDefault(new Locale("de"));
        this.context.set("org.eclipse.e4.core.locale", (Object)Locale.FRENCH);
        TestResourceBundleClassObject o = (TestResourceBundleClassObject)ContextInjectionFactory.make(TestResourceBundleClassObject.class, (IEclipseContext)this.context);
        ResourceBundleClassMessages messages = o.bundleClassMessages;
        Assertions.assertNotNull((Object)messages);
        Assertions.assertNotNull((Object)messages.message);
        Assertions.assertNotNull((Object)messages.message_one);
        Assertions.assertNotNull((Object)messages.messageOne);
        Assertions.assertNotNull((Object)messages.message_two);
        Assertions.assertNotNull((Object)messages.messageThree);
        Assertions.assertNotNull((Object)messages.messageFour);
        Assertions.assertNotNull((Object)messages.messageFive_Sub);
        Assertions.assertNotNull((Object)messages.messageSix_Sub);
        Assertions.assertNotNull((Object)messages.messageSeven_Sub);
        Assertions.assertNotNull((Object)messages.messageEight_Sub);
        Assertions.assertNotNull((Object)messages.messageNine_Sub);
        Assertions.assertEquals((Object)"ResourceBundleClassNachricht", (Object)messages.message);
        Assertions.assertEquals((Object)"ResourceBundleClassNachrichtUnderscore", (Object)messages.message_one);
        Assertions.assertEquals((Object)"ResourceBundleClassNachrichtCamelCase", (Object)messages.messageOne);
        Assertions.assertEquals((Object)"ResourceBundleNachrichtMessageUnderscoreDot", (Object)messages.message_two);
        Assertions.assertEquals((Object)"ResourceBundleClassCamelCaseDot", (Object)messages.messageThree);
        Assertions.assertEquals((Object)"Die Idee ist von Tom", (Object)messages.messageFour);
        Assertions.assertEquals((Object)"ResourceBundleClassNachrichtCamelCaseAndUnderscoreOriginal", (Object)messages.messageFive_Sub);
        Assertions.assertEquals((Object)"ResourceBundleClassNachrichtCamelCaseAndUnderscoreDeCamelCasified", (Object)messages.messageSix_Sub);
        Assertions.assertEquals((Object)"ResourceBundleClassNachrichtCamelCaseAndUnderscoreDeCamelCasifiedAndDeUnderscorified", (Object)messages.messageSeven_Sub);
        Assertions.assertEquals((Object)"ResourceBundleClassNachrichtCamelCaseAndUnderscoreDeUnderscorified", (Object)messages.messageEight_Sub);
        Assertions.assertEquals((Object)"ResourceBundleClassNachrichtCamelCaseAndUnderscoreDeUnderscorifiedAndDeCamelCasified", (Object)messages.messageNine_Sub);
    }

    @Test
    public void testResourcesBundle() {
        this.context.set("org.eclipse.e4.core.locale", (Object)Locale.ENGLISH);
        TestResourcesBundleObject o = (TestResourcesBundleObject)ContextInjectionFactory.make(TestResourcesBundleObject.class, (IEclipseContext)this.context);
        ResourcesMessages messages = o.resourcesMessages;
        Assertions.assertNotNull((Object)messages);
        Assertions.assertNotNull((Object)messages.message);
        Assertions.assertNotNull((Object)messages.message_one);
        Assertions.assertNotNull((Object)messages.messageOne);
        Assertions.assertNotNull((Object)messages.message_two);
        Assertions.assertNotNull((Object)messages.messageThree);
        Assertions.assertNotNull((Object)messages.messageFour);
        Assertions.assertNotNull((Object)messages.messageFive_Sub);
        Assertions.assertNotNull((Object)messages.messageSix_Sub);
        Assertions.assertNotNull((Object)messages.messageSeven_Sub);
        Assertions.assertNotNull((Object)messages.messageEight_Sub);
        Assertions.assertNotNull((Object)messages.messageNine_Sub);
        Assertions.assertEquals((Object)"ResourcesMessage", (Object)messages.message);
        Assertions.assertEquals((Object)"ResourcesMessageUnderscore", (Object)messages.message_one);
        Assertions.assertEquals((Object)"ResourcesMessageCamelCase", (Object)messages.messageOne);
        Assertions.assertEquals((Object)"ResourcesMessageUnderscoreDot", (Object)messages.message_two);
        Assertions.assertEquals((Object)"ResourcesMessageCamelCaseDot", (Object)messages.messageThree);
        Assertions.assertEquals((Object)"The idea is from Tom", (Object)messages.messageFour);
        Assertions.assertEquals((Object)"ResourcesMessageCamelCaseAndUnderscoreOriginal", (Object)messages.messageFive_Sub);
        Assertions.assertEquals((Object)"ResourcesMessageCamelCaseAndUnderscoreDeCamelCasified", (Object)messages.messageSix_Sub);
        Assertions.assertEquals((Object)"ResourcesMessageCamelCaseAndUnderscoreDeCamelCasifiedAndDeUnderscorified", (Object)messages.messageSeven_Sub);
        Assertions.assertEquals((Object)"ResourcesMessageCamelCaseAndUnderscoreDeUnderscorified", (Object)messages.messageEight_Sub);
        Assertions.assertEquals((Object)"ResourcesMessageCamelCaseAndUnderscoreDeUnderscorifiedAndDeCamelCasified", (Object)messages.messageNine_Sub);
    }

    @Test
    public void testResourcesBundleDifferentLocale() {
        this.context.set("org.eclipse.e4.core.locale", (Object)Locale.GERMAN);
        TestResourcesBundleObject o = (TestResourcesBundleObject)ContextInjectionFactory.make(TestResourcesBundleObject.class, (IEclipseContext)this.context);
        ResourcesMessages messages = o.resourcesMessages;
        Assertions.assertNotNull((Object)messages);
        Assertions.assertNotNull((Object)messages.message);
        Assertions.assertNotNull((Object)messages.message_one);
        Assertions.assertNotNull((Object)messages.messageOne);
        Assertions.assertNotNull((Object)messages.message_two);
        Assertions.assertNotNull((Object)messages.messageThree);
        Assertions.assertNotNull((Object)messages.messageFour);
        Assertions.assertNotNull((Object)messages.messageFive_Sub);
        Assertions.assertNotNull((Object)messages.messageSix_Sub);
        Assertions.assertNotNull((Object)messages.messageSeven_Sub);
        Assertions.assertNotNull((Object)messages.messageEight_Sub);
        Assertions.assertNotNull((Object)messages.messageNine_Sub);
        Assertions.assertEquals((Object)"ResourcesNachricht", (Object)messages.message);
        Assertions.assertEquals((Object)"ResourcesNachrichtUnderscore", (Object)messages.message_one);
        Assertions.assertEquals((Object)"ResourcesNachrichtCamelCase", (Object)messages.messageOne);
        Assertions.assertEquals((Object)"ResourcesNachrichtUnderscoreDot", (Object)messages.message_two);
        Assertions.assertEquals((Object)"ResourcesMessageCamelCaseDot", (Object)messages.messageThree);
        Assertions.assertEquals((Object)"Die Idee ist von Tom", (Object)messages.messageFour);
        Assertions.assertEquals((Object)"ResourcesNachrichtCamelCaseAndUnderscoreOriginal", (Object)messages.messageFive_Sub);
        Assertions.assertEquals((Object)"ResourcesNachrichtCamelCaseAndUnderscoreDeCamelCasified", (Object)messages.messageSix_Sub);
        Assertions.assertEquals((Object)"ResourcesNachrichtCamelCaseAndUnderscoreDeCamelCasifiedAndDeUnderscorified", (Object)messages.messageSeven_Sub);
        Assertions.assertEquals((Object)"ResourcesNachrichtCamelCaseAndUnderscoreDeUnderscorified", (Object)messages.messageEight_Sub);
        Assertions.assertEquals((Object)"ResourcesNachrichtCamelCaseAndUnderscoreDeUnderscorifiedAndDeCamelCasified", (Object)messages.messageNine_Sub);
    }

    @Test
    public void testResourcesBundleSkipDefaultLocaleForEquinoxRoot() {
        Locale.setDefault(new Locale("de"));
        this.context.set("org.eclipse.e4.core.locale", (Object)Locale.ENGLISH);
        TestResourcesBundleObject o = (TestResourcesBundleObject)ContextInjectionFactory.make(TestResourcesBundleObject.class, (IEclipseContext)this.context);
        ResourcesMessages messages = o.resourcesMessages;
        Assertions.assertNotNull((Object)messages);
        Assertions.assertNotNull((Object)messages.message);
        Assertions.assertNotNull((Object)messages.message_one);
        Assertions.assertNotNull((Object)messages.messageOne);
        Assertions.assertNotNull((Object)messages.message_two);
        Assertions.assertNotNull((Object)messages.messageThree);
        Assertions.assertNotNull((Object)messages.messageFour);
        Assertions.assertNotNull((Object)messages.messageFive_Sub);
        Assertions.assertNotNull((Object)messages.messageSix_Sub);
        Assertions.assertNotNull((Object)messages.messageSeven_Sub);
        Assertions.assertNotNull((Object)messages.messageEight_Sub);
        Assertions.assertNotNull((Object)messages.messageNine_Sub);
        Assertions.assertEquals((Object)"ResourcesMessage", (Object)messages.message);
        Assertions.assertEquals((Object)"ResourcesMessageUnderscore", (Object)messages.message_one);
        Assertions.assertEquals((Object)"ResourcesMessageCamelCase", (Object)messages.messageOne);
        Assertions.assertEquals((Object)"ResourcesMessageUnderscoreDot", (Object)messages.message_two);
        Assertions.assertEquals((Object)"ResourcesMessageCamelCaseDot", (Object)messages.messageThree);
        Assertions.assertEquals((Object)"The idea is from Tom", (Object)messages.messageFour);
        Assertions.assertEquals((Object)"ResourcesMessageCamelCaseAndUnderscoreOriginal", (Object)messages.messageFive_Sub);
        Assertions.assertEquals((Object)"ResourcesMessageCamelCaseAndUnderscoreDeCamelCasified", (Object)messages.messageSix_Sub);
        Assertions.assertEquals((Object)"ResourcesMessageCamelCaseAndUnderscoreDeCamelCasifiedAndDeUnderscorified", (Object)messages.messageSeven_Sub);
        Assertions.assertEquals((Object)"ResourcesMessageCamelCaseAndUnderscoreDeUnderscorified", (Object)messages.messageEight_Sub);
        Assertions.assertEquals((Object)"ResourcesMessageCamelCaseAndUnderscoreDeUnderscorifiedAndDeCamelCasified", (Object)messages.messageNine_Sub);
    }

    @Test
    public void testResourcesBundleUseDefaultLocaleForInvalidLocale() {
        Locale.setDefault(new Locale("de"));
        this.context.set("org.eclipse.e4.core.locale", (Object)Locale.FRENCH);
        TestResourcesBundleObject o = (TestResourcesBundleObject)ContextInjectionFactory.make(TestResourcesBundleObject.class, (IEclipseContext)this.context);
        ResourcesMessages messages = o.resourcesMessages;
        Assertions.assertNotNull((Object)messages);
        Assertions.assertNotNull((Object)messages.message);
        Assertions.assertNotNull((Object)messages.message_one);
        Assertions.assertNotNull((Object)messages.messageOne);
        Assertions.assertNotNull((Object)messages.message_two);
        Assertions.assertNotNull((Object)messages.messageThree);
        Assertions.assertNotNull((Object)messages.messageFour);
        Assertions.assertNotNull((Object)messages.messageFive_Sub);
        Assertions.assertNotNull((Object)messages.messageSix_Sub);
        Assertions.assertNotNull((Object)messages.messageSeven_Sub);
        Assertions.assertNotNull((Object)messages.messageEight_Sub);
        Assertions.assertNotNull((Object)messages.messageNine_Sub);
        Assertions.assertEquals((Object)"ResourcesNachricht", (Object)messages.message);
        Assertions.assertEquals((Object)"ResourcesNachrichtUnderscore", (Object)messages.message_one);
        Assertions.assertEquals((Object)"ResourcesNachrichtCamelCase", (Object)messages.messageOne);
        Assertions.assertEquals((Object)"ResourcesNachrichtUnderscoreDot", (Object)messages.message_two);
        Assertions.assertEquals((Object)"ResourcesMessageCamelCaseDot", (Object)messages.messageThree);
        Assertions.assertEquals((Object)"Die Idee ist von Tom", (Object)messages.messageFour);
        Assertions.assertEquals((Object)"ResourcesNachrichtCamelCaseAndUnderscoreOriginal", (Object)messages.messageFive_Sub);
        Assertions.assertEquals((Object)"ResourcesNachrichtCamelCaseAndUnderscoreDeCamelCasified", (Object)messages.messageSix_Sub);
        Assertions.assertEquals((Object)"ResourcesNachrichtCamelCaseAndUnderscoreDeCamelCasifiedAndDeUnderscorified", (Object)messages.messageSeven_Sub);
        Assertions.assertEquals((Object)"ResourcesNachrichtCamelCaseAndUnderscoreDeUnderscorified", (Object)messages.messageEight_Sub);
        Assertions.assertEquals((Object)"ResourcesNachrichtCamelCaseAndUnderscoreDeUnderscorifiedAndDeCamelCasified", (Object)messages.messageNine_Sub);
    }

    static class TestBundleObject {
        @Inject
        @Translation
        BundleMessages bundleMessages;

        TestBundleObject() {
        }
    }

    static class TestMessagesObject {
        @Inject
        @Translation
        Messages Messages;

        TestMessagesObject() {
        }
    }

    static class TestResourceBundleClassObject {
        @Inject
        @Translation
        ResourceBundleClassMessages bundleClassMessages;

        TestResourceBundleClassObject() {
        }
    }

    static class TestResourcesBundleObject {
        @Inject
        @Translation
        ResourcesMessages resourcesMessages;

        TestResourcesBundleObject() {
        }
    }

    static class TestSimpleObject {
        @Inject
        @Translation
        SimpleMessages simpleMessages;

        TestSimpleObject() {
        }
    }
}

