/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.filesystem;

import java.io.File;
import java.net.URI;
import java.util.UUID;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.tests.filesystem.FileStoreCreationRule;
import org.eclipse.core.tests.filesystem.FileSystemTestUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class CreateDirectoryTest {
    protected IFileStore topDir;
    protected IFileStore subDir;
    protected IFileStore file;
    protected IFileStore subFile;
    @Rule
    public final FileStoreCreationRule localFileStoreRule = new FileStoreCreationRule(FileStoreCreationRule.FileSystemType.LOCAL);
    @Rule
    public final FileStoreCreationRule inMemoryFileStoreRule = new FileStoreCreationRule(FileStoreCreationRule.FileSystemType.IN_MEMORY);

    @Before
    public void setUp() throws Exception {
        IFileStore baseStore = this.inMemoryFileStoreRule.getFileStore();
        baseStore.mkdir(0, null);
        this.topDir = baseStore.getChild("topDir");
        this.subDir = this.topDir.getChild("subDir");
        this.file = baseStore.getChild("file");
        this.subFile = this.file.getChild("subFile");
        FileSystemTestUtil.ensureExists(this.topDir.getParent(), true);
        FileSystemTestUtil.ensureDoesNotExist(this.topDir);
        FileSystemTestUtil.ensureDoesNotExist(this.file);
    }

    @After
    public void tearDown() throws Exception {
        FileSystemTestUtil.ensureDoesNotExist(this.topDir);
        FileSystemTestUtil.ensureDoesNotExist(this.file);
    }

    @Test
    public void testParentExistsDeep() throws Exception {
        this.topDir.mkdir(0, FileSystemTestUtil.getMonitor());
        IFileInfo info = this.topDir.fetchInfo();
        Assert.assertTrue((String)"1.1", (boolean)info.exists());
        Assert.assertTrue((String)"1.2", (boolean)info.isDirectory());
    }

    @Test
    public void testParentExistsShallow() throws Exception {
        this.topDir.mkdir(4, FileSystemTestUtil.getMonitor());
        IFileInfo info = this.topDir.fetchInfo();
        Assert.assertTrue((String)"2.1", (boolean)info.exists());
        Assert.assertTrue((String)"2.2", (boolean)info.isDirectory());
    }

    @Test
    public void testParentFileDeep() throws Exception {
        FileSystemTestUtil.ensureExists(this.file, false);
        Assert.assertThrows(CoreException.class, () -> {
            IFileStore iFileStore = this.subFile.mkdir(0, FileSystemTestUtil.getMonitor());
        });
        IFileInfo info = this.subFile.fetchInfo();
        Assert.assertTrue((String)"2.1", (!info.exists() ? 1 : 0) != 0);
        Assert.assertTrue((String)"2.2", (!info.isDirectory() ? 1 : 0) != 0);
    }

    @Test
    public void testParentFileShallow() throws Exception {
        FileSystemTestUtil.ensureExists(this.file, false);
        Assert.assertThrows(CoreException.class, () -> {
            IFileStore iFileStore = this.subFile.mkdir(4, FileSystemTestUtil.getMonitor());
        });
        IFileInfo info = this.subFile.fetchInfo();
        Assert.assertTrue((String)"2.1", (!info.exists() ? 1 : 0) != 0);
        Assert.assertTrue((String)"2.2", (!info.isDirectory() ? 1 : 0) != 0);
    }

    @Test
    public void testParentNotExistsDeep() throws Exception {
        this.subDir.mkdir(0, FileSystemTestUtil.getMonitor());
        IFileInfo info = this.topDir.fetchInfo();
        Assert.assertTrue((String)"1.1", (boolean)info.exists());
        Assert.assertTrue((String)"1.2", (boolean)info.isDirectory());
        info = this.subDir.fetchInfo();
        Assert.assertTrue((String)"1.3", (boolean)info.exists());
        Assert.assertTrue((String)"1.4", (boolean)info.isDirectory());
    }

    @Test
    public void testParentNotExistsShallow() {
        Assert.assertThrows(CoreException.class, () -> {
            IFileStore iFileStore = this.subDir.mkdir(4, FileSystemTestUtil.getMonitor());
        });
        IFileInfo info = this.topDir.fetchInfo();
        Assert.assertTrue((String)"1.1", (!info.exists() ? 1 : 0) != 0);
        Assert.assertTrue((String)"1.2", (!info.isDirectory() ? 1 : 0) != 0);
        info = this.subDir.fetchInfo();
        Assert.assertTrue((String)"1.3", (!info.exists() ? 1 : 0) != 0);
        Assert.assertTrue((String)"1.4", (!info.isDirectory() ? 1 : 0) != 0);
    }

    @Test
    public void testParentNotExistsShallowInLocalFile() throws CoreException {
        IFileStore localFileBaseStore = this.localFileStoreRule.getFileStore();
        localFileBaseStore.delete(0, FileSystemTestUtil.getMonitor());
        CoreException e = (CoreException)Assert.assertThrows(CoreException.class, () -> {
            IFileStore localFileTopDir = localFileBaseStore.getChild("topDir");
            localFileTopDir.mkdir(4, FileSystemTestUtil.getMonitor());
        });
        Assert.assertNotNull((String)"1.1", (Object)e.getStatus());
        Assert.assertEquals((String)"1.2", (long)269L, (long)e.getStatus().getCode());
    }

    @Test
    public void testTargetIsFileInLocalFile() throws Exception {
        IFileStore localFileBaseStore = this.localFileStoreRule.getFileStore();
        localFileBaseStore.delete(0, FileSystemTestUtil.getMonitor());
        CoreException e = (CoreException)Assert.assertThrows(CoreException.class, () -> {
            FileSystemTestUtil.ensureExists(localFileBaseStore, true);
            IFileStore localFileTopDir = localFileBaseStore.getChild("topDir");
            FileSystemTestUtil.ensureExists(localFileTopDir, false);
            localFileTopDir.mkdir(4, FileSystemTestUtil.getMonitor());
            Assert.fail((String)"1.99");
        });
        Assert.assertNotNull((String)"1.1", (Object)e.getStatus());
        Assert.assertEquals((String)"1.2", (long)276L, (long)e.getStatus().getCode());
    }

    @Test
    public void testParentDeviceNotExistsInLocalFile() {
        if (!Platform.getOS().equals("win32")) {
            return;
        }
        String device = this.findNonExistingDevice();
        if (device == null) {
            return;
        }
        try {
            IFileStore localFileTopDir = EFS.getStore((URI)URI.create("file:/" + device + ":" + String.valueOf(UUID.randomUUID())));
            localFileTopDir.mkdir(4, FileSystemTestUtil.getMonitor());
            Assert.fail((String)"1.99");
        }
        catch (CoreException e) {
            Assert.assertNotNull((String)"1.1", (Object)e.getStatus());
            Assert.assertEquals((String)"1.2", (long)272L, (long)e.getStatus().getCode());
        }
    }

    private String findNonExistingDevice() {
        String device = null;
        int i = 97;
        while (i < 123) {
            char c = (char)i;
            if (!new File(c + ":\\").exists()) {
                device = "" + c;
                break;
            }
            ++i;
        }
        return device;
    }
}

