/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.filesystem;

import java.io.File;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.tests.filesystem.FileStoreCreationRule;
import org.eclipse.core.tests.filesystem.FileSystemTestUtil;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class DeleteTest {
    @Rule
    public final FileStoreCreationRule localFileStoreRule = new FileStoreCreationRule(FileStoreCreationRule.FileSystemType.LOCAL);
    @Rule
    public final FileStoreCreationRule inMemoryFileStoreRule = new FileStoreCreationRule(FileStoreCreationRule.FileSystemType.IN_MEMORY);

    @Test
    public void testDeleteFile() throws Exception {
        IFileStore baseStore = this.inMemoryFileStoreRule.getFileStore();
        IFileStore file = baseStore.getChild("child");
        FileSystemTestUtil.ensureExists(file, false);
        Assert.assertTrue((String)"1.0", (boolean)file.fetchInfo().exists());
        file.delete(0, FileSystemTestUtil.getMonitor());
        Assert.assertTrue((String)"1.1", (!file.fetchInfo().exists() ? 1 : 0) != 0);
    }

    @Test
    public void testDeleteDirectory() throws Exception {
        IFileStore baseStore = this.inMemoryFileStoreRule.getFileStore();
        IFileStore dir = baseStore.getChild("child");
        FileSystemTestUtil.ensureExists(dir, true);
        Assert.assertTrue((String)"1.0", (boolean)dir.fetchInfo().exists());
        dir.delete(0, FileSystemTestUtil.getMonitor());
        Assert.assertTrue((String)"1.1", (!dir.fetchInfo().exists() ? 1 : 0) != 0);
    }

    @Test
    public void testDeleteReadOnlyFile() throws Exception {
        IFileStore localFileBaseStore = this.localFileStoreRule.getFileStore();
        FileSystemTestUtil.ensureExists(localFileBaseStore, true);
        IFileStore file = localFileBaseStore.getChild("child");
        FileSystemTestUtil.ensureExists(file, false);
        Assert.assertTrue((String)"1.0", (boolean)file.fetchInfo().exists());
        this.ensureReadOnlyLocal(file);
        file.delete(0, FileSystemTestUtil.getMonitor());
        Assert.assertTrue((String)"1.1", (!file.fetchInfo().exists() ? 1 : 0) != 0);
    }

    protected void ensureReadOnlyLocal(IFileStore store) throws Exception {
        File localFile = store.toLocalFile(0, FileSystemTestUtil.getMonitor());
        boolean readOnly = localFile.setReadOnly();
        Assert.assertTrue((String)"1.0", (boolean)readOnly);
        Assert.assertFalse((String)"1.1", (boolean)localFile.canWrite());
    }
}

