/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.filesystem;

import java.io.File;
import java.io.OutputStream;
import java.nio.file.Files;
import org.assertj.core.api.Assertions;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.tests.filesystem.FileSystemTestUtil;
import org.eclipse.core.tests.internal.filesystem.ram.MemoryFileStore;
import org.eclipse.core.tests.internal.filesystem.ram.MemoryTree;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FileCacheTest {
    @Before
    public void setUp() throws Exception {
        MemoryTree.TREE.deleteAll();
    }

    @After
    public void tearDown() throws Exception {
        MemoryTree.TREE.deleteAll();
    }

    @Test
    public void testCacheFile() throws Exception {
        MemoryFileStore store = new MemoryFileStore(IPath.fromOSString((String)"testCacheFile"));
        byte[] contents = "test".getBytes();
        Throwable throwable = null;
        Object var4_5 = null;
        try (OutputStream out = store.openOutputStream(0, FileSystemTestUtil.getMonitor());){
            out.write(contents);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        File cachedFile = store.toLocalFile(4096, FileSystemTestUtil.getMonitor());
        Assert.assertTrue((String)"1.0", (boolean)cachedFile.exists());
        Assert.assertTrue((String)"1.1", (!cachedFile.isDirectory() ? 1 : 0) != 0);
        Assertions.assertThat((byte[])Files.readAllBytes(cachedFile.toPath())).containsExactly(contents);
        byte[] newContents = "newContents".getBytes();
        Throwable throwable3 = null;
        Object var6_9 = null;
        try (OutputStream out = store.openOutputStream(0, FileSystemTestUtil.getMonitor());){
            out.write(newContents);
        }
        catch (Throwable throwable4) {
            if (throwable3 == null) {
                throwable3 = throwable4;
            } else if (throwable3 != throwable4) {
                throwable3.addSuppressed(throwable4);
            }
            throw throwable3;
        }
        Assertions.assertThat((byte[])newContents).isNotEqualTo((Object)Files.readAllBytes(cachedFile.toPath()));
        cachedFile = store.toLocalFile(4096, FileSystemTestUtil.getMonitor());
        Assert.assertTrue((String)"3.0", (boolean)cachedFile.exists());
        Assert.assertTrue((String)"3.1", (!cachedFile.isDirectory() ? 1 : 0) != 0);
        Assertions.assertThat((byte[])Files.readAllBytes(cachedFile.toPath())).containsExactly(newContents);
    }

    @Test
    public void testCacheFolder() throws Exception {
        MemoryFileStore store = new MemoryFileStore(IPath.fromOSString((String)"testCacheFolder"));
        store.mkdir(0, FileSystemTestUtil.getMonitor());
        File cachedFile = store.toLocalFile(4096, FileSystemTestUtil.getMonitor());
        Assert.assertTrue((String)"1.0", (boolean)cachedFile.exists());
        Assert.assertTrue((String)"1.1", (boolean)cachedFile.isDirectory());
    }

    @Test
    public void testNoCacheFlag() throws Exception {
        MemoryFileStore store = new MemoryFileStore(IPath.fromOSString((String)"testNoCacheFlag"));
        store.mkdir(0, FileSystemTestUtil.getMonitor());
        File cachedFile = store.toLocalFile(0, FileSystemTestUtil.getMonitor());
        Assert.assertNull((String)"1.0", (Object)cachedFile);
    }

    @Test
    public void testNonExisting() throws Exception {
        MemoryFileStore store = new MemoryFileStore(IPath.fromOSString((String)"testNonExisting"));
        File cachedFile = store.toLocalFile(4096, FileSystemTestUtil.getMonitor());
        Assert.assertTrue((String)"1.0", (!cachedFile.exists() ? 1 : 0) != 0);
    }
}

