/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.filesystem;

import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.tests.harness.FileSystemHelper;
import org.eclipse.core.tests.internal.filesystem.ram.MemoryTree;
import org.eclipse.core.tests.resources.TestUtil;
import org.junit.rules.ExternalResource;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class FileStoreCreationRule
extends ExternalResource {
    private final FileSystemType fileSystemType;
    private String testName;
    private IFileStore fileStore;

    public FileStoreCreationRule(FileSystemType fileSystemType) {
        this.fileSystemType = fileSystemType;
    }

    public IFileStore getFileStore() {
        return this.fileStore;
    }

    public Statement apply(Statement base, Description description) {
        this.testName = description.getDisplayName();
        return super.apply(base, description);
    }

    protected void before() throws Throwable {
        switch (this.fileSystemType) {
            case LOCAL: {
                IPath fileStoreLocation = FileSystemHelper.getRandomLocation((IPath)FileSystemHelper.getTempDir()).append("/" + this.testName);
                this.fileStore = EFS.getLocalFileSystem().getStore(fileStoreLocation);
                break;
            }
            case IN_MEMORY: {
                MemoryTree.TREE.deleteAll();
                this.fileStore = EFS.getStore((URI)URI.create("mem:/baseStore"));
            }
        }
        this.fileStore.mkdir(0, null);
    }

    protected void after() {
        try {
            this.fileStore.delete(0, null);
        }
        catch (CoreException e) {
            TestUtil.log(4, this.testName, "Could not delete file store: " + String.valueOf(this.fileStore), e);
        }
        switch (this.fileSystemType) {
            case IN_MEMORY: {
                MemoryTree.TREE.deleteAll();
            }
        }
    }

    public static enum FileSystemType {
        LOCAL,
        IN_MEMORY;

    }
}

