/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.filesystem;

import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.tests.harness.FussyProgressMonitor;
import org.junit.Assert;

final class FileSystemTestUtil {
    private FileSystemTestUtil() {
    }

    static void ensureDoesNotExist(IFileStore store) throws CoreException {
        store.delete(0, FileSystemTestUtil.getMonitor());
        Assert.assertTrue((String)("store was not properly deleted: " + String.valueOf(store)), (!store.fetchInfo().exists() ? 1 : 0) != 0);
    }

    static void ensureExists(IFileStore store, boolean directory) throws CoreException, IOException {
        if (directory) {
            store.mkdir(0, FileSystemTestUtil.getMonitor());
            IFileInfo info = store.fetchInfo();
            Assert.assertTrue((String)("file info for store does not exist: " + String.valueOf(store)), (boolean)info.exists());
            Assert.assertTrue((String)("created file for store is not a directory: " + String.valueOf(store)), (boolean)info.isDirectory());
        } else {
            Throwable info = null;
            Object var3_5 = null;
            try (OutputStream out = store.openOutputStream(0, FileSystemTestUtil.getMonitor());){
                out.write(5);
            }
            catch (Throwable throwable) {
                if (info == null) {
                    info = throwable;
                } else if (info != throwable) {
                    info.addSuppressed(throwable);
                }
                throw info;
            }
            info = store.fetchInfo();
            Assert.assertTrue((String)("file info for store does not exist: " + String.valueOf(store)), (boolean)info.exists());
            Assert.assertTrue((String)("created file for store is not a directory: " + String.valueOf(store)), (!info.isDirectory() ? 1 : 0) != 0);
        }
    }

    static IProgressMonitor getMonitor() {
        return new FussyProgressMonitor();
    }
}

