/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.filesystem;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.provider.FileInfo;
import org.eclipse.core.filesystem.provider.FileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

class OnCloseWritingFileStore
extends FileStore {
    private final Path filePath;

    public OnCloseWritingFileStore(Path file) {
        this.filePath = file;
    }

    public OutputStream openOutputStream(int options, IProgressMonitor monitor) {
        return new ByteArrayOutputStream(){

            @Override
            public void close() throws IOException {
                Files.write(OnCloseWritingFileStore.this.filePath, this.toByteArray(), new OpenOption[0]);
            }
        };
    }

    public void putInfo(IFileInfo info, int options, IProgressMonitor monitor) throws CoreException {
        if ((options & 0x800) != 0) {
            FileTime lastModified = FileTime.fromMillis(info.getLastModified());
            try {
                Files.setLastModifiedTime(this.filePath, lastModified);
            }
            catch (IOException e) {
                if (!Files.exists(this.filePath, LinkOption.NOFOLLOW_LINKS)) {
                    throw new CoreException((IStatus)new Status(4, "CopyBugFileStore", "File does not exist", (Throwable)e));
                }
                throw new CoreException((IStatus)new Status(4, "CopyBugFileStore", "Failed to set attribute", (Throwable)e));
            }
        }
    }

    public IFileInfo fetchInfo(int options, IProgressMonitor monitor) throws CoreException {
        FileInfo info = new FileInfo();
        try {
            info.setLastModified(Files.getLastModifiedTime(this.filePath, new LinkOption[0]).toMillis());
            info.setLength(Files.size(this.filePath));
            info.setExists(Files.exists(this.filePath, new LinkOption[0]));
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "TestFileStore", "Failed to fetch file info", (Throwable)e));
        }
        return info;
    }

    public String getName() {
        return this.filePath.getFileName().toString();
    }

    public IFileStore getParent() {
        throw new UnsupportedOperationException();
    }

    public String[] childNames(int options, IProgressMonitor monitor) throws CoreException {
        throw new UnsupportedOperationException();
    }

    public IFileStore getChild(String name) {
        throw new UnsupportedOperationException();
    }

    public InputStream openInputStream(int options, IProgressMonitor monitor) throws CoreException {
        throw new UnsupportedOperationException();
    }

    public URI toURI() {
        throw new UnsupportedOperationException();
    }
}

