/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.filesystem;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.tests.filesystem.FileStoreCreationRule;
import org.eclipse.core.tests.filesystem.FileSystemTestUtil;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class OpenOutputStreamTest {
    @Rule
    public final FileStoreCreationRule fileStoreRule = new FileStoreCreationRule(FileStoreCreationRule.FileSystemType.IN_MEMORY);

    @Test
    public void testAppend() throws Exception {
        OutputStream out;
        IFileStore baseStore = this.fileStoreRule.getFileStore();
        IFileStore file = baseStore.getChild("file");
        FileSystemTestUtil.ensureDoesNotExist(file);
        boolean BYTE_ONE = true;
        int BYTE_TWO = 2;
        int EOF = -1;
        Throwable throwable = null;
        Object var7_10 = null;
        try {
            out = file.openOutputStream(1, FileSystemTestUtil.getMonitor());
            try {
                out.write(1);
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        throwable = null;
        var7_10 = null;
        try {
            out = file.openOutputStream(1, FileSystemTestUtil.getMonitor());
            try {
                out.write(2);
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        throwable = null;
        var7_10 = null;
        try (InputStream in = file.openInputStream(0, FileSystemTestUtil.getMonitor());){
            Assert.assertEquals((String)"1.0", (long)1L, (long)in.read());
            Assert.assertEquals((String)"1.1", (long)2L, (long)in.read());
            Assert.assertEquals((String)"1.2", (long)-1L, (long)in.read());
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    @Test
    public void testParentExists() throws Exception {
        IFileStore baseStore = this.fileStoreRule.getFileStore();
        IFileStore file = baseStore.getChild("file");
        FileSystemTestUtil.ensureDoesNotExist(file);
        Throwable throwable = null;
        Object var4_5 = null;
        try (OutputStream out = file.openOutputStream(0, FileSystemTestUtil.getMonitor());){
            out.write(1);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        IFileInfo info = file.fetchInfo();
        OpenOutputStreamTest.assertExists(file);
        Assert.assertTrue((String)"1.1", (!info.isDirectory() ? 1 : 0) != 0);
        Assert.assertEquals((String)"1.2", (Object)file.getName(), (Object)info.getName());
    }

    private static void assertExists(IFileStore store) throws CoreException {
        IFileInfo info = store.fetchInfo();
        Assert.assertTrue((String)("store has no file info: " + String.valueOf(store)), (boolean)info.exists());
        IFileInfo[] children = store.getParent().childInfos(0, FileSystemTestUtil.getMonitor());
        List childrenNames = Stream.of(children).map(IFileInfo::getName).collect(Collectors.toList());
        Assertions.assertThat(childrenNames).contains((Object[])new String[]{store.getName()});
    }

    @Test
    public void testParentNotExists() throws CoreException {
        IFileStore baseStore = this.fileStoreRule.getFileStore();
        IFileStore dir = baseStore.getChild("dir");
        IFileStore file = dir.getChild("file");
        FileSystemTestUtil.ensureDoesNotExist(dir);
        Assert.assertThrows(CoreException.class, () -> {
            file.openOutputStream(0, FileSystemTestUtil.getMonitor());
            Assert.fail((String)"1.0");
        });
        IFileInfo info = file.fetchInfo();
        Assert.assertTrue((String)"1.1", (!info.exists() ? 1 : 0) != 0);
        Assert.assertTrue((String)"1.2", (!info.isDirectory() ? 1 : 0) != 0);
    }
}

