/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.filesystem;

import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.tests.filesystem.FileStoreCreationRule;
import org.eclipse.core.tests.filesystem.FileSystemTestUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class PutInfoTest {
    @Rule
    public final FileStoreCreationRule fileStoreRule = new FileStoreCreationRule(FileStoreCreationRule.FileSystemType.IN_MEMORY);

    @Before
    public void setupStoreDirectory() throws Exception {
        IFileStore baseStore = this.fileStoreRule.getFileStore();
        baseStore.mkdir(0, null);
    }

    @Test
    public void testSetFileLastModified() throws Exception {
        IFileStore baseStore = this.fileStoreRule.getFileStore();
        IFileStore file = baseStore.getChild("file");
        FileSystemTestUtil.ensureExists(file, false);
        IFileInfo info = file.fetchInfo();
        long oldLastModified = info.getLastModified();
        long newLastModified = oldLastModified + 100L;
        info = EFS.createFileInfo();
        info.setLastModified(newLastModified);
        file.putInfo(info, 2048, FileSystemTestUtil.getMonitor());
        info = file.fetchInfo();
        Assert.assertEquals((String)"1.0", (long)newLastModified, (long)info.getLastModified());
        Assert.assertEquals((String)"1.1", (Object)file.getName(), (Object)info.getName());
    }

    @Test
    public void testSetReadOnly() throws Exception {
        IFileStore baseStore = this.fileStoreRule.getFileStore();
        IFileStore file = baseStore.getChild("file");
        FileSystemTestUtil.ensureExists(file, false);
        IFileInfo info = EFS.createFileInfo();
        info.setAttribute(2, true);
        file.putInfo(info, 1024, FileSystemTestUtil.getMonitor());
        info = file.fetchInfo();
        Assert.assertEquals((String)"1.0", (Object)true, (Object)info.getAttribute(2));
        Assert.assertEquals((String)"1.1", (Object)file.getName(), (Object)info.getName());
    }
}

